/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPLambdaExpressionParameter
extends PlatformObject
implements ICPPParameter {
    private IType fType = null;
    private IASTName fDeclaration = null;

    public CPPLambdaExpressionParameter(IASTName name) {
        this.fDeclaration = name;
    }

    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.fDeclaration.getSimpleID();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fDeclaration);
    }

    public IType getType() {
        if (this.fType == null) {
            IASTNode parent = this.fDeclaration.getParent();
            while (parent != null) {
                if (parent instanceof ICPPASTParameterDeclaration) {
                    this.fType = CPPVisitor.createType((ICPPASTParameterDeclaration)parent, false);
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.fType;
    }

    public boolean isStatic() {
        return false;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    public boolean isGloballyQualified() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    private boolean hasStorageClass(int storage) {
        IASTDeclSpecifier declSpec;
        IASTNode parent = this.fDeclaration.getParent();
        while (parent != null && !(parent instanceof IASTParameterDeclaration)) {
            parent = parent.getParent();
        }
        return parent != null && (declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage;
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public boolean isExternC() {
        return false;
    }

    public String toString() {
        String name = this.getName();
        return name.length() != 0 ? name : "<unnamed>";
    }

    public IBinding getOwner() {
        IType type;
        IASTNode node = this.fDeclaration;
        while (node != null && !(node instanceof ICPPASTLambdaExpression)) {
            node = node.getParent();
        }
        if (node instanceof ICPPASTLambdaExpression && (type = ((ICPPASTLambdaExpression)node).getExpressionType()) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return null;
    }

    public IValue getInitialValue() {
        return null;
    }
}

