/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PDOMProjectIndexLocationConverter
implements IIndexLocationConverter {
    private static final String EXTERNAL = "<EXT>";
    private static final String WS = "<WS>";
    private final IWorkspaceRoot fRoot;
    private final String fFullPathPrefix;
    private final boolean fIgnoreExternal;

    public PDOMProjectIndexLocationConverter(IProject project) {
        this(project, false);
    }

    public PDOMProjectIndexLocationConverter(IProject project, boolean ignoreWSExternal) {
        this.fRoot = (IWorkspaceRoot)project.getParent();
        this.fFullPathPrefix = String.valueOf(project.getFullPath().toString()) + '/';
        this.fIgnoreExternal = ignoreWSExternal;
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        String fullPath = null;
        URI uri = null;
        if (raw.startsWith(EXTERNAL)) {
            try {
                uri = new URI(raw.substring(EXTERNAL.length()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            fullPath = raw.startsWith(WS) ? raw.substring(WS.length()) : String.valueOf(this.fFullPathPrefix) + raw;
            Path path = new Path(fullPath);
            if (path.segmentCount() > 1) {
                IFile member = this.fRoot.getFile((IPath)path);
                uri = member.getLocationURI();
            }
        }
        return uri == null ? null : new IndexFileLocation(uri, fullPath);
    }

    public String toInternalFormat(IIndexFileLocation location) {
        String fullPath = location.getFullPath();
        if (fullPath != null) {
            if (fullPath.startsWith(this.fFullPathPrefix)) {
                return fullPath.substring(this.fFullPathPrefix.length());
            }
            return WS + fullPath;
        }
        if (this.fIgnoreExternal) {
            return null;
        }
        return EXTERNAL + location.getURI().toString();
    }
}

