/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.cdtvariables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;

public class CdtVariableResolver {
    private static final String EMPTY_STRING = "";
    public static final String VARIABLE_PREFIX = "${";
    private static final String VARIABLE_PREFIX_MASKED = "$\u0001";
    public static final char VARIABLE_SUFFIX = '}';
    private static final char VARIABLE_SUFFIX_MASKED = '\u0002';
    public static final char VARIABLE_ESCAPE_CHAR = '\\';
    private static final char VARIABLE_ESCAPE_CHAR_MASKED = '\u0003';
    private static final String RE_VPREFIX = "\\$\\{";
    private static final String RE_VSUFFIX = "\\}";
    private static final String RE_VNAME = "[^${}]*";
    private static final String RE_BSLASH = "[\\\\]";

    public static String convertStringListToString(String[] value, String listDelimiter) {
        if (value == null || value.length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buffer.append(value[i]);
            if (listDelimiter != null && !EMPTY_STRING.equals(listDelimiter) && i < value.length - 1) {
                buffer.append(listDelimiter);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String resolveToString(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        if (string == null) {
            return EMPTY_STRING;
        }
        Pattern pattern = Pattern.compile(".*?([\\\\]*)(\\$\\{([^${}]*)\\}).*");
        StringBuffer buffer = new StringBuffer(string);
        int limit = string.length();
        Matcher matcher = pattern.matcher(buffer);
        while (matcher.matches()) {
            String resolved;
            String bSlashes = matcher.group(1);
            String macro = matcher.group(2);
            String name = matcher.group(3);
            String string2 = resolved = name.length() > 0 ? substitutor.resolveToString(name) : EMPTY_STRING;
            if (resolved == null) {
                throw new CdtVariableException(1, null, string, name);
            }
            if (limit-- < 0) {
                throw new CdtVariableException(-1, name, matcher.group(0), resolved);
            }
            int nBSlashes = bSlashes.length();
            if ((nBSlashes & 1) == 1) {
                resolved = macro;
            }
            resolved = resolved.replace(VARIABLE_PREFIX, VARIABLE_PREFIX_MASKED);
            resolved = resolved.replace('}', '\u0002');
            buffer.replace(matcher.start(2), matcher.end(2), resolved);
            buffer.replace(matcher.start(1), matcher.end(1), bSlashes.substring(0, nBSlashes / 2).replace('\\', '\u0003'));
            matcher = pattern.matcher(buffer);
        }
        String result = buffer.toString();
        result = result.replace(VARIABLE_PREFIX_MASKED, VARIABLE_PREFIX);
        result = result.replace('\u0002', '}');
        result = result.replace('\u0003', '\\');
        return result;
    }

    @Deprecated
    public static void checkVariables(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        CdtVariableResolver.resolveToString(string, substitutor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] resolveStringListValues(String[] values, IVariableSubstitutor substitutor, boolean ignoreErrors) throws CdtVariableException {
        String[] result = null;
        if (values == null) return values;
        if (values.length == 0) {
            return values;
        }
        if (values.length == 1) {
            try {
                return CdtVariableResolver.resolveToStringList(values[0], substitutor);
            }
            catch (CdtVariableException e) {
                if (ignoreErrors) return result;
                throw e;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String value = stringArray[n2];
                try {
                    String[] resolved = CdtVariableResolver.resolveToStringList(value, substitutor);
                    if (resolved != null && resolved.length > 0) {
                        list.addAll(Arrays.asList(resolved));
                    }
                }
                catch (CdtVariableException e) {
                    if (ignoreErrors) break block8;
                    throw e;
                }
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] resolveToStringList(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        StringBuffer buffer = new StringBuffer(string);
        Pattern pattern = Pattern.compile("^\\$\\{([^${}]*)\\}$");
        Matcher matcher = pattern.matcher(buffer);
        if (matcher.matches()) {
            String name = matcher.group(1);
            if (name.equals(EMPTY_STRING)) {
                return new String[0];
            }
            String[] result = substitutor.resolveToStringList(name);
            if (result == null) {
                throw new CdtVariableException(1, null, string, name);
            }
            return result;
        }
        return new String[]{CdtVariableResolver.resolveToString(string, substitutor)};
    }

    public static boolean isStringListVariable(int macroType) {
        switch (macroType) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void checkIntegrity(IVariableContextInfo info, IVariableSubstitutor substitutor) throws CdtVariableException {
        ICdtVariable[] macros;
        if (info != null && (macros = SupplierBasedCdtVariableManager.getVariables(info, true)) != null) {
            ICdtVariable[] iCdtVariableArray = macros;
            int n = macros.length;
            int n2 = 0;
            while (n2 < n) {
                ICdtVariable macro = iCdtVariableArray[n2];
                if (CdtVariableResolver.isStringListVariable(macro.getValueType())) {
                    substitutor.resolveToStringList(macro.getName());
                } else {
                    substitutor.resolveToString(macro.getName());
                }
                ++n2;
            }
        }
    }

    public static String createVariableReference(String name) {
        return VARIABLE_PREFIX + name + '}';
    }
}

