/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;

public class SupportedProperties
implements IBuildPropertiesRestriction {
    public static final String SUPPORTED_PROPERTIES = "supportedProperties";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_VALUE = "value";
    public static final String ID = "id";
    public static final String REQUIRED = "required";
    private HashMap<String, SupportedProperty> fSupportedProperties = new HashMap();

    public SupportedProperties(IManagedConfigElement el) {
        IManagedConfigElement[] children = el.getChildren();
        int i = 0;
        while (i < children.length) {
            String id;
            IManagedConfigElement child = children[i];
            if (PROPERTY.equals(child.getName()) && (id = SafeStringInterner.safeIntern((String)child.getAttribute(ID))) != null) {
                boolean required = Boolean.valueOf(el.getAttribute(REQUIRED));
                HashSet<String> set = new HashSet<String>();
                IManagedConfigElement[] values = child.getChildren();
                int k = 0;
                while (k < values.length) {
                    String valueId;
                    IManagedConfigElement value = values[k];
                    if (PROPERTY_VALUE.equals(value.getName()) && (valueId = SafeStringInterner.safeIntern((String)value.getAttribute(ID))) != null && valueId.length() != 0) {
                        set.add(valueId);
                    }
                    ++k;
                }
                if (set.size() != 0) {
                    SupportedProperty stored = this.fSupportedProperties.get(id);
                    if (stored == null) {
                        stored = new SupportedProperty(id);
                        this.fSupportedProperties.put(id, stored);
                    }
                    stored.addValueIds(set);
                    stored.updateRequired(required);
                }
            }
            ++i;
        }
    }

    public boolean supportsType(String type) {
        return this.fSupportedProperties.containsKey(type);
    }

    public boolean supportsValue(String type, String value) {
        boolean suports = false;
        SupportedProperty prop = this.fSupportedProperties.get(type);
        if (prop != null) {
            suports = prop.supportsValue(value);
        }
        return suports;
    }

    public String[] getRequiredTypeIds() {
        ArrayList<String> list = new ArrayList<String>(this.fSupportedProperties.size());
        Collection<SupportedProperty> values = this.fSupportedProperties.values();
        for (SupportedProperty prop : values) {
            if (!prop.isRequired()) continue;
            list.add(prop.getId());
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getSupportedTypeIds() {
        String[] result = new String[this.fSupportedProperties.size()];
        this.fSupportedProperties.keySet().toArray(result);
        return result;
    }

    public String[] getSupportedValueIds(String typeId) {
        SupportedProperty prop = this.fSupportedProperties.get(typeId);
        if (prop != null) {
            return prop.getSupportedValues();
        }
        return new String[0];
    }

    public boolean requiresType(String typeId) {
        SupportedProperty prop = this.fSupportedProperties.get(typeId);
        if (prop != null) {
            return prop.isRequired();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupportedProperty {
        private boolean fIsRequired;
        private Set<String> fValues = new HashSet<String>();
        private String fId;

        SupportedProperty(String id) {
            this.fId = id;
        }

        void updateRequired(boolean required) {
            if (!this.fIsRequired) {
                this.fIsRequired = required;
            }
        }

        public String getId() {
            return this.fId;
        }

        public boolean isRequired() {
            return this.fIsRequired;
        }

        public void addValueIds(Set<String> ids) {
            this.fValues.addAll(ids);
        }

        public boolean supportsValue(String id) {
            return this.fValues.contains(id);
        }

        public String[] getSupportedValues() {
            return this.fValues.toArray(new String[this.fValues.size()]);
        }
    }
}

