/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.macros.IReservedMacroNameSupplier;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildfileMacroSubstitutor
extends SupplierBasedCdtVariableSubstitutor {
    private static final String PATTERN_MACRO_NAME = "=";
    private IConfiguration fConfiguration;
    private IBuilder fBuilder;
    private HashSet<String> fCaseInsensitiveReferencedNames;
    private ICdtVariableManager fVarMngr;
    private ICConfigurationDescription fCfgDes;

    public BuildfileMacroSubstitutor(IBuilder builder, IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
        super((IVariableContextInfo)contextInfo, inexistentMacroValue, listDelimiter);
        this.init(builder, contextInfo);
    }

    public BuildfileMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
        this(null, contextInfo, inexistentMacroValue, listDelimiter);
    }

    private void init(IBuilder builder, IMacroContextInfo contextInfo) {
        if (contextInfo == null) {
            return;
        }
        this.fVarMngr = CCorePlugin.getDefault().getCdtVariableManager();
        if (builder != null) {
            this.fBuilder = builder;
            this.fConfiguration = builder.getParent().getParent();
        } else {
            IBuildObject[] bos = BuildfileMacroSubstitutor.findConfigurationAndBuilderFromContext(contextInfo);
            if (bos != null) {
                this.fConfiguration = (IConfiguration)bos[0];
                this.fBuilder = (IBuilder)bos[1];
            }
        }
        if (this.fConfiguration != null) {
            this.fCfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.fConfiguration);
        }
    }

    static IBuildObject[] findConfigurationAndBuilderFromContext(IMacroContextInfo contextInfo) {
        int type = contextInfo.getContextType();
        IConfiguration cfg = null;
        IBuilder builder = null;
        switch (type) {
            case 1: {
                contextInfo = (IMacroContextInfo)contextInfo.getNext();
                if (contextInfo == null) break;
            }
            case 2: {
                contextInfo = (IMacroContextInfo)contextInfo.getNext();
                if (contextInfo == null) break;
            }
            case 3: {
                ITool tool;
                IResourceInfo rcInfo;
                Object contextData = contextInfo.getContextData();
                if (contextData instanceof IConfiguration) {
                    cfg = (IConfiguration)contextData;
                    builder = cfg.getBuilder();
                    break;
                }
                if (contextData instanceof IBuilder) {
                    builder = (IBuilder)contextData;
                    cfg = builder.getParent().getParent();
                    break;
                }
                if (!(contextData instanceof ITool) || (rcInfo = (tool = (ITool)contextData).getParentResourceInfo()) == null || (cfg = rcInfo.getParent()) == null) break;
                builder = cfg.getBuilder();
                break;
            }
            case 4: {
                IResource rc;
                Object contextData = contextInfo.getContextData();
                if (!(contextData instanceof IManagedProject) || (rc = ((IManagedProject)contextData).getOwner()) == null) break;
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo(rc);
                cfg = info.getDefaultConfiguration();
                builder = cfg.getBuilder();
            }
        }
        if (cfg != null && builder != null) {
            return new IBuildObject[]{cfg, builder};
        }
        return null;
    }

    protected SupplierBasedCdtVariableSubstitutor.ResolvedMacro resolveMacro(ICdtVariable macro) throws CdtVariableException {
        String ref;
        SupplierBasedCdtVariableSubstitutor.ResolvedMacro resolved = null;
        if (this.fConfiguration != null && this.fBuilder != null && this.fBuilder.keepEnvironmentVariablesInBuildfile() && this.fVarMngr.isEnvironmentVariable(macro, this.fCfgDes) && (!CdtVariableResolver.isStringListVariable((int)macro.getValueType()) || BuildfileMacroSubstitutor.size(macro.getStringListValue()) < 2) && (ref = this.getMacroReference(macro)) != null) {
            resolved = new SupplierBasedCdtVariableSubstitutor.ResolvedMacro((SupplierBasedCdtVariableSubstitutor)this, macro.getName(), ref);
        }
        if (resolved != null) {
            return resolved;
        }
        return super.resolveMacro(macro);
    }

    private static int size(String[] value) {
        return value != null ? value.length : 0;
    }

    public IConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    protected IReservedMacroNameSupplier getReservedMacroNameSupplier() {
        if (this.fBuilder == null) {
            return null;
        }
        IReservedMacroNameSupplier supplier = this.fBuilder.getReservedMacroNameSupplier();
        if (supplier == null) {
            supplier = new DefaultReservedMacroNameSupplier(this.fConfiguration);
        }
        return supplier;
    }

    protected String getMacroReference(ICdtVariable macro) {
        String pattern;
        String macroName = macro.getName();
        String ref = null;
        IReservedMacroNameSupplier supplier = this.getReservedMacroNameSupplier();
        macroName = EnvVarOperationProcessor.normalizeName((String)macroName);
        if (!(supplier != null && supplier.isReservedName(macroName, this.fConfiguration) || (pattern = this.fBuilder.getBuilderVariablePattern()) == null || pattern.indexOf(PATTERN_MACRO_NAME) == -1 || !this.fBuilder.isVariableCaseSensitive() && !this.getCaseInsensitiveReferencedNames().add(macroName.toUpperCase()))) {
            ref = pattern.replaceAll(PATTERN_MACRO_NAME, macroName);
        }
        return ref;
    }

    protected Set<String> getCaseInsensitiveReferencedNames() {
        if (this.fCaseInsensitiveReferencedNames == null) {
            this.fCaseInsensitiveReferencedNames = new HashSet();
        }
        return this.fCaseInsensitiveReferencedNames;
    }

    public void setMacroContextInfo(IVariableContextInfo info) throws CdtVariableException {
        super.setMacroContextInfo(info);
        if (info instanceof IMacroContextInfo) {
            this.init(null, (IMacroContextInfo)info);
        }
    }

    private class DefaultReservedMacroNameSupplier
    implements IReservedMacroNameSupplier {
        String[] fReservedNames;

        public DefaultReservedMacroNameSupplier(IConfiguration configuration) {
            IBuilder builder = configuration.getToolChain().getBuilder();
            String[] reservedNames = builder.getReservedMacroNames();
            String[] buildVars = this.getConfigurationReservedNames(configuration);
            if (reservedNames == null || reservedNames.length == 0) {
                this.fReservedNames = buildVars;
            } else if (buildVars == null || buildVars.length == 0) {
                this.fReservedNames = reservedNames;
            } else {
                this.fReservedNames = new String[reservedNames.length + buildVars.length];
                System.arraycopy(reservedNames, 0, this.fReservedNames, 0, reservedNames.length);
                System.arraycopy(buildVars, 0, this.fReservedNames, reservedNames.length, buildVars.length);
            }
        }

        public boolean isReservedName(String macroName, IConfiguration configuration) {
            if (this.fReservedNames != null && this.fReservedNames.length > 0) {
                int i = 0;
                while (i < this.fReservedNames.length) {
                    Pattern p = Pattern.compile(this.fReservedNames[i]);
                    Matcher m = p.matcher(macroName);
                    if (m.matches()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        protected String[] getConfigurationReservedNames(IConfiguration configuration) {
            ITool[] tools = configuration.getFilteredTools();
            if (tools != null) {
                HashSet<String> set = new HashSet<String>();
                int i = 0;
                while (i < tools.length) {
                    IInputType[] its;
                    IOutputType[] ots = tools[i].getOutputTypes();
                    if (ots != null) {
                        int j = 0;
                        while (j < ots.length) {
                            String varName = ots[j].getBuildVariable();
                            if (varName != null) {
                                set.add(varName);
                            }
                            ++j;
                        }
                    }
                    if ((its = tools[i].getInputTypes()) != null) {
                        int j = 0;
                        while (j < its.length) {
                            String varName = its[j].getBuildVariable();
                            if (varName != null) {
                                set.add(varName);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return set.toArray(new String[set.size()]);
            }
            return null;
        }
    }
}

