/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractLaunchVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.ContainerVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbStandardProcessVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.ThreadVMNode;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class LaunchVMProvider
extends AbstractLaunchVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    private boolean fTracepointVisualizationModeEnabled;

    @ThreadSafe
    public LaunchVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        LaunchRootVMNode launchNode = new LaunchRootVMNode((AbstractVMProvider)this);
        this.setRootNode((IRootVMNode)launchNode);
        ContainerVMNode containerNode = new ContainerVMNode((AbstractDMVMProvider)this, this.getSession());
        GdbStandardProcessVMNode processesNode = new GdbStandardProcessVMNode((AbstractVMProvider)this);
        this.addChildNodes((IVMNode)launchNode, new IVMNode[]{containerNode, processesNode});
        ThreadVMNode threadsNode = new ThreadVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)containerNode, new IVMNode[]{threadsNode});
        StackFramesVMNode stackFramesNode = new StackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)threadsNode, new IVMNode[]{stackFramesNode});
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        IGDBTraceControl.ITraceRecordSelectedChangedDMEvent recordChanged;
        if (eventToSkip instanceof ICommandControlService.ICommandControlInitializedDMEvent || eventToSkip instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return false;
        }
        if ((eventToSkip instanceof IGDBTraceControl.ITracingStartedDMEvent || eventToSkip instanceof IGDBTraceControl.ITracingStoppedDMEvent) && (newEvent instanceof IGDBTraceControl.ITracingStartedDMEvent || newEvent instanceof IGDBTraceControl.ITracingStoppedDMEvent)) {
            return true;
        }
        if (eventToSkip instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent && newEvent instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
            return true;
        }
        if (eventToSkip instanceof IGDBTraceControl.ITraceRecordSelectedChangedDMEvent && (recordChanged = (IGDBTraceControl.ITraceRecordSelectedChangedDMEvent)eventToSkip).isVisualizationModeEnabled() == this.fTracepointVisualizationModeEnabled) {
            return true;
        }
        return super.canSkipHandlingEvent(newEvent, eventToSkip);
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        IGDBTraceControl.ITraceRecordSelectedChangedDMEvent recordChanged;
        if (event instanceof IGDBTraceControl.ITracingStartedDMEvent || event instanceof IGDBTraceControl.ITracingStoppedDMEvent || event instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
            this.refresh();
            rm.done();
            return;
        }
        if (event instanceof IGDBTraceControl.ITraceRecordSelectedChangedDMEvent && (recordChanged = (IGDBTraceControl.ITraceRecordSelectedChangedDMEvent)event).isVisualizationModeEnabled() != this.fTracepointVisualizationModeEnabled) {
            this.fTracepointVisualizationModeEnabled = recordChanged.isVisualizationModeEnabled();
            this.refresh();
            rm.done();
            return;
        }
        super.handleEvent(event, rm);
    }

    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRunControl runControlService;
                    IStack stackService;
                    DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), LaunchVMProvider.this.getSession().getId());
                    IProcesses processesService = (IProcesses)tracker.getService(IProcesses.class);
                    if (processesService instanceof ICachingService) {
                        ((ICachingService)processesService).flushCache(null);
                    }
                    if ((stackService = (IStack)tracker.getService(IStack.class)) instanceof ICachingService) {
                        ((ICachingService)stackService).flushCache(null);
                    }
                    if ((runControlService = (IRunControl)tracker.getService(IRunControl.class)) instanceof ICachingService) {
                        ((ICachingService)runControlService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }
}

