/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.preferences;

import java.math.BigInteger;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;

public class DisassemblyPreferenceConstants {
    public static final String START_ADDRESS = "disassembly.startAddress";
    public static final String END_ADDRESS = "disassembly.endAddress";
    public static final String PC_HISTORY_SIZE = "disassembly.pcHistorySize";
    public static final String SHOW_SOURCE = "disassembly.showSource";
    public static final String SHOW_SYMBOLS = "disassembly.showSymbols";
    public static final String ADDRESS_RADIX = "disassembly.addressRadix";
    public static final String SHOW_ADDRESS_RADIX = "disassembly.showAddressRadix";
    public static final String SHOW_ADDRESS_RULER = "disassembly.showAddressRuler";
    public static final String ADDRESS_COLOR = "disassembly.addressColor";
    public static final String SHOW_FUNCTION_OFFSETS = "disassembly.showFunctionOffsetRuler";
    public static final String FUNCTION_OFFSETS_COLOR = "disassembly.functionOffsetsColor";
    public static final String AVOID_READ_BEFORE_PC = "disassembly.avoidReadBeforePC";
    public static final String TRACK_EXPRESSION = "disassembly.trackExpression";
    public static final String SYNC_ACTIVE_CONTEXT = "disassembly.syncActiveContext";

    private DisassemblyPreferenceConstants() {
    }

    public static void initializeDefaults(IPreferenceStore store) {
        store.setDefault(START_ADDRESS, 0L);
        store.setDefault(END_ADDRESS, "0x" + BigInteger.ONE.shiftLeft(64).toString(16));
        store.setDefault(PC_HISTORY_SIZE, 4);
        store.setDefault(SHOW_SOURCE, true);
        store.setDefault(SHOW_FUNCTION_OFFSETS, false);
        store.setDefault(SHOW_SYMBOLS, true);
        store.setDefault(ADDRESS_RADIX, 16);
        store.setDefault(SHOW_ADDRESS_RADIX, false);
        store.setDefault(SHOW_ADDRESS_RULER, true);
        store.setDefault(AVOID_READ_BEFORE_PC, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)ADDRESS_COLOR, (RGB)new RGB(0, 96, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)FUNCTION_OFFSETS_COLOR, (RGB)new RGB(96, 0, 0));
    }

    public static class Initializer
    extends AbstractPreferenceInitializer {
        public void initializeDefaultPreferences() {
            IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
            DisassemblyPreferenceConstants.initializeDefaults(store);
            EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)store);
        }
    }
}

