/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ide.eclipse.ddms.systrace.SystraceTag;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SystraceVersionDetector
implements IRunnableWithProgress {
    public static final int SYSTRACE_V1 = 1;
    public static final int SYSTRACE_V2 = 2;
    private final IDevice mDevice;
    private List<SystraceTag> mTags;

    public SystraceVersionDetector(IDevice device) {
        this.mDevice = device;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Checking systrace version on device..", -1);
        CountDownLatch setTagLatch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(setTagLatch);
        try {
            String cmd = "atrace --list_categories";
            this.mDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
            setTagLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        String shellOutput = receiver.getOutput();
        this.mTags = this.parseSupportedTags(shellOutput);
        monitor.done();
    }

    public int getVersion() {
        if (this.mTags == null) {
            return 1;
        }
        return 2;
    }

    public List<SystraceTag> getTags() {
        return this.mTags;
    }

    private List<SystraceTag> parseSupportedTags(String listCategoriesOutput) {
        if (listCategoriesOutput == null) {
            return null;
        }
        if (listCategoriesOutput.contains("unknown option")) {
            return null;
        }
        String[] categories = listCategoriesOutput.split("\n");
        ArrayList<SystraceTag> tags = new ArrayList<SystraceTag>(categories.length);
        Pattern p = Pattern.compile("([^-]+) - (.*)");
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            Matcher m = p.matcher(category);
            if (m.find()) {
                tags.add(new SystraceTag(m.group(1).trim(), m.group(2).trim()));
            }
            ++n2;
        }
        return tags;
    }
}

