/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring;

import adobe.asc.authoring.AuthBatchCompiler;
import adobe.asc.authoring.AuthCompilerPlug;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.util.ByteList;

public class AuthCompilerHandler
extends CompilerHandler {
    private String handlerKey;
    private AuthCompilerPlug plug;

    public AuthCompilerHandler(String key, AuthCompilerPlug plug) {
        this.handlerKey = key;
        this.plug = plug;
    }

    public void warning(String filename, int ln, int col, String msg, String source, int code) {
        this.nativeError(this.handlerKey, filename, this.plug == null ? true : this.plug.class_provided, ln, col, msg, source, code, true);
    }

    public void warning(String filename, int ln, int col, String msg, String source) {
        this.nativeError(this.handlerKey, filename, this.plug == null ? true : this.plug.class_provided, ln, col, msg, source, -1, true);
    }

    public void error(String filename, int ln, int col, String msg, String source, int code) {
        if (this.plug != null) {
            ++this.plug.numErrors;
        }
        this.nativeError(this.handlerKey, filename, this.plug == null ? true : this.plug.class_provided, ln, col, msg, source, code, false);
    }

    public void error(String filename, int ln, int col, String msg, String source) {
        if (this.plug != null) {
            ++this.plug.numErrors;
        }
        this.nativeError(this.handlerKey, filename, this.plug == null ? true : this.plug.class_provided, ln, col, msg, source, -1, false);
    }

    private native void nativeError(String var1, String var2, boolean var3, int var4, int var5, String var6, String var7, int var8, boolean var9);

    public void authError(int code, String param1, String param2) {
        if (code != 5002 && code != 5004) {
            if (this.plug != null) {
                ++this.plug.numErrors;
            }
            ++AuthBatchCompiler.getStatics().errCount;
        }
        this.nativeAuthError(this.handlerKey, code, param1, param2);
    }

    native void nativeAuthError(String var1, int var2, String var3, String var4);

    public boolean writeBytes(String name, ByteList bytes, boolean inLoaderFrame) {
        byte[] byteArray = bytes.toByteArray(false);
        this.nativeWriteBytes(this.handlerKey, name, byteArray, inLoaderFrame);
        return true;
    }

    public boolean writeBytes(String name, byte[] byteArray, boolean inLoaderFrame) {
        this.nativeWriteBytes(this.handlerKey, name, byteArray, inLoaderFrame);
        return true;
    }

    private native void nativeWriteBytes(String var1, String var2, byte[] var3, boolean var4);

    public void findDefinition(String defName) {
        this.nativeFindDefinition(defName);
    }

    private native void nativeFindDefinition(String var1);

    public boolean hasPackage(String packageName) {
        return this.nativeHasPackage(packageName);
    }

    private native boolean nativeHasPackage(String var1);

    public boolean hasDefinition(String packageName) {
        return this.nativeHasDefinition(packageName);
    }

    private native boolean nativeHasDefinition(String var1);
}

