/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.abc;

import adobe.asc.authoring.abc.ArgumentInfo;
import adobe.asc.authoring.abc.AttributeInfo;
import adobe.asc.authoring.abc.ClassInfo;
import adobe.asc.authoring.abc.DebugInfo;
import adobe.asc.authoring.abc.MetadataAttributeInfo;
import adobe.asc.authoring.abc.MetadataInfo;
import adobe.asc.authoring.abc.MethodInfo;
import adobe.asc.authoring.abc.PropertyInfo;
import adobe.asc.authoring.abc.VariableInfo;
import flash.swf.tools.as3.EvaluatorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABCEvaluator
extends EvaluatorAdapter {
    protected String fPackageName;
    public static HashMap<String, ClassInfo> globalClassInfoMap;
    public static ArrayList<ClassInfo> globalClassInfoList;
    public static ArrayList<MethodInfo> globalMethodInfoList;
    public static ArrayList<VariableInfo> globalVariableInfoList;
    private static HashMap<String, MetadataInfo> metadataMap;
    private static ArrayList<MetadataInfo> metadataList;
    private static HashMap<String, PropertyInfo> propertyMap;
    private static ArrayList<PropertyInfo> propertyList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void resetGlobals() {
        if (globalClassInfoMap == null) {
            globalClassInfoMap = new HashMap();
        } else {
            globalClassInfoMap.clear();
        }
        if (globalClassInfoList == null) {
            globalClassInfoList = new ArrayList();
        } else {
            globalClassInfoList.clear();
        }
        if (globalMethodInfoList == null) {
            globalMethodInfoList = new ArrayList();
        } else {
            globalMethodInfoList.clear();
        }
        if (globalVariableInfoList == null) {
            globalVariableInfoList = new ArrayList();
        } else {
            globalVariableInfoList.clear();
        }
    }

    public ABCEvaluator() {
    }

    public ABCEvaluator(String packageName) {
        this.fPackageName = packageName;
    }

    @Override
    public Value evaluate(Context cx, BinaryProgramNode node) {
        if (node.toplevelDefinitions.size() > 0) {
            this.fPackageName = "";
            boolean foundPackageName = false;
            for (QName definitionName : node.toplevelDefinitions) {
                if (definitionName.ns.name.indexOf(36) != -1 || definitionName.ns.name.indexOf(58) != -1 || definitionName.ns.name.indexOf(92) != -1 || definitionName.ns.name.indexOf(47) != -1) continue;
                if (!foundPackageName) {
                    this.fPackageName = definitionName.ns.name;
                    continue;
                }
                if (definitionName.ns.name.equals(this.fPackageName) || $assertionsDisabled) continue;
                throw new Error();
            }
            if (node.clsdefs != null && node.clsdefs.size() > 0) {
                for (ClassDefinitionNode classDef : node.clsdefs) {
                    ABCEvaluator eval = new ABCEvaluator(this.fPackageName);
                    classDef.evaluate(cx, eval);
                }
            }
            if (node.clsdefs == null || node.toplevelDefinitions.size() > node.clsdefs.size()) {
                this.addMembers(cx, node.statements.items, null, globalMethodInfoList, null, null, globalVariableInfoList);
            }
        }
        return null;
    }

    private DebugInfo removeOffsetMetadata(ArrayList<MetadataInfo> metadataList) {
        DebugInfo debugInfo = null;
        if (metadataList != null) {
            Iterator<MetadataInfo> iter = metadataList.iterator();
            int removeIndex = 0;
            while (iter.hasNext()) {
                MetadataInfo metadataInfo = iter.next();
                if (metadataInfo.name.equals("__go_to_definition_help")) {
                    debugInfo = new DebugInfo();
                    for (MetadataAttributeInfo attrInfo : metadataInfo.attrs) {
                        if (attrInfo.name.equals("file")) {
                            debugInfo.file = attrInfo.value;
                            continue;
                        }
                        if (!attrInfo.name.equals("pos")) continue;
                        debugInfo.pos = attrInfo.value;
                    }
                    metadataList.remove(removeIndex);
                    break;
                }
                ++removeIndex;
            }
        }
        return debugInfo;
    }

    @Override
    public Value evaluate(Context cx, ClassDefinitionNode node) {
        if (node == null || node.name == null) {
            return null;
        }
        ClassInfo classInfo = new ClassInfo(node.name.name, this.fPackageName, node.isInterface());
        if (node.isInterface()) {
            System.out.println(new StringBuffer().append("interface name = ").append(node.name.name).toString());
            System.out.println(new StringBuffer().append("fPackageName = ").append(this.fPackageName).toString());
        } else {
            System.out.println(new StringBuffer().append("class name = ").append(node.name.name).toString());
            System.out.println(new StringBuffer().append("fPackageName = ").append(this.fPackageName).toString());
        }
        classInfo.attrs = node.attrs == null ? null : new AttributeInfo(node.attrs);
        classInfo.metadata = this.getMetadata(cx, node.metaData);
        classInfo.debugInfo = this.removeOffsetMetadata(classInfo.metadata);
        if (node.isInterface()) {
            classInfo.implementedInterfaceNames = this.addExtendedInterfaces(node);
        } else {
            classInfo.baseClassName = this.addBaseClass(node);
            classInfo.implementedInterfaceNames = this.addImplementedInterfaces(node);
        }
        classInfo.methodList = new ArrayList();
        classInfo.getterList = new ArrayList();
        classInfo.setterList = new ArrayList();
        classInfo.variableList = new ArrayList();
        this.addMembers(cx, node.instanceinits, node.name.name, classInfo.methodList, classInfo.getterList, classInfo.setterList, classInfo.variableList);
        classInfo.staticMethodList = new ArrayList();
        classInfo.staticGetterList = new ArrayList();
        classInfo.staticSetterList = new ArrayList();
        classInfo.staticVariableList = new ArrayList();
        this.addMembers(cx, node.statements.items, null, classInfo.staticMethodList, classInfo.staticGetterList, classInfo.staticSetterList, classInfo.staticVariableList);
        globalClassInfoMap.put(classInfo.fullName, classInfo);
        globalClassInfoList.add(classInfo);
        return null;
    }

    public void addMembers(Context cx, ObjectList members, String constructorName, ArrayList<MethodInfo> methodList, ArrayList<MethodInfo> getterList, ArrayList<MethodInfo> setterList, ArrayList<VariableInfo> variableList) {
        HashSet variables = new HashSet();
        HashSet functions = new HashSet();
        if (members != null) {
            for (Object memberDef : members) {
                if (memberDef instanceof FunctionDefinitionNode) {
                    MethodInfo mi = this.addFunction(cx, (FunctionDefinitionNode)memberDef, functions, constructorName);
                    if (mi == null) continue;
                    methodList.add(mi);
                    switch (mi.type) {
                        case 1: {
                            if (getterList == null) break;
                            getterList.add(mi);
                            break;
                        }
                        case 2: {
                            if (setterList == null) break;
                            setterList.add(mi);
                        }
                    }
                    continue;
                }
                if (!(memberDef instanceof VariableDefinitionNode)) continue;
                this.addVariable(cx, (VariableDefinitionNode)memberDef, variables, variableList);
            }
        }
    }

    public void addVariable(Context cx, VariableDefinitionNode variableDef, HashSet variables, ArrayList<VariableInfo> variableList) {
        System.out.println("addVariable");
        ListNode list = variableDef.list;
        if (list != null && list.size() > 0) {
            for (Object e : list.items) {
                if (!(e instanceof VariableBindingNode)) continue;
                VariableBindingNode vbNode = (VariableBindingNode)e;
                TypedIdentifierNode idNode = vbNode.variable;
                if (idNode.identifier == null) continue;
                String name = idNode.identifier.name;
                String type = "notypefound";
                AttributeInfo attrs = variableDef.attrs == null ? null : new AttributeInfo(variableDef.attrs);
                StatementListNode meta = variableDef.metaData;
                ArrayList<MetadataInfo> metadataList = this.getMetadata(cx, meta);
                if (idNode.type instanceof MemberExpressionNode) {
                    type = this.getType((MemberExpressionNode)idNode.type);
                }
                VariableInfo variableInfo = new VariableInfo(name, type);
                variableInfo.attrs = attrs;
                variableInfo.metadata = metadataList;
                variableInfo.debugInfo = this.removeOffsetMetadata(variableInfo.metadata);
                String representativeString = new StringBuffer().append("var ").append(name).append(":").append(type).toString();
                if (!variables.contains(representativeString)) {
                    variables.add(representativeString);
                    variableList.add(variableInfo);
                    System.out.println(representativeString);
                    continue;
                }
                System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(representativeString).toString());
            }
        }
    }

    public MethodInfo addFunction(Context cx, FunctionDefinitionNode functionDef, HashSet functions, String constructorName) {
        MethodInfo methodInfo = null;
        System.out.println("addFunction");
        if (functionDef.name != null && functionDef.name.identifier != null && functionDef.name.identifier.name != null) {
            String representativeString = "function ";
            boolean isConstructor = false;
            String name = functionDef.name.identifier.name;
            if (name.equals("$construct")) {
                isConstructor = true;
                name = constructorName;
            }
            if (name == null) {
                return null;
            }
            switch (functionDef.name.kind) {
                case -78: {
                    representativeString = new StringBuffer().append(representativeString).append("get ").toString();
                    break;
                }
                case -97: {
                    representativeString = new StringBuffer().append(representativeString).append("set ").toString();
                    break;
                }
            }
            representativeString = new StringBuffer().append(representativeString).append(name).append("(").toString();
            methodInfo = new MethodInfo(name, isConstructor, functionDef.name.kind);
            methodInfo.args = new ArrayList();
            methodInfo.attrs = functionDef.attrs == null ? null : new AttributeInfo(functionDef.attrs);
            StatementListNode meta = functionDef.metaData;
            methodInfo.metadata = this.getMetadata(cx, meta);
            methodInfo.debugInfo = this.removeOffsetMetadata(methodInfo.metadata);
            if (functionDef.fexpr != null && functionDef.fexpr.signature != null) {
                ObjectList<ParameterNode> args;
                if (functionDef.fexpr.signature.result != null && functionDef.fexpr.signature.result instanceof MemberExpressionNode) {
                    String returnType;
                    methodInfo.returnType = returnType = this.getType((MemberExpressionNode)functionDef.fexpr.signature.result);
                    System.out.println(new StringBuffer().append("returnType = ").append(returnType).toString());
                }
                if (functionDef.fexpr.signature.parameter != null && (args = functionDef.fexpr.signature.parameter.items) != null && args.size() > 0) {
                    for (Object e : args) {
                        if (!(e instanceof ParameterNode)) continue;
                        ParameterNode param = (ParameterNode)e;
                        ReferenceValue ref = param.typeref;
                        String argumentType = this.getType(ref);
                        String argumentName = "";
                        if (param.identifier != null) {
                            argumentName = param.identifier.name;
                        }
                        ArgumentInfo argumentInfo = new ArgumentInfo(argumentName, argumentType);
                        representativeString = new StringBuffer().append(representativeString).append(argumentName).toString();
                        representativeString = new StringBuffer().append(representativeString).append(":").toString();
                        representativeString = new StringBuffer().append(representativeString).append(argumentType).toString();
                        representativeString = new StringBuffer().append(representativeString).append(",").toString();
                        if (param.init != null) {
                            Node defaultValueNode = param.init;
                            if (param.init instanceof UnaryExpressionNode) {
                                UnaryExpressionNode unaryNode = (UnaryExpressionNode)param.init;
                                defaultValueNode = unaryNode.expr;
                            }
                            if (defaultValueNode instanceof LiteralNumberNode) {
                                argumentInfo.defaultValue = ((LiteralNumberNode)defaultValueNode).value;
                                System.out.println(new StringBuffer().append(argumentName).append("has a Number default value = ").append(((LiteralNumberNode)defaultValueNode).value).toString());
                            } else if (defaultValueNode instanceof LiteralStringNode) {
                                argumentInfo.defaultValue = ((LiteralStringNode)defaultValueNode).value;
                                System.out.println(new StringBuffer().append(argumentName).append("has a String default value = ").append(((LiteralStringNode)defaultValueNode).value).toString());
                            } else if (defaultValueNode instanceof LiteralBooleanNode) {
                                argumentInfo.defaultValue = ((LiteralBooleanNode)defaultValueNode).value ? "true" : "false";
                                System.out.println(new StringBuffer().append(argumentName).append("has a Boolean default value = ").append(((LiteralBooleanNode)defaultValueNode).value ? "true" : "false").toString());
                            } else if (defaultValueNode instanceof LiteralNullNode) {
                                argumentInfo.defaultValue = "null";
                                System.out.println(new StringBuffer().append(argumentName).append("has a Object default value = null").toString());
                            }
                        }
                        methodInfo.args.add(argumentInfo);
                    }
                }
            }
            methodInfo.representativeString = representativeString = new StringBuffer().append(representativeString).append(")").toString();
            if (!functions.contains(representativeString)) {
                functions.add(representativeString);
                System.out.println(representativeString);
            } else {
                methodInfo = null;
                System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(representativeString).toString());
            }
        }
        return methodInfo;
    }

    protected ArrayList<MetadataInfo> getMetadata(Context cx, StatementListNode meta) {
        ArrayList<MetadataInfo> metadataInfoList = new ArrayList<MetadataInfo>();
        if (meta == null || meta.items == null || meta.items.size() == 0) {
            return metadataInfoList;
        }
        HashSet<String> attributes = new HashSet<String>();
        for (MetaDataNode metaDataNode : meta.items) {
            String metaName = metaDataNode.id;
            MetadataInfo metadataInfo = new MetadataInfo(metaName);
            metadataInfo.attrs = new ArrayList();
            System.out.println(new StringBuffer().append("metadata name = ").append(metaName).toString());
            Value[] vals = metaDataNode.values;
            String representativeString = new StringBuffer().append(metaName).append("[").toString();
            if (vals != null) {
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] instanceof MetaDataEvaluator.KeylessValue) {
                        String attributeValue = ((MetaDataEvaluator.KeylessValue)vals[i]).obj;
                        metadataInfo.attrs.add(new MetadataAttributeInfo(attributeValue));
                        System.out.println(new StringBuffer().append("Keyless Value: ").append(attributeValue).toString());
                        representativeString = new StringBuffer().append(representativeString).append(attributeValue).append(",").toString();
                        continue;
                    }
                    if (!(vals[i] instanceof MetaDataEvaluator.KeyValuePair)) continue;
                    String attributeName = ((MetaDataEvaluator.KeyValuePair)vals[i]).key;
                    String attributeValue = ((MetaDataEvaluator.KeyValuePair)vals[i]).obj;
                    metadataInfo.attrs.add(new MetadataAttributeInfo(attributeName, attributeValue));
                    System.out.println(new StringBuffer().append("Key Value Pair: ").append(attributeName).append(" = ").append(attributeValue).toString());
                    representativeString = new StringBuffer().append(representativeString).append(attributeName).append("=").append(attributeValue).append(",").toString();
                }
            }
            metadataInfo.representativeString = representativeString = new StringBuffer().append(representativeString).append("]").toString();
            if (!attributes.contains(representativeString)) {
                attributes.add(representativeString);
                metadataInfoList.add(metadataInfo);
                continue;
            }
            System.out.println(new StringBuffer().append("DUPLICATE DEFINITION: ").append(representativeString).toString());
        }
        return metadataInfoList;
    }

    protected String addBaseClass(ClassDefinitionNode node) {
        String baseClassName = null;
        if (node.baseclass instanceof LiteralStringNode) {
            baseClassName = ((LiteralStringNode)node.baseclass).value;
            if ((baseClassName = baseClassName.replaceAll(":", ".")) != null) {
                System.out.println(new StringBuffer().append("Base Class: ").append(baseClassName).toString());
            }
        }
        return baseClassName;
    }

    private static String getFullName(ReferenceValue value) {
        String fullName = "";
        if (!value.namespaces.isEmpty()) {
            fullName = new StringBuffer().append(value.namespaces.get(0)).append(".").toString();
        }
        fullName = new StringBuffer().append(fullName).append(value.name).toString();
        return fullName;
    }

    protected ArrayList<String> addImplementedInterfaces(ClassDefinitionNode node) {
        ArrayList<String> nameList = new ArrayList<String>();
        ListNode ints = node.interfaces;
        if (ints != null && ints.values != null && ints.values.size() > 0) {
            for (Object e : ints.values) {
                String val;
                if (!(e instanceof ReferenceValue) || (val = ABCEvaluator.getFullName((ReferenceValue)e)).length() <= 0) continue;
                nameList.add(val);
                System.out.println(new StringBuffer().append("implements interface ").append(val).toString());
            }
        }
        return nameList;
    }

    protected ArrayList<String> addExtendedInterfaces(ClassDefinitionNode node) {
        ArrayList<String> nameList = new ArrayList<String>();
        ListNode ints = node.interfaces;
        if (ints != null && ints.values != null && ints.values.size() > 0) {
            for (Object e : ints.values) {
                String val;
                if (!(e instanceof ReferenceValue) || (val = ABCEvaluator.getFullName((ReferenceValue)e)).length() <= 0) continue;
                nameList.add(val);
                System.out.println(new StringBuffer().append("extends interface ").append(val).toString());
            }
        }
        return nameList;
    }

    protected String getType(MemberExpressionNode typeNode) {
        if (typeNode.ref != null) {
            return this.getType(typeNode.ref);
        }
        if (typeNode.selector.getIdentifier().ref != null) {
            return this.getType(typeNode.selector.getIdentifier().ref);
        }
        return "";
    }

    protected String getType(ReferenceValue ref) {
        HashSet<String> packageSet = new HashSet<String>();
        Iterator packageIterator = null;
        String name = "Object";
        if (ref != null) {
            for (ObjectValue value : ref.namespaces) {
                if (value.name.equals("") || value.name.equals(this.fPackageName)) continue;
                packageSet.add(value.name);
            }
            name = ref.name;
        }
        System.out.println(new StringBuffer().append("got type name: ").append(name).toString());
        for (String packageName : packageSet) {
            System.out.println(new StringBuffer().append("adding import: ").append(packageName).toString());
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateClassXML(String classname) {
        StringBuffer xml;
        try {
            xml = new StringBuffer(1024);
            xml.append("<classDefs>\n");
            Iterator<ClassInfo> classDefsIter = globalClassInfoList.iterator();
            while (classDefsIter.hasNext()) {
                xml.append("\t<classDef id=\"");
                xml.append(classDefsIter.next().fullName);
                xml.append("\"/>\n");
            }
            xml.append("</classDefs>\n");
            metadataMap = new HashMap();
            metadataList = new ArrayList();
            propertyMap = new HashMap();
            propertyList = new ArrayList();
            ClassInfo classInfo = globalClassInfoMap.get(classname);
            ABCEvaluator.walkBaseClassAndImplInterfaces(classInfo);
            xml.append("<class id=\"");
            xml.append(classname);
            xml.append("\" >\n");
            Iterator<MetadataInfo> metaIter = metadataList.iterator();
            while (metaIter.hasNext()) {
                ABCEvaluator.generateMetadataXML(metaIter.next(), xml);
            }
            Iterator<PropertyInfo> propIter = propertyList.iterator();
            while (propIter.hasNext()) {
                ABCEvaluator.generatePropertyXML(propIter.next(), xml);
            }
            xml.append("</class>");
        }
        catch (NullPointerException npe) {
            String string = "";
            return string;
        }
        finally {
            metadataMap = null;
            metadataList = null;
            propertyMap = null;
            propertyList = null;
        }
        return xml.toString();
    }

    private static void walkBaseClassAndImplInterfaces(ClassInfo classInfo) {
        for (MetadataInfo metaInfo : classInfo.metadata) {
            if (metadataMap.get(metaInfo.representativeString) != null) continue;
            metadataMap.put(metaInfo.representativeString, metaInfo);
            metadataList.add(metaInfo);
        }
        if (!classInfo.isInterface) {
            ABCEvaluator.fillInProperties(classInfo);
            ClassInfo baseClassInfo = globalClassInfoMap.get(classInfo.baseClassName);
            if (baseClassInfo != null) {
                ABCEvaluator.walkBaseClassAndImplInterfaces(baseClassInfo);
            }
        }
        Iterator<String> implIntIter = classInfo.implementedInterfaceNames.iterator();
        while (implIntIter.hasNext()) {
            ClassInfo implIntInfo = globalClassInfoMap.get(implIntIter.next());
            if (implIntInfo == null) continue;
            ABCEvaluator.walkBaseClassAndImplInterfaces(implIntInfo);
        }
    }

    private static void fillInProperties(ClassInfo classInfo) {
        PropertyInfo propInfo;
        String idString;
        for (MethodInfo getterInfo : classInfo.getterList) {
            String idString2 = new StringBuffer().append(getterInfo.name).append(":").append(getterInfo.returnType).toString();
            PropertyInfo propInfo2 = propertyMap.get(idString2);
            if (propInfo2 == null) {
                propInfo2 = new PropertyInfo(getterInfo.name, getterInfo.returnType, idString2);
                propertyMap.put(idString2, propInfo2);
                propertyList.add(propInfo2);
            }
            if (propInfo2.getterInfo != null) continue;
            propInfo2.getterInfo = getterInfo;
        }
        for (MethodInfo setterInfo : classInfo.setterList) {
            String type = setterInfo.args.get((int)0).type;
            idString = new StringBuffer().append(setterInfo.name).append(":").append(type).toString();
            propInfo = propertyMap.get(idString);
            if (propInfo == null) {
                propInfo = new PropertyInfo(setterInfo.name, type, idString);
                propertyMap.put(idString, propInfo);
                propertyList.add(propInfo);
            }
            if (propInfo.setterInfo != null) continue;
            propInfo.setterInfo = setterInfo;
        }
        for (VariableInfo varInfo : classInfo.variableList) {
            idString = new StringBuffer().append(varInfo.name).append(":").append(varInfo.type).toString();
            propInfo = propertyMap.get(idString);
            if (propInfo == null) {
                propInfo = new PropertyInfo(varInfo.name, varInfo.type, idString);
                propertyMap.put(idString, propInfo);
                propertyList.add(propInfo);
            }
            if (propInfo.varInfo != null) continue;
            propInfo.varInfo = varInfo;
        }
    }

    private static void generateMetadataXML(MetadataInfo metaInfo, StringBuffer xml) {
        xml.append("\t<");
        xml.append(metaInfo.name);
        xml.append(' ');
        int i = 1;
        for (MetadataAttributeInfo attrInfo : metaInfo.attrs) {
            if (attrInfo.name == null) {
                xml.append("param");
                xml.append(i++);
            } else {
                xml.append(attrInfo.name);
            }
            xml.append("=\"");
            xml.append(attrInfo.value);
            xml.append("\" ");
        }
        xml.append("/>\n");
    }

    private static void generatePropertyXML(PropertyInfo propInfo, StringBuffer xml) {
        Iterator<MetadataInfo> metaIter;
        if (propInfo.varInfo == null ? !(propInfo.getterInfo != null && propInfo.getterInfo.metadata.size() >= 1 || propInfo.setterInfo != null && propInfo.setterInfo.metadata.size() >= 1) : propInfo.varInfo.metadata.size() < 1) {
            return;
        }
        xml.append("\t<method id=\"");
        xml.append(propInfo.name);
        xml.append("\" returnType=\"");
        xml.append(propInfo.type);
        xml.append("\">\n");
        if (propInfo.getterInfo != null) {
            metaIter = propInfo.getterInfo.metadata.iterator();
            while (metaIter.hasNext()) {
                xml.append('\t');
                ABCEvaluator.generateMetadataXML(metaIter.next(), xml);
            }
        }
        if (propInfo.setterInfo != null) {
            metaIter = propInfo.setterInfo.metadata.iterator();
            while (metaIter.hasNext()) {
                xml.append('\t');
                ABCEvaluator.generateMetadataXML(metaIter.next(), xml);
            }
        }
        if (propInfo.varInfo != null) {
            metaIter = propInfo.varInfo.metadata.iterator();
            while (metaIter.hasNext()) {
                xml.append('\t');
                ABCEvaluator.generateMetadataXML(metaIter.next(), xml);
            }
        }
        xml.append("\t</method>\n");
    }

    static {
        $assertionsDisabled = true;
    }
}

