/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc;

import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcDynamicArchive;
import adobe.asc.authoring.swc.SwcGroup;
import adobe.asc.authoring.swc.SwcLazyReadArchive;
import adobe.asc.authoring.swc.SwcMemoryArchive;
import flash.util.FileUtils;
import flash.util.LRUCache;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SwcCache {
    public static int CACHE_INITIAL_SIZE = 20;
    public static int CACHE_MAX_SIZE = 50;
    public static final String SWC_EXTENSION = ".swc";
    public static final String GENSWC_EXTENSION = "-generated.swc";
    private SwcLRUCache swcs = new SwcLRUCache();
    private boolean useCache = true;
    private boolean lazyRead = false;

    public SwcGroup getSwcGroup(VirtualFile[] paths) {
        String[] urls = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = paths[i].getName();
        }
        return this.getSwcGroup(urls);
    }

    public synchronized SwcGroup getSwcGroup(String[] paths) {
        HashMap swcs = new HashMap();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            swcs.putAll(this.getSwcs(path));
        }
        SwcGroup group = new SwcGroup(swcs);
        return group;
    }

    public synchronized SwcGroup getSwcGroup(List groups) {
        HashMap swcs = new HashMap();
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            SwcGroup g = (SwcGroup)it.next();
            if (g == null) continue;
            swcs.putAll(g.getSwcs());
        }
        SwcGroup group = null;
        if (swcs.size() > 0) {
            group = new SwcGroup(swcs);
        }
        return group;
    }

    public synchronized SwcGroup getSwcGroupFromHashes(String[] hashes) {
        HashMap<String, Swc> swcs = new HashMap<String, Swc>();
        for (int i = 0; i < hashes.length; ++i) {
            String hash = hashes[i];
            Swc swc = this.getSwc(hash);
            if (swc == null) continue;
            swcs.put(hash, swc);
        }
        SwcGroup group = null;
        if (swcs.size() > 0) {
            group = new SwcGroup(swcs);
        }
        return group;
    }

    private native String getHashForPath(String var1);

    private native byte[] getBytesForHash(String var1);

    private Map getSwcs(String path) {
        HashMap<String, Swc> map = new HashMap<String, Swc>();
        File f = new File(path);
        if (!f.exists()) {
            return map;
        }
        File[] files = FileUtils.listFiles(f);
        for (int i = 0; i < files.length; ++i) {
            String lowerCase;
            File file = files[i];
            if (file.isDirectory() || !file.canRead() || (lowerCase = file.getName().toLowerCase()).endsWith(GENSWC_EXTENSION) || !lowerCase.endsWith(SWC_EXTENSION)) continue;
            try {
                Swc swc = this.getSwc(file);
                if (swc == null) continue;
                map.put(swc.getLocation(), swc);
                continue;
            }
            catch (SwcException swcExcep) {
                // empty catch block
            }
        }
        return map;
    }

    private Swc getSwc(File file) {
        Swc swc;
        try {
            String location = FileUtils.canonicalPath(file);
            String hash = this.getHashForPath(location);
            swc = (Swc)this.swcs.get(hash);
            if (swc == null) {
                SwcDynamicArchive archive = this.lazyRead ? new SwcLazyReadArchive(location, hash) : new SwcDynamicArchive(location, hash);
                swc = new Swc(archive, true);
                if (this.useCache) {
                    this.swcs.put(hash, swc);
                }
            }
        }
        catch (Exception e) {
            SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(file.getName(), e);
            throw ex;
        }
        return swc;
    }

    private Swc getSwc(String hash) {
        Swc swc;
        try {
            swc = (Swc)this.swcs.get(hash);
            if (swc == null) {
                byte[] rawBytes = this.getBytesForHash(hash);
                SwcMemoryArchive archive = new SwcMemoryArchive(rawBytes, hash);
                swc = new Swc(archive, true);
                if (this.useCache) {
                    this.swcs.put(hash, swc);
                }
            }
        }
        catch (Exception e) {
            SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(hash, e);
            throw ex;
        }
        return swc;
    }

    public void setLazyRead(boolean lazyRead) {
        this.lazyRead = lazyRead;
    }

    static class SwcLRUCache
    extends LRUCache {
        SwcLRUCache() {
            super(CACHE_INITIAL_SIZE, CACHE_MAX_SIZE);
        }

        protected Object fetch(Object key) {
            return null;
        }
    }
}

