/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc;

import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcFile;
import adobe.asc.authoring.swc.SwcLibrary;
import adobe.asc.authoring.swc.SwcScript;
import flash.swf.tags.DoABC;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcGroup {
    private Map swcs;
    private Map files = new HashMap();
    private Set qnames;
    private Map def2script;
    static final /* synthetic */ boolean $assertionsDisabled;

    SwcGroup(Map swcs) {
        this.swcs = swcs;
        this.updateFiles();
        this.updateMaps();
    }

    public int getNumberLoaded() {
        return this.swcs.size();
    }

    public Map getScriptMap() {
        return this.def2script;
    }

    public Set getQNames() {
        return this.qnames;
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String name) {
        Swc swc;
        VirtualFile swcFile = null;
        String location = SwcFile.getSwcLocation(name);
        String fileName = SwcFile.getFilePath(name);
        if (location != null && fileName != null && (swc = (Swc)this.swcs.get(location)) != null) {
            swcFile = swc.getFile(fileName);
        }
        return swcFile;
    }

    public Map getSwcs() {
        return this.swcs;
    }

    public List getSwcTimes() {
        ArrayList<Long> lastModified = new ArrayList<Long>();
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            lastModified.add(new Long(swc.getLastModified()));
        }
        return lastModified;
    }

    public void close() {
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            swc.close();
        }
    }

    private void updateFiles() {
        Iterator iterator = this.swcs.values().iterator();
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            Iterator it = swc.getCatalogFiles().values().iterator();
            while (it.hasNext()) {
                VirtualFile curFile;
                VirtualFile file = (VirtualFile)it.next();
                String name = file.getName();
                String swcName = SwcFile.getFilePath(name);
                if (swcName != null) {
                    name = swcName;
                }
                if ((curFile = (VirtualFile)this.files.get(name)) != null && file.getLastModified() <= curFile.getLastModified()) continue;
                this.files.put(name, file);
            }
        }
    }

    private void updateMaps() {
        ArrayList<SwcScript> scriptList = new ArrayList<SwcScript>();
        Iterator swcit = this.swcs.values().iterator();
        while (swcit.hasNext()) {
            Swc swc = (Swc)swcit.next();
            Iterator libit = swc.getLibraryIterator();
            while (libit.hasNext()) {
                SwcLibrary lib = (SwcLibrary)libit.next();
                Iterator scriptit = lib.getScriptIterator();
                while (scriptit.hasNext()) {
                    SwcScript script = (SwcScript)scriptit.next();
                    scriptList.add(script);
                }
            }
        }
        Object[] scriptArray = scriptList.toArray();
        Arrays.sort(scriptArray, new Comparator(this){
            final /* synthetic */ SwcGroup this$0;
            {
                void arg0;
                this.this$0 = arg0;
            }

            public int compare(Object o1, Object o2) {
                long o2mod;
                long o1mod = ((SwcScript)o1).getLastModified();
                if (o1mod == (o2mod = ((SwcScript)o2).getLastModified())) {
                    return 0;
                }
                if (o1mod < o2mod) {
                    return 1;
                }
                return -1;
            }
        });
        this.def2script = new HashMap();
        this.qnames = new HashSet();
        for (int i = 0; i < scriptArray.length; ++i) {
            SwcScript s = (SwcScript)scriptArray[i];
            String name = s.getName();
            DoABC doABC = null;
            try {
                doABC = s.getDoABC();
            }
            catch (Exception e) {
                SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(s.getSwcLocation(), e);
                throw ex;
            }
            if (!$assertionsDisabled && !name.equals(doABC.name)) {
                throw new Error();
            }
            HashMap<String, SwcScript> staging = new HashMap<String, SwcScript>();
            Iterator defit = s.getDefinitionIterator();
            while (defit.hasNext()) {
                String def = (String)defit.next();
                staging.put(def, s);
                if (!this.def2script.containsKey(def)) continue;
                staging = null;
                break;
            }
            if (staging == null) continue;
            Iterator iterator = staging.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String def = (String)entry.getKey();
                this.qnames.add(def);
                this.def2script.put(def, entry.getValue());
            }
        }
    }

    static {
        $assertionsDisabled = true;
    }
}

