/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc.catalog;

import adobe.asc.authoring.swc.Component;
import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcFile;
import adobe.asc.authoring.swc.SwcLibrary;
import adobe.asc.authoring.swc.Versions;
import adobe.asc.authoring.swc.catalog.CatalogHandler;
import flex2.compiler.swc.Features;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.catalog.CatalogReadElement;
import flex2.compiler.swc.catalog.ReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CatalogReader {
    private InputStream stream;
    protected Swc swc;
    private SwcArchive archive;
    private Versions versions = new Versions();
    private Features features = new Features();
    private Map components = new HashMap();
    private Map libraries = new HashMap();
    private Map files = new HashMap();
    CatalogReadElement defaultReadElement = new SwcReader(this);
    private VersionReader versionReader = new VersionReader(this);
    private FeatureReader featureReader = new FeatureReader(this);
    private ComponentReader componentReader = new ComponentReader(this);
    private LibraryReader libraryReader = new LibraryReader(this);
    private ScriptReader scriptReader = new ScriptReader(this);
    private FilesReader filesReader = new FilesReader(this);

    public CatalogReader(InputStream stream, Swc swc, SwcArchive archive) {
        this.stream = stream;
        this.swc = swc;
        this.archive = archive;
    }

    public void read() throws IOException, ParserConfigurationException, SAXException {
        if (this.stream == null) {
            throw new SwcException.NullCatalogStream();
        }
        CatalogHandler handler = new CatalogHandler(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(this.stream, (DefaultHandler)handler);
        handler.clear();
    }

    public Versions getVersions() {
        return this.versions;
    }

    public Features getFeatures() {
        return this.features;
    }

    public Map getComponents() {
        return this.components;
    }

    public Map getLibraries() {
        return this.libraries;
    }

    public Map getFiles() {
        return this.files;
    }

    public static String readAttribute(String name, Attributes attributes, boolean required) {
        String val = attributes.getValue(name);
        if (val == null && required) {
            throw new SwcException.NoElementValue(name);
        }
        return val;
    }

    public static Long readAttributeLong(String name, Attributes attributes, boolean required) {
        Long val = null;
        String str = CatalogReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = new Long(str);
        }
        return val;
    }

    class FilesReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        FilesReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("file".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                Long mod = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
                SwcFile file = new SwcFile(path, mod, this.this$0.swc, this.this$0.archive);
                this.this$0.files.put(path, file);
                return this;
            }
            throw new SwcException.UnknownElementInCatalog("files", current);
        }
    }

    class ScriptReader
    extends CatalogReadElement {
        public SwcLibrary currentLibrary;
        private String name;
        private long modtime;
        private Set defs;
        private SwcDependencySet depSet;
        static final /* synthetic */ boolean $assertionsDisabled;
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        ScriptReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("script".equals(current)) {
                this.name = CatalogReader.readAttribute("name", context.getCurrentAttributes(), true);
                this.modtime = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
            } else if ("def".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                this.defs.add(id);
            } else if ("dep".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                String type = CatalogReader.readAttribute("type", context.getCurrentAttributes(), false);
                this.depSet.addDependency(type, id);
            } else if (!"ext".equals(current)) {
                throw new SwcException.UnknownElementInCatalog("script", current);
            }
            return this;
        }

        public void endElement(ReadContext context) {
            if ("script".equals(context.getCurrentName())) {
                if (!$assertionsDisabled && this.currentLibrary == null) {
                    throw new Error();
                }
                if (!$assertionsDisabled && this.name == null) {
                    throw new Error();
                }
                this.currentLibrary.addScript(this.name, this.defs, this.depSet, this.modtime);
                this.clear();
            }
        }

        public void clear() {
            ((CatalogReader)this.this$0).scriptReader.name = null;
            ((CatalogReader)this.this$0).scriptReader.modtime = -1L;
            ((CatalogReader)this.this$0).scriptReader.defs = new TreeSet();
            ((CatalogReader)this.this$0).scriptReader.depSet = new SwcDependencySet();
        }

        static {
            $assertionsDisabled = true;
        }
    }

    class LibraryReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        LibraryReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("library".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                SwcLibrary lib = new SwcLibrary(this.this$0.swc, path);
                this.this$0.libraries.put(path, lib);
                this.this$0.scriptReader.clear();
                ((CatalogReader)this.this$0).scriptReader.currentLibrary = lib;
                return this.this$0.scriptReader;
            }
            throw new SwcException.UnknownElementInCatalog("libraries", current);
        }
    }

    class ComponentReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        ComponentReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("component".equals(current)) {
                Component comp = new Component();
                Attributes attrib = context.getCurrentAttributes();
                comp.setClassName(CatalogReader.readAttribute("className", attrib, true));
                comp.setName(CatalogReader.readAttribute("name", attrib, false));
                comp.setUri(CatalogReader.readAttribute("uri", attrib, false));
                comp.setIcon(CatalogReader.readAttribute("icon", attrib, false));
                comp.setDocs(CatalogReader.readAttribute("docs", attrib, false));
                comp.setPreview(CatalogReader.readAttribute("preview", attrib, false));
                comp.setToolTip(CatalogReader.readAttribute("tooltip", attrib, false));
                comp.setCustomUI(CatalogReader.readAttribute("customUI", attrib, false));
                comp.setCustomUIDisplay(CatalogReader.readAttributeLong("customUIDisplay", attrib, false));
                this.this$0.components.put(comp.getClassName(), comp);
                return this;
            }
            throw new SwcException.UnknownElementInCatalog("components", current);
        }
    }

    class FeatureReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        FeatureReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String name = context.getCurrentName();
            if ("feature-debug".equals(name)) {
                this.this$0.features.setDebug(true);
            } else if ("feature-external-deps".equals(name)) {
                this.this$0.features.setExternalDeps(true);
            } else if ("feature-script-deps".equals(name)) {
                this.this$0.features.setScriptDeps(true);
            } else if ("feature-components".equals(name)) {
                this.this$0.features.setComponents(true);
            } else if ("feature-files".equals(name)) {
                this.this$0.features.setFiles(true);
            } else {
                Attributes attrib = context.getCurrentAttributes();
                String req = attrib.getValue("required");
                if (req != null && req.equalsIgnoreCase("true")) {
                    throw new SwcException.UnsupportedFeature(name);
                }
            }
            return this;
        }
    }

    class VersionReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        VersionReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("flex".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                this.this$0.versions.setFlexVersion(CatalogReader.readAttribute("version", attrib, true));
                this.this$0.versions.setFlexBuild(CatalogReader.readAttribute("build", attrib, false));
            } else if ("flash".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                this.this$0.versions.setFlexVersion(CatalogReader.readAttribute("version", attrib, true));
                this.this$0.versions.setFlexBuild(CatalogReader.readAttribute("build", attrib, false));
                this.this$0.versions.setPlatform(CatalogReader.readAttribute("platform", attrib, false));
            } else if ("swc".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                this.this$0.versions.setLibVersion(CatalogReader.readAttribute("version", attrib, true));
            }
            return this;
        }
    }

    class SwcReader
    extends CatalogReadElement {
        final /* synthetic */ CatalogReader this$0;

        /*
         * WARNING - void declaration
         */
        SwcReader(CatalogReader catalogReader) {
            void arg0;
            this.this$0 = arg0;
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("versions".equals(current)) {
                return this.this$0.versionReader;
            }
            if ("features".equals(current)) {
                return this.this$0.featureReader;
            }
            if ("components".equals(current)) {
                return this.this$0.componentReader;
            }
            if ("files".equals(current)) {
                return this.this$0.filesReader;
            }
            if ("libraries".equals(current)) {
                return this.this$0.libraryReader;
            }
            if ("swc".equals(current)) {
                return this;
            }
            if ("digest".equals(current)) {
                return null;
            }
            throw new SwcException.UnknownElementInCatalog("swc", current);
        }
    }
}

