/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc.catalog;

import adobe.asc.authoring.swc.Component;
import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcLibrary;
import adobe.asc.authoring.swc.SwcScript;
import adobe.asc.authoring.swc.Versions;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Features;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CatalogWriter {
    private Writer writer;
    private Versions versions;
    private Features features;
    private Collection components;
    private Collection libraries;
    private Collection files;
    public static String ls;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CatalogWriter(Writer stream, Versions versions, Features features, Collection components, Collection libraries, Collection files) {
        this.writer = stream;
        this.versions = versions;
        this.features = features;
        this.components = components;
        this.libraries = libraries;
        this.files = files;
    }

    public void write() throws IOException {
        if (!$assertionsDisabled && this.writer == null) {
            throw new Error();
        }
        this.writer.write("<?xml version=\"1.0\" encoding =\"utf-8\"?>" + ls);
        this.writer.write("<swc xmlns=\"http://www.adobe.com/flash/swccatalog/9\">" + ls);
        if (this.versions != null) {
            this.writeVersions();
        }
        if (this.features != null) {
            this.writeFeatures();
        }
        if (this.components != null && this.components.size() > 0) {
            this.writeComponents();
        }
        if (this.libraries != null && this.libraries.size() > 0) {
            this.writeLibraries();
        }
        if (this.files != null && this.files.size() > 0) {
            this.writeFiles();
        }
        this.writer.write("</swc>" + ls);
        this.writer.flush();
    }

    private void writeVersions() throws IOException {
        this.writer.write("  <versions>" + ls);
        this.writer.write("    <swc ");
        this.writeAttribute("version", "" + this.versions.getLibVersion(), "versions", true, this.writer);
        this.writer.write("/>" + ls);
        this.writer.write("    <flash ");
        this.writeAttribute("version", "" + this.versions.getFlexVersion(), "versions", true, this.writer);
        this.writeAttribute("build", "" + this.versions.getFlexBuild(), "versions", true, this.writer);
        this.writeAttribute("platform", this.versions.getPlatform(), "versions", true, this.writer);
        this.writer.write("/>" + ls);
        this.writer.write("  </versions>" + ls);
    }

    private void writeFeatures() throws IOException {
        this.writer.write("  <features>" + ls);
        this.writeFeature(this.writer, "feature-debug", this.features.isDebug());
        this.writeFeature(this.writer, "feature-script-deps", this.features.isScriptDeps());
        this.writeFeature(this.writer, "feature-external-deps", this.features.hasExternalDeps());
        this.writeFeature(this.writer, "feature-components", this.features.isComponents());
        this.writeFeature(this.writer, "feature-files", this.features.isFiles());
        this.writer.write("  </features>" + ls);
    }

    private void writeFeature(Writer writer, String feature, boolean enabled) throws IOException {
        if (enabled) {
            writer.write("    <" + feature + " />" + ls);
        }
    }

    private void writeComponents() throws IOException {
        this.writer.write("  <components>" + ls);
        String cls = "component";
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component comp = (Component)iterator.next();
            this.writer.write("    <component ");
            this.writeAttribute("className", comp.getClassName(), cls, true, this.writer);
            this.writeAttribute("name", comp.getName(), cls, false, this.writer);
            this.writeAttribute("uri", comp.getUri(), cls, false, this.writer);
            this.writeAttribute("icon", comp.getIcon(), cls, false, this.writer);
            this.writeAttribute("docs", comp.getDocs(), cls, false, this.writer);
            this.writeAttribute("preview", comp.getPreview(), cls, false, this.writer);
            this.writeAttribute("tooltip", comp.getToolTip(), cls, false, this.writer);
            this.writeAttribute("customUI", comp.getCustomUI(), cls, false, this.writer);
            this.writeAttribute("customUIDisplay", comp.getCustomUIDisplay(), cls, false, this.writer);
            this.writer.write(" />" + ls);
        }
        this.writer.write("  </components>" + ls);
    }

    private void writeLibraries() throws IOException {
        this.writer.write("  <libraries>" + ls);
        Iterator libit = this.libraries.iterator();
        while (libit.hasNext()) {
            SwcLibrary swcLibrary = (SwcLibrary)libit.next();
            this.writer.write("    <library path=\"" + swcLibrary.getPath() + "\">" + ls);
            Iterator extit = swcLibrary.getExterns().iterator();
            while (extit.hasNext()) {
                this.writer.write("      <ext>" + extit.next() + "</ext>" + ls);
            }
            HashSet<String> scriptSet = new HashSet<String>();
            Iterator scriptit = swcLibrary.getScriptIterator();
            while (scriptit.hasNext()) {
                SwcScript swcScript = (SwcScript)scriptit.next();
                String scriptName = swcScript.getName();
                if (scriptSet.contains(scriptName)) {
                    throw new SwcException.ScriptUsedMultipleTimes(scriptName);
                }
                scriptSet.add(scriptName);
                this.writer.write("      <script ");
                this.writeAttribute("name", scriptName, "script", true, this.writer);
                this.writeAttribute("mod", new Long(swcScript.getLastModified()), "script", true, this.writer);
                this.writer.write(">" + ls);
                Iterator it = swcScript.getDefinitionIterator();
                while (it.hasNext()) {
                    String defname = (String)it.next();
                    this.writer.write("        <def id=\"" + defname + "\" /> " + ls);
                }
                SwcDependencySet depset = swcScript.getDependencySet();
                Iterator typeit = depset.getTypeIterator();
                while (typeit.hasNext()) {
                    String type = (String)typeit.next();
                    Iterator depit = depset.getDependencyIterator(type);
                    while (depit.hasNext()) {
                        String dep = (String)depit.next();
                        this.writer.write("        <dep id=\"" + dep + "\" type=\"" + type + "\" /> " + ls);
                    }
                }
                this.writer.write("      </script>" + ls);
            }
            this.writer.write("    </library>" + ls);
        }
        this.writer.write("  </libraries>" + ls);
    }

    private void writeFiles() throws IOException {
        this.writer.write("  <files>" + ls);
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (Swc.CATALOG_XML.equals(vFile.getName()) || Swc.LIBRARY_SWF.equals(vFile.getName())) continue;
            this.writer.write("    <file path=\"" + vFile.getName() + "\" mod=\"" + vFile.getLastModified() + "\" />" + ls);
        }
        this.writer.write("  </files>" + ls);
    }

    private void writeAttribute(String name, Object val, String cls, boolean required, Writer writer) throws IOException {
        if (val == null) {
            if (required) {
                throw new SwcException.NoElementValueFound(name, cls);
            }
        } else {
            writer.write(name + "=\"" + val.toString() + "\" ");
        }
    }

    static {
        $assertionsDisabled = true;
        ls = System.getProperty("line.separator");
    }
}

