/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.zip;

import java.io.IOException;

public class RandomAccessMemoryFile {
    private byte[] buffer;
    private int bufferPtr;

    public RandomAccessMemoryFile(byte[] rawBytes) {
        this.buffer = rawBytes;
        this.bufferPtr = 0;
    }

    public void close() throws IOException {
        this.buffer = null;
        this.bufferPtr = 0;
    }

    public void readFully(byte[] readBytes) throws IOException {
        try {
            System.arraycopy(this.buffer, this.bufferPtr, readBytes, 0, readBytes.length);
            this.bufferPtr += readBytes.length;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayStoreException ase) {
            ase.printStackTrace();
            throw new IOException("ArrayStoreException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            ioobe.printStackTrace();
            throw new IOException("IndexOutOfBoundsException");
        }
    }

    public int skipBytes(int numBytes) throws IOException {
        try {
            if (numBytes < 0) {
                return 0;
            }
            if (this.bufferPtr + numBytes >= this.buffer.length) {
                int returnValue = this.buffer.length - this.bufferPtr - 1;
                this.bufferPtr = this.buffer.length - 1;
                return returnValue;
            }
            this.bufferPtr += numBytes;
            return numBytes;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            throw new IOException("ArithmeticException");
        }
    }

    public long length() throws IOException {
        try {
            return this.buffer.length;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new IOException("NullPointerException");
        }
    }

    public int read() throws IOException {
        try {
            int returnValue = 0xFF & this.buffer[this.bufferPtr++];
            return returnValue;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            aioobe.printStackTrace();
            throw new IOException("ArrayIndexOutOfBoundsException");
        }
    }

    public int read(byte[] readBytes, int offset, int len) throws IOException {
        try {
            System.arraycopy(this.buffer, this.bufferPtr, readBytes, offset, len);
            this.bufferPtr += len;
            return len;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new IOException("NullPointerException");
        }
        catch (ArrayStoreException ase) {
            ase.printStackTrace();
            throw new IOException("ArrayStoreException");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            aioobe.printStackTrace();
            throw new IOException("ArrayIndexOutOfBoundsException");
        }
    }

    public void seek(long offset) throws IOException {
        try {
            this.bufferPtr = (int)offset;
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            throw new IOException("ArithmeticException");
        }
    }
}

