/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public class AttributeListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(1);
    public boolean hasIntrinsic;
    public boolean hasStatic;
    public boolean hasFinal;
    public boolean hasVirtual;
    public boolean hasOverride;
    public boolean hasDynamic;
    public boolean hasNative;
    public boolean hasPrivate;
    public boolean hasProtected;
    public boolean hasPublic;
    public boolean hasInternal;
    public boolean hasConst;
    public boolean hasFalse;
    public boolean hasPrototype;
    public Namespaces namespaces = new Namespaces(3);
    public ObjectList<String> namespace_ids = new ObjectList(3);
    private ObjectValue userNamespace;

    public AttributeListNode(Node item, int pos) {
        super(pos);
        this.items.add(item);
        this.hasIntrinsic = false;
        this.hasStatic = false;
        this.hasFinal = false;
        this.hasVirtual = false;
        this.hasOverride = false;
        this.hasDynamic = false;
        this.hasNative = false;
        this.hasPrivate = false;
        this.hasProtected = false;
        this.hasPublic = false;
        this.hasInternal = false;
        this.hasConst = false;
        this.hasFalse = false;
        this.hasPrototype = false;
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    int size() {
        return this.items.size();
    }

    public int pos() {
        return this.items.size() != 0 ? this.items.last().pos() : 0;
    }

    public String toString() {
        return "AttributeList";
    }

    public boolean isAttribute() {
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            if (!n.isAttribute()) continue;
            return false;
        }
        return true;
    }

    public boolean hasAttribute(String name) {
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            if (!n.hasAttribute(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isLabel() {
        return this.items.size() == 1 && this.items.last().isLabel();
    }

    public ObjectValue getUserNamespace() {
        return this.userNamespace;
    }

    public void setUserNamespace(ObjectValue userNamespace) {
        this.userNamespace = userNamespace;
    }

    public boolean hasUserNamespace() {
        return this.userNamespace != null;
    }
}

