/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.IOException;
import java.io.InputStream;

final class InputBufferStream
extends InputStream {
    private byte[] bom;
    private final InputStream in;
    private int index;

    InputBufferStream(byte[] bom, InputStream in) {
        this.bom = bom;
        this.in = in;
        this.index = 0;
    }

    public int read() throws IOException {
        if (this.bom == null) {
            return this.in.read();
        }
        byte val = this.bom[this.index];
        if (this.index == 2) {
            this.bom = null;
        }
        ++this.index;
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (this.bom == null) {
            return this.in.read(b, off, len);
        }
        for (i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i > 0 ? i : -1;
            }
            b[off + i] = (byte)c;
        }
        return i;
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("supports read() and close() only...");
    }

    public int available() throws IOException {
        int num = this.in.available();
        if (this.bom == null) {
            return num;
        }
        return 3 - this.index + num;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("supports read() and close() only...");
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("supports read() and close() only...");
    }

    public boolean markSupported() {
        return false;
    }
}

