/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(1);
    public ObjectList<Value> values = new ObjectList(1);

    public ListNode(ListNode list, Node item, int pos) {
        super(pos);
        this.items.add(item);
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public boolean isList() {
        return true;
    }

    public int size() {
        return this.items.size();
    }

    public int pos() {
        return this.items.size() != 0 ? this.items.last().pos() : 0;
    }

    public BitSet getGenBits() {
        BitSet genbits = null;
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            genbits = BitSet.reset_set(genbits, n.getKillBits(), n.getGenBits());
        }
        return genbits;
    }

    public BitSet getKillBits() {
        BitSet killbits = null;
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            killbits = BitSet.reset_set(killbits, n.getGenBits(), n.getKillBits());
        }
        return killbits;
    }

    public void voidResult() {
        this.items.last().voidResult();
    }

    public String toString() {
        return "List";
    }

    public boolean isAttribute() {
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            if (n.isAttribute()) continue;
            return false;
        }
        return true;
    }

    public boolean isLabel() {
        return this.items.size() == 1 && this.items.last().isLabel();
    }

    public boolean hasAttribute(String name) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            Node n = (Node)this.items.get(i);
            if (!n.hasAttribute(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isLValue() {
        return this.items.size() == 1 && this.items.at(0).isLValue();
    }
}

