/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class VariableDefinitionNode
extends DefinitionNode {
    public int kind;
    public ListNode list;
    public Context cx;

    public VariableDefinitionNode(PackageDefinitionNode pkgdef, AttributeListNode attrs, int kind, ListNode list, int pos) {
        super(pkgdef, attrs, pos);
        this.kind = kind;
        this.list = list;
        this.cx = null;
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.attrs != null && this.attrs.hasAttribute(name);
    }

    public Node initializerStatement(Context cx) {
        NodeFactory nodeFactory = cx.getNodeFactory();
        ListNode list = this.list;
        ListNode init_list = null;
        if (!this.isConst()) {
            Iterator i$ = list.items.iterator();
            while (i$.hasNext()) {
                Node n = (Node)i$.next();
                VariableBindingNode binding = (VariableBindingNode)n;
                if (binding.attrs == null && binding.variable.type == null) {
                    NodeFactory nf = cx.getNodeFactory();
                    Node aln = null;
                    binding.variable.identifier = nf.qualifiedIdentifier(aln, binding.variable.identifier);
                }
                if (binding.initializer == null) continue;
                init_list = nodeFactory.list(init_list, nodeFactory.assignmentExpression(binding.variable.identifier, binding.kind == -64 ? -64 : -48, binding.initializer));
            }
        }
        if (init_list != null) {
            ExpressionStatementNode init = nodeFactory.expressionStatement(init_list);
            init.isVarStatement(true);
            return init;
        }
        return nodeFactory.emptyStatement();
    }

    public int countVars() {
        return this.list.size();
    }

    public void setContext(Context cx) {
        this.cx = cx;
    }

    public Context getContext() {
        return this.cx;
    }

    public String toString() {
        return "VarDefinition";
    }
}

