/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public final class ReferenceValue
extends Value
implements ErrorConstants {
    private ObjectValue base;
    private int get_slot_index;
    private int set_method_slot_index;
    private BitSet ud_bits;
    private TypeValue type;
    private int src_position;
    public Slot slot;
    public String name;
    public Namespaces namespaces;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setPosition(int pos) {
        this.src_position = pos - 1;
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, ObjectValue qualifier) {
        this(cx, base, name, qualifier, -78);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, ObjectValue qualifier, int kind) {
        this.setKind(kind);
        this.base = base;
        if (!$assertionsDisabled && name.intern() != name) {
            throw new Error();
        }
        this.name = name;
        this.setQualified(qualifier != null);
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.namespaces = cx.statics.internNamespaces.intern(qualifier);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, Namespaces namespaces) {
        this(cx, base, name, namespaces, -78);
    }

    public ReferenceValue(Context cx, ObjectValue base, String name, Namespaces namespaces, int kind) {
        this.setKind(kind);
        this.base = base;
        if (!$assertionsDisabled && name.intern() != name) {
            throw new Error();
        }
        this.name = name;
        this.namespaces = cx.statics.internNamespaces.intern(namespaces);
        this.slot = null;
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.ud_bits = null;
        this.type = null;
    }

    public void setIsAttributeIdentifier(boolean is_attrid) {
        this.flags = is_attrid ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isAttributeIdentifier() {
        return (this.flags & 0x10) != 0;
    }

    public Value getValue(Context cx) {
        Slot s = this.getSlot(cx, this.getKind());
        if (s != null && s.getMethodID() < 0) {
            return s.getValue();
        }
        return null;
    }

    public TypeValue getType(Context cx) {
        return this.getType(cx, this.getKind());
    }

    public TypeValue getType(Context cx, int kind) {
        if (this.type == null) {
            TypeValue slottype = null;
            TypeValue deftype = cx.getDefType(this.ud_bits);
            Slot s = this.getSlot(cx, kind);
            if (s != null) {
                slottype = s.getType();
            }
            if (slottype == null) {
                slottype = cx.noType();
            }
            this.type = slottype.includes(cx, deftype) ? (slottype == cx.numberType() || slottype == cx.noType() ? slottype : deftype) : slottype;
            if (this.type == null) {
                this.type = cx.noType();
            }
        }
        return this.type;
    }

    public Slot getSlot(Context cx) {
        return this.getSlot(cx, -78);
    }

    public Slot getSlot(Context cx, int kind) {
        if (this.slot == null) {
            if (this.isAttributeIdentifier()) {
                return null;
            }
            this.setKind(kind == -97 ? -97 : -78);
            if (this.lookup(cx, this.flags)) {
                if (kind == this.getKind()) {
                    return this.slot;
                }
            } else if (kind != -78) {
                return null;
            }
        }
        Slot slot = this.slot;
        if (this.getKind() != kind) {
            ObjectValue base;
            if (this.base != null) {
                base = this.base;
            } else if (this.getScopeIndex() >= 0) {
                base = (ObjectValue)cx.getScopes().get(this.getScopeIndex());
            } else {
                return null;
            }
            switch (kind) {
                case -97: {
                    this.slot = slot = base.getSlot(cx, this.getSetSlotIndex());
                    this.setKind(-97);
                    break;
                }
                case -78: {
                    this.slot = slot = base.getSlot(cx, this.getGetSlotIndex());
                    this.setKind(-78);
                    break;
                }
                default: {
                    this.slot = slot = base.getSlot(cx, this.getGetSlotIndex());
                    this.setKind(-78);
                    if (slot == null) break;
                    int index = slot.implies(cx, kind);
                    slot = base.getSlot(cx, index);
                }
            }
        }
        return slot;
    }

    public boolean lookup(Context cx, int flags) {
        boolean is_found = false;
        if (this.base == null) {
            ObjectList<ObjectValue> scopes = cx.getScopes();
            int lowestScope = this.isTypeAnnotation() ? 0 : cx.statics.withDepth + 1;
            for (int i = scopes.size() - 1; i >= lowestScope; --i) {
                this.base = scopes.at(i);
                is_found = this.lookupWithBase(cx, flags);
                if (!is_found) continue;
                this.setScopeIndex(i);
                break;
            }
            this.base = null;
        } else {
            is_found = this.lookupWithBase(cx, flags);
        }
        return is_found;
    }

    public boolean lookupWithBase(Context cx, int flags) {
        if (!this.isQualified()) {
            return this.findUnqualified(cx, flags);
        }
        return this.findQualified(cx, flags);
    }

    public boolean findQualified(Context cx, int flags) {
        int size = this.namespaces.size();
        for (int i = 0; i < size; ++i) {
            ObjectValue qualifier = (ObjectValue)this.namespaces.get(i);
            for (ObjectValue obj = this.base; obj != null; obj = obj.proto()) {
                if (!obj.hasName(cx, this.getKind(), this.name, qualifier)) continue;
                this.bindToSlot(cx, obj, qualifier);
                return true;
            }
        }
        return false;
    }

    public boolean findUnqualified(Context cx, int flags) {
        Namespaces hasNamespaces = null;
        for (ObjectValue obj = this.base; obj != null; obj = obj.proto()) {
            int opposite_kind;
            Namespaces hasNamespaces2;
            hasNamespaces = obj.hasNames(cx, this.getKind(), this.name, this.namespaces);
            if (hasNamespaces == null) continue;
            ObjectValue localQualifier = null;
            boolean error_reported = false;
            if ((this.getKind() == -97 || this.getKind() == -78) && (hasNamespaces2 = obj.hasNames(cx, opposite_kind = this.getKind() == -97 ? -78 : -97, this.name, this.namespaces)) != null) {
                localQualifier = null;
                for (int i = 0; i < hasNamespaces2.size(); ++i) {
                    localQualifier = (ObjectValue)hasNamespaces2.at(i);
                    if (error_reported || hasNamespaces.contains(localQualifier)) continue;
                    cx.error(this.src_position, 1000, this.name);
                    error_reported = true;
                    break;
                }
            }
            int last_index = 0;
            for (int i = 0; i < hasNamespaces.size(); ++i) {
                localQualifier = (ObjectValue)hasNamespaces.at(i);
                int index = obj.getSlotIndex(cx, this.getKind(), this.name, localQualifier);
                Slot slot = obj.getSlot(cx, index);
                if (slot == null || slot.getBaseNode() != null) continue;
                if (last_index != 0 && index != last_index && !error_reported) {
                    cx.error(this.src_position, 1000, this.name);
                    error_reported = true;
                }
                last_index = index;
            }
            this.bindToSlot(cx, obj, localQualifier);
            hasNamespaces.clear();
            return true;
        }
        return false;
    }

    private void bindToSlot(Context cx, ObjectValue obj, ObjectValue qualifier) {
        boolean isXMLProperty;
        int set_slot_index = obj.getSlotIndex(cx, -97, this.name, qualifier);
        int get_slot_index = obj.getSlotIndex(cx, -78, this.name, qualifier);
        int method_slot_index = obj.getSlotIndex(cx, -131, this.name, qualifier);
        this.setGetSlotIndex(get_slot_index);
        if (method_slot_index != -1) {
            this.setMethodSlotIndex(method_slot_index);
        } else {
            this.setSetSlotIndex(set_slot_index);
        }
        this.slot = obj.getSlot(cx, obj.getSlotIndex(cx, this.getKind(), this.name, qualifier));
        boolean bl = isXMLProperty = this.slot != null && this.slot.declaredBy != null && (this.slot.declaredBy.type == cx.xmlType() || this.slot.declaredBy.type == cx.xmlListType());
        if (cx.useStaticSemantics() && !isXMLProperty) {
            this.setQualifier(cx, qualifier);
        }
    }

    public void calcUseDefinitions(Context cx, BitSet rch_bits) {
        Slot slot;
        this.getSlot(cx, -78);
        if (this.getGetSlotIndex() < 0) {
            return;
        }
        if (this.base != null && this.base.getType(cx) == cx.noType() && this.getGetSlotIndex() >= 0) {
            slot = this.base.getSlot(cx, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == 0 && this.getGetSlotIndex() >= 0) {
            slot = cx.globalScope().getSlot(cx, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == cx.getScopes().size() - 1) {
            slot = cx.scope().getSlot(cx, this.getGetSlotIndex());
        } else {
            return;
        }
        if (slot != null) {
            this.ud_bits = BitSet.and(rch_bits, slot.getDefBits());
        }
    }

    public boolean usedBeforeInitialized() {
        return BitSet.isEmpty(this.ud_bits);
    }

    public int getSlotIndex(int kind) {
        if (kind == -78) {
            return this.getGetSlotIndex();
        }
        if (kind == -97) {
            return this.getSetSlotIndex();
        }
        if (kind == -131) {
            return this.getMethodSlotIndex();
        }
        if (!$assertionsDisabled) {
            throw new Error();
        }
        return -1;
    }

    public int getScopeIndex(int kind) {
        return this.getScopeIndex();
    }

    public ReferenceValue setBase(ObjectValue base) {
        this.base = base;
        return this;
    }

    public ObjectValue getBase() {
        return this.base;
    }

    public boolean isReference() {
        return true;
    }

    public void setQualifier(Context cx, ObjectValue qual) {
        this.setQualified(qual != null);
        this.namespaces = cx.statics.internNamespaces.intern(qual);
    }

    public String toMultiName() {
        return this.namespaces.toString() + "::" + this.name;
    }

    public boolean isQualified() {
        return (this.flags & 4) != 0;
    }

    private void setQualified(boolean qualified) {
        this.flags = qualified ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public String toString() {
        return super.toString();
    }

    public void setImmutableNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public Namespaces getImmutableNamespaces() {
        return this.namespaces;
    }

    public void setScopeIndex(int scope_index) {
        this.flags &= 0xFFFF;
        this.flags |= scope_index << 16 & 0xFFFF0000;
    }

    public int getScopeIndex() {
        short i = (short)((this.flags & 0xFFFF0000) >> 16);
        return i;
    }

    public void setKind(int kind) {
        this.flags &= 0xFFFF00FF;
        this.flags |= kind << 8 & 0xFF00;
    }

    public int getKind() {
        byte b = (byte)((this.flags & 0xFF00) >> 8);
        return b;
    }

    private void setGetSlotIndex(int get_slot_index) {
        this.get_slot_index = get_slot_index;
    }

    private int getGetSlotIndex() {
        return this.get_slot_index;
    }

    private void setMethodSlotIndex(int method_slot_index) {
        this.flags |= 2;
        this.set_method_slot_index = method_slot_index;
    }

    private int getMethodSlotIndex() {
        return (this.flags & 2) != 0 ? this.set_method_slot_index : -1;
    }

    private void setSetSlotIndex(int set_slot_index) {
        this.flags &= 0xFFFFFFFD;
        this.set_method_slot_index = set_slot_index;
    }

    private int getSetSlotIndex() {
        return (this.flags & 2) != 0 ? -1 : this.set_method_slot_index;
    }

    public void setTypeAnnotation(boolean isTypeAnnotation) {
        this.flags = isTypeAnnotation ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public boolean isTypeAnnotation() {
        return (this.flags & 0x20) != 0;
    }

    static {
        $assertionsDisabled = true;
    }
}

