/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.io.File;
import java.util.StringTokenizer;

public class StringUtils {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String[] split(String input, String regularExpression) {
        return input.split(regularExpression);
    }

    public static String[] split(String input, String regularExpression, int limit) {
        return input.split(regularExpression, limit);
    }

    public static String replaceFirst(String target, String regex, String replacement) {
        return target.replaceFirst(regex, replacement);
    }

    public static String[] splitPath(String paths) {
        if (File.pathSeparator.equals(";")) {
            return StringUtils.split(paths, File.pathSeparator);
        }
        return StringUtils.split(paths, File.pathSeparator + "|;");
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String replaceAll(String input, String regularExpression, String replacement) {
        return input.replaceAll(regularExpression, replacement);
    }

    public static String substitute(String str, String from, String to) {
        if (from == null || from.equals("") || to == null) {
            return str;
        }
        int index = str.indexOf(from);
        if (index == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        int lastIndex = 0;
        while (index != -1) {
            buf.append(str.substring(lastIndex, index));
            buf.append(to);
            lastIndex = index + from.length();
            index = str.indexOf(from, lastIndex);
        }
        buf.append(str.substring(lastIndex));
        return buf.toString();
    }

    public static int findNthUnescaped(char charToFind, int n, String s) {
        char[] charArray = s.toCharArray();
        int count = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (i > 0 && charArray[i - 1] == '\\' || charArray[i] != charToFind || ++count != n) continue;
            return i;
        }
        return -1;
    }

    public static int findNextUnescaped(char charToFind, int startIdx, String s) {
        if (startIdx >= s.length()) {
            return -1;
        }
        char[] charArray = s.toCharArray();
        for (int i = startIdx; i < charArray.length; ++i) {
            if (i > 0 && charArray[i - 1] == '\\' || charArray[i] != charToFind) continue;
            return i;
        }
        return -1;
    }

    public static String cleanupEscapedChar(char escapedChar, String toClean) {
        if (toClean == null || toClean.indexOf(escapedChar) == -1 || toClean.indexOf(92) == -1) {
            return toClean;
        }
        StringBuffer buf = new StringBuffer(toClean.length());
        char[] chars = toClean.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] == '\\' && chars[i + 1] == escapedChar) continue;
            buf.append(chars[i]);
        }
        buf.append(chars[chars.length - 1]);
        return buf.toString();
    }

    public static int findClosingToken(char openToken, char closeToken, String s, int startIdx) {
        int closeIdx = startIdx + 1;
        int subTokenCount = 0;
        while (closeIdx < s.length()) {
            char c = s.charAt(closeIdx);
            if (s.charAt(closeIdx - 1) == '\\') {
                ++closeIdx;
                continue;
            }
            if (c == openToken) {
                ++subTokenCount;
            } else if (c == closeToken) {
                --subTokenCount;
            }
            if (subTokenCount < 0) break;
            ++closeIdx;
        }
        return closeIdx < s.length() ? closeIdx : -1;
    }

    public static boolean findMatchWithWildcard(String str, String matchStr) {
        char[] src = str == null ? null : str.toCharArray();
        char[] pat = matchStr == null ? null : matchStr.toCharArray();
        return StringUtils.findMatchWithWildcard(src, pat);
    }

    public static boolean findMatchWithWildcard(char[] src, char[] pat) {
        if (src == null || pat == null) {
            return false;
        }
        if (pat.length == 0) {
            return false;
        }
        if (src.length == 0) {
            return pat.length == 0 || pat.length == 1 && (pat[0] == '*' || pat[0] == '?');
        }
        boolean star = false;
        int srcLen = src.length;
        int patLen = pat.length;
        int patIdx = 0;
        block4: for (int srcIdx = 0; srcIdx < srcLen; ++srcIdx) {
            if (patIdx == patLen) {
                if (patLen < srcLen - srcIdx) {
                    patIdx = 0;
                } else {
                    return false;
                }
            }
            char s = src[srcIdx];
            char m = pat[patIdx];
            switch (m) {
                case '*': {
                    if (patIdx == pat.length - 1) {
                        return true;
                    }
                    star = true;
                    ++patIdx;
                    continue block4;
                }
                case '?': {
                    ++patIdx;
                    continue block4;
                }
                default: {
                    if (s != m) {
                        if (star) continue block4;
                        if (patLen < srcLen - srcIdx) {
                            patIdx = 0;
                            continue block4;
                        }
                        return false;
                    }
                    star = false;
                    ++patIdx;
                }
            }
        }
        if (patIdx < patLen) {
            return false;
        }
        return !star;
    }

    public static final int countLines(String buffer) {
        int count = 0;
        int index = buffer.indexOf(10);
        while (index != -1) {
            ++count;
            index = buffer.indexOf(10, index + 1);
        }
        return count;
    }

    public static String entitizeHtml(String buffer) {
        if (buffer == null) {
            return buffer;
        }
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            switch (c) {
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String formatHtml(String buffer) {
        if (buffer == null) {
            return buffer;
        }
        StringBuffer sb = new StringBuffer();
        block3: for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("<br>");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String formatString(String s) {
        StringBuffer result = new StringBuffer(s.length() + 2);
        result.append('\"');
        block9: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                default: {
                    if (s.charAt(i) < ' ') {
                        result.append("\\x").append((int)s.charAt(i)).append("X");
                        continue block9;
                    }
                    result.append(s.charAt(i));
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    public static String collapseWhitespace(String in, char replacementChar) {
        StringBuffer sb = new StringBuffer();
        int size = in.length();
        boolean lastWasSpace = true;
        int i = 0;
        while (i < size) {
            char c;
            boolean ws;
            if (ws = Character.isWhitespace(c = in.charAt(i++))) {
                if (!lastWasSpace) {
                    sb.append(replacementChar);
                }
                lastWasSpace = true;
                continue;
            }
            sb.append(c);
            lastWasSpace = false;
        }
        return sb.toString().trim();
    }

    public static boolean isEnumerationToken(String str, String target, String delimiter) {
        StringTokenizer t = new StringTokenizer(str, delimiter);
        while (t.hasMoreTokens()) {
            if (!t.nextToken().trim().equals(target)) continue;
            return true;
        }
        return false;
    }

    public static String hexDump(byte[] data) {
        StringBuffer buf = new StringBuffer(1024);
        for (int cur = 0; cur < data.length; cur += 16) {
            int i;
            for (i = 0; i < 16; ++i) {
                if (cur + i < data.length) {
                    buf.append(hexchars[data[cur + i] >> 4 & 0xF]);
                    buf.append(hexchars[data[cur + i] & 0xF]);
                } else {
                    buf.append("xx");
                }
                buf.append(i == 7 ? (char)'-' : ' ');
            }
            buf.append("  ");
            for (i = 0; i < 16; ++i) {
                if (cur + i >= data.length) continue;
                if (data[cur + i] >= 32 && data[cur + i] <= 126) {
                    buf.append((char)data[cur + i]);
                    continue;
                }
                buf.append('.');
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

