/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug;

import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.xml.BkptXMLReader;
import flash.tools.debugger.Frame;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import flash.util.ArrayUtil;
import flash.util.Trace;
import flex.tools.debugger.cli.AmbiguousException;
import flex.tools.debugger.cli.BreakAction;
import flex.tools.debugger.cli.FileInfoCache;
import flex.tools.debugger.cli.LocationCollection;
import flex.tools.debugger.cli.NoMatchException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AuthBkptMgr {
    String m_bkptXML;
    Vector m_breakpoints = new Vector();
    FileInfoCache m_fileInfo;
    private Session m_session = null;
    public static final String m_newline = System.getProperty("line.separator");

    public void setBkptXMLSource(String stringOrPath) {
        this.m_bkptXML = stringOrPath;
    }

    public void initFileInfoCache(Session s) {
        this.m_fileInfo = new FileInfoCache();
        this.m_fileInfo.bind(s);
        this.m_session = s;
    }

    public void loadBkptsFromXMLString() {
        try {
            byte[] xmlBytes = this.m_bkptXML.getBytes("UTF-8");
            ByteArrayInputStream in = new ByteArrayInputStream(xmlBytes);
            this.loadBkptsInputStream(in);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void loadBkptsFromXMLPath() {
        InputStream in = this.locateBkptXML(this.m_bkptXML);
        this.loadBkptsInputStream(in);
    }

    public void loadBkptsInputStream(InputStream in) {
        BkptXMLReader reader = new BkptXMLReader(in);
        reader.doRead();
        this.m_fileInfo.getFileList();
        Map breakpoints = reader.getBreakpoints();
        Iterator it = breakpoints.values().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            this.setSingleBreak(s);
        }
    }

    private InputStream locateBkptXML(String path) {
        File f = null;
        boolean exists = false;
        f = new File(path);
        exists = f.exists();
        if (exists) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void shutdown() {
        if (this.m_session == null) {
            return;
        }
        try {
            Location[] bkptList = this.m_session.getBreakpointList();
            int count = bkptList.length;
            for (int i = 0; i < count; ++i) {
                Location l = bkptList[i];
                this.m_session.clearBreakpoint(l);
            }
        }
        catch (NoResponseException e) {
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public void setSingleBreak(String moduleName, int line) {
        int moduleNum = -1;
        try {
            moduleNum = this.parseFileName(moduleName);
            this.setModuleBreakAtLine(moduleNum, line);
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(moduleName);
        }
        catch (NullPointerException npe) {
            this.handleNullPointerException(moduleNum, line);
        }
        catch (AmbiguousException e) {
            // empty catch block
        }
    }

    public void setSingleBreak(String breakStr) {
        int moduleNum = -1;
        int line = -1;
        String arg = breakStr;
        try {
            int[] result = this.parseLocationArg(moduleNum, line, arg);
            moduleNum = result[0];
            line = result[1];
            this.setModuleBreakAtLine(moduleNum, line);
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(arg);
        }
        catch (NullPointerException npe) {
            this.handleNullPointerException(moduleNum, line);
        }
        catch (ParseException e) {
        }
        catch (AmbiguousException e) {
            // empty catch block
        }
    }

    public void setMultipleBreaks(String moduleName, int[] lines) {
        try {
            int moduleNum = this.parseFileName(moduleName);
            this.setModuleBreakArray(moduleNum, lines);
        }
        catch (AmbiguousException e) {
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(moduleName);
        }
    }

    public void setMultipleBreaks(String[] breakStrs) {
        int moduleNum = -1;
        int line = -1;
        String arg = "";
        try {
            for (int i = 0; i < breakStrs.length; ++i) {
                arg = breakStrs[i];
                int[] result = this.parseLocationArg(moduleNum, line, arg);
                moduleNum = result[0];
                line = result[1];
                this.setModuleBreakAtLine(moduleNum, line);
            }
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(arg);
        }
        catch (NullPointerException npe) {
            this.handleNullPointerException(moduleNum, line);
        }
        catch (ParseException e) {
        }
        catch (AmbiguousException e) {
            // empty catch block
        }
    }

    public void setModuleBreakAtLine(int moduleNum, int line) {
        BreakAction b = this.addBreakpoint(moduleNum, line);
        Location l = b.getLocation();
        this.dumpCreatedBkptString(b, l, line);
    }

    BreakAction addBreakpoint(int fileId, int line) throws NullPointerException {
        SourceFile f = this.m_fileInfo.getFile(fileId);
        LocationCollection col = this.enableBreak(f, line);
        BreakAction b = new BreakAction(col);
        b.setEnabled(true);
        b.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
        this.breakpointAdd(b);
        return b;
    }

    public void setModuleBreakArray(int moduleNum, int[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            BreakAction b = this.addBreakpoint(moduleNum, lines[i]);
            Location l = b.getLocation();
            this.dumpCreatedBkptString(b, l, lines[i]);
        }
    }

    private BreakAction addUnresolvedBreakpoint(String unresolvedLocation) {
        BreakAction b = new BreakAction(unresolvedLocation);
        b.setEnabled(true);
        b.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
        this.breakpointAdd(b);
        return b;
    }

    public void removeSingleBreak(String moduleName, int line) {
        try {
            int moduleNum = this.parseFileName(moduleName);
            this.removeModuleBreakAtLine(moduleNum, line);
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(moduleName);
        }
        catch (AmbiguousException e) {
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public void removeSingleBreak(String breakStr) {
        int moduleNum = -1;
        int line = -1;
        String arg = breakStr;
        try {
            int[] result = this.parseLocationArg(moduleNum, line, arg);
            moduleNum = result[0];
            line = result[1];
            this.removeModuleBreakAtLine(moduleNum, line);
        }
        catch (ParseException pe) {
            this.getAuthMgr().out(pe.getMessage());
        }
        catch (NoMatchException nme) {
            try {
                if (this.removeUnresolvedBreakpoint(arg) == null) {
                    this.getAuthMgr();
                }
            }
            catch (NotConnectedException nce) {}
        }
        catch (AmbiguousException ae) {
        }
        catch (ArrayIndexOutOfBoundsException aio) {
        }
        catch (NullPointerException npe) {
        }
        catch (NotConnectedException nce) {
            // empty catch block
        }
    }

    public void removeMultipleBreaks(String moduleName, int[] lines) {
        try {
            int moduleNum = this.parseFileName(moduleName);
            for (int i = 0; i < lines.length; ++i) {
                this.removeModuleBreakAtLine(moduleNum, lines[i]);
            }
        }
        catch (AmbiguousException e) {
        }
        catch (NotConnectedException e) {
        }
        catch (NoMatchException e) {
            this.handleNoMatchException(moduleName);
        }
    }

    BreakAction removeModuleBreakAtLine(int fileId, int line) throws ArrayIndexOutOfBoundsException, NotConnectedException {
        int at = this.breakpointIndexOf(fileId, line);
        if (at > -1) {
            return this.removeBreakpointAt(at);
        }
        return null;
    }

    BreakAction removeUnresolvedBreakpoint(String unresolvedLocation) throws NotConnectedException {
        int size = this.breakpointCount();
        for (int i = 0; i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            String s = b.getBreakpointExpression();
            if (s == null || !s.equals(unresolvedLocation)) continue;
            return this.removeBreakpointAt(i);
        }
        return null;
    }

    BreakAction removeBreakpointAt(int at) throws ArrayIndexOutOfBoundsException, NotConnectedException {
        BreakAction a = this.breakpointAt(at);
        this.m_breakpoints.removeElementAt(at);
        if (a.getStatus() == 1) {
            this.breakDisableRequest(a.getLocations());
        }
        return a;
    }

    BreakAction breakpointAt(int at) {
        return (BreakAction)this.m_breakpoints.elementAt(at);
    }

    boolean breakpointAdd(BreakAction a) {
        return this.m_breakpoints.add(a);
    }

    int breakpointCount() {
        return this.m_breakpoints.size();
    }

    int breakpointIndexOf(int fileId, int line) {
        return this.breakpointIndexOf(fileId, line, 0, true);
    }

    int breakpointIndexOf(Location l, int start) {
        return this.breakpointIndexOf(l.getFile().getId(), l.getLine(), start, true);
    }

    int enabledBreakpointIndexOf(Location l) {
        return this.breakpointIndexOf(l.getFile().getId(), l.getLine(), 0, false);
    }

    int breakpointIndexOf(int fileId, int line, int start, boolean includeDisabled) {
        int size = this.breakpointCount();
        int hit = -1;
        for (int i = start; hit < 0 && i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            if (!b.locationMatches(fileId, line) || !includeDisabled && !b.isEnabled()) continue;
            hit = i;
        }
        return hit;
    }

    int breakpointIndexOf(int id) {
        int size = this.breakpointCount();
        int hit = -1;
        for (int i = 0; hit < 0 && i < size; ++i) {
            BreakAction b = this.breakpointAt(i);
            if (b.getId() != id) continue;
            hit = i;
        }
        return hit;
    }

    LocationCollection enableBreak(SourceFile f, int line) {
        LocationCollection col;
        block5: {
            col = new LocationCollection();
            boolean singleSwfBreakpoint = this.m_fileInfo.isSwfFilterOn();
            SwfInfo swf = this.m_fileInfo.getSwfFilter();
            try {
                if (singleSwfBreakpoint) {
                    Location l = this.findAndEnableBreak(swf, f, line);
                    col.add(l);
                } else {
                    SwfInfo[] swfs = this.m_fileInfo.getSwfs();
                    for (int i = 0; i < swfs.length; ++i) {
                        Location l;
                        swf = swfs[i];
                        if (swf == null || (l = this.findAndEnableBreak(swf, f, line)) == null) continue;
                        col.add(l);
                    }
                }
            }
            catch (InProgressException ipe) {
                if (!Trace.error) break block5;
                Trace.trace((swf == null ? "SWF " : swf.getUrl()) + " still loading, breakpoint at " + f.getName() + ":" + line + " not set");
            }
        }
        return col;
    }

    Location findAndEnableBreak(SwfInfo swf, SourceFile f, int line) throws InProgressException {
        int fileId = f.getId();
        if (swf != null) {
            SourceFile sameFile = this.m_fileInfo.similarFileInSwf(swf, f);
            fileId = sameFile != null ? sameFile.getId() : -1;
        }
        Location l = fileId > -1 ? this.breakEnableRequest(fileId, line) : null;
        return l;
    }

    Location breakEnableRequest(int fileId, int line) {
        Location l = null;
        try {
            l = this.m_session.setBreakpoint(fileId, line);
        }
        catch (NotConnectedException nre) {
        }
        catch (NoResponseException nre) {
            // empty catch block
        }
        return l;
    }

    void breakDisableRequest(LocationCollection col) throws NotConnectedException {
        int at = 0;
        boolean hit = false;
        Location l = col.first();
        do {
            if ((at = this.breakpointIndexOf(l, at)) <= -1) continue;
            if (this.breakpointAt(at).isEnabled()) {
                hit = true;
                continue;
            }
            ++at;
        } while (at > -1 && !hit);
        if (!hit) {
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                l = (Location)itr.next();
                try {
                    this.m_session.clearBreakpoint(l);
                }
                catch (NoResponseException nre) {}
            }
        }
    }

    Location getCurrentLocation() {
        Location where = null;
        try {
            Frame[] ar = this.m_session.getFrames();
            where = ar.length > 0 ? ar[0].getLocation() : null;
        }
        catch (PlayerDebugException playerDebugException) {
            // empty catch block
        }
        return where;
    }

    boolean isCurrentLocation(int module, int line) {
        SourceFile file;
        boolean yes = false;
        Location l = this.getCurrentLocation();
        if (l != null && (file = l.getFile()) != null && file.getId() == module && l.getLine() == line) {
            yes = true;
        }
        return yes;
    }

    private int parseLineNumber(String lineNumber) throws ParseException {
        try {
            return Integer.parseInt(lineNumber);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", lineNumber);
            throw new ParseException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("expectedLineNumber", args), 0);
        }
    }

    private int parseFileNumber(String fileNumber) throws ParseException {
        try {
            return Integer.parseInt(fileNumber);
        }
        catch (NumberFormatException nfe) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", fileNumber);
            throw new ParseException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("expectedFileNumber", args), 0);
        }
    }

    private int parseFileName(String fileName) throws NoMatchException, AmbiguousException {
        SourceFile[] sourceFiles = this.getFiles(this.m_fileInfo, fileName);
        int nSourceFiles = sourceFiles.length;
        if (nSourceFiles == 0) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", fileName);
            throw new NoMatchException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("noSourceFileWithSpecifiedName", args));
        }
        if (nSourceFiles > 1) {
            String s = AuthDebugMgr.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFilenames") + m_newline;
            for (int i = 0; i < nSourceFiles; ++i) {
                SourceFile sourceFile = sourceFiles[i];
                s = s + " " + sourceFile.getName() + "#" + sourceFile.getId();
                if (i >= nSourceFiles - 1) continue;
                s = s + m_newline;
            }
            throw new AmbiguousException(s);
        }
        return sourceFiles[0].getId();
    }

    public SourceFile[] getFiles(FileInfoCache fileInfo, String matchString) {
        SourceFile[] files = fileInfo.getFileList();
        ArrayList<SourceFile> fileList = new ArrayList<SourceFile>();
        int n = files.length;
        int exactHitAt = -1;
        for (int i = 0; i < n; ++i) {
            SourceFile sourceFile = files[i];
            boolean pathExists = sourceFile.getFullPath().matches(".*[/\\\\].*");
            String name = pathExists ? sourceFile.getFullPath() : sourceFile.getName();
            if ((name = name.toLowerCase()).equals(matchString = matchString.toLowerCase())) {
                exactHitAt = i;
                break;
            }
            if (name.startsWith(matchString)) {
                fileList.add(sourceFile);
                continue;
            }
            if (name.endsWith(matchString)) {
                fileList.add(sourceFile);
                continue;
            }
            if (name.indexOf(matchString) <= -1) continue;
            fileList.add(sourceFile);
        }
        if (exactHitAt > -1) {
            fileList.clear();
            fileList.add(files[exactHitAt]);
        }
        Object[] fileArray = fileList.toArray(new SourceFile[fileList.size()]);
        ArrayUtil.sort(fileArray, fileInfo);
        return fileArray;
    }

    private int[] parseFunctionName(int module, String partialFunctionName, boolean onlyThisModule) throws NoMatchException, AmbiguousException {
        SourceFile m = this.m_fileInfo.getFile(module);
        ArrayList functionNames = new ArrayList();
        this.appendFunctionNamesMatching(functionNames, m, partialFunctionName);
        if (functionNames.size() == 0) {
            if (!onlyThisModule) {
                Iterator fileIter = this.m_fileInfo.getAllFiles();
                while (fileIter.hasNext()) {
                    SourceFile nextFile = (SourceFile)((Map.Entry)fileIter.next()).getValue();
                    if (nextFile == m) continue;
                    this.appendFunctionNamesMatching(functionNames, nextFile, partialFunctionName);
                }
            }
            if (functionNames.size() == 0) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("name", partialFunctionName);
                throw new NoMatchException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("noFunctionWithSpecifiedName", args));
            }
        }
        if (functionNames.size() > 1) {
            Object[] functionNameArray = functionNames.toArray(new ModuleFunctionPair[functionNames.size()]);
            ArrayUtil.sort(functionNameArray);
            String s = AuthDebugMgr.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFunctionNames") + m_newline;
            HashMap<String, String> args = new HashMap<String, String>();
            for (int i = 0; i < functionNameArray.length; ++i) {
                String moduleName = this.m_fileInfo.getFile(((ModuleFunctionPair)functionNameArray[i]).moduleId).getName();
                String functionName = ((ModuleFunctionPair)functionNameArray[i]).functionName;
                args.put("functionName", functionName);
                args.put("filename", moduleName + "#" + ((ModuleFunctionPair)functionNameArray[i]).moduleId);
                s = s + " " + AuthDebugMgr.getLocalizationManager().getLocalizedTextString("functionInFile", args);
                if (i >= functionNameArray.length - 1) continue;
                s = s + m_newline;
            }
            throw new AmbiguousException(s);
        }
        ModuleFunctionPair pair = (ModuleFunctionPair)functionNames.get(0);
        module = pair.moduleId;
        m = this.m_fileInfo.getFile(module);
        int line = m.getLineForFunctionName(this.m_session, pair.functionName);
        return new int[]{module, line};
    }

    private void appendFunctionNamesMatching(List functionNameList, SourceFile m, String partialName) {
        int exactHitAt = -1;
        int parenAt = partialName.lastIndexOf(40);
        if (parenAt > -1) {
            partialName = partialName.substring(0, parenAt);
        }
        String[] names = m.getFunctionNames(this.m_session);
        for (int i = 0; i < names.length; ++i) {
            String functionName = names[i];
            if (functionName.equals(partialName)) {
                exactHitAt = i;
                break;
            }
            if (!functionName.startsWith(partialName)) continue;
            functionNameList.add(new ModuleFunctionPair(m.getId(), functionName));
        }
        if (exactHitAt > -1) {
            functionNameList.clear();
            functionNameList.add(new ModuleFunctionPair(m.getId(), names[exactHitAt]));
        }
    }

    public int parseFileArg(int module, String arg) throws ParseException, AmbiguousException, NoMatchException {
        if (arg.length() == 0) {
            return module;
        }
        char firstChar = arg.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '-') {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new ParseException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("expectedFile", args), 0);
        }
        if (firstChar == '#') {
            return this.parseFileNumber(arg.substring(1));
        }
        return this.parseFileName(arg);
    }

    public int parseLineArg(int module, String arg) throws ParseException, AmbiguousException, NoMatchException {
        if (arg.length() == 0) {
            return 1;
        }
        char firstChar = arg.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '-') {
            return this.parseLineNumber(arg);
        }
        if (firstChar == '#') {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("token", arg);
            throw new ParseException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("expectedLineNumber", args), 0);
        }
        int[] moduleAndLine = this.parseFunctionName(module, arg, true);
        return moduleAndLine[1];
    }

    public int[] parseLocationArg(int module, int line, String arg) throws ParseException, AmbiguousException, NoMatchException {
        int colonAt = arg.lastIndexOf(58);
        int wasFunc = 0;
        if (colonAt < 0) {
            char firstChar = arg.charAt(0);
            if (Character.isDigit(firstChar) || firstChar == '-') {
                line = this.parseLineNumber(arg);
            } else if (firstChar == '#') {
                module = this.parseFileNumber(arg.substring(1));
                line = 1;
            } else {
                try {
                    int[] moduleAndLine = this.parseFunctionName(module, arg, false);
                    module = moduleAndLine[0];
                    line = moduleAndLine[1];
                    wasFunc = 1;
                }
                catch (NoMatchException pe) {
                    try {
                        module = this.parseFileName(arg);
                        line = 1;
                    }
                    catch (NoMatchException pee) {
                        HashMap<String, String> args = new HashMap<String, String>();
                        args.put("token", arg);
                        throw new NoMatchException(AuthDebugMgr.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", args));
                    }
                }
            }
        } else {
            module = this.parseFileArg(module, arg.substring(0, colonAt));
            line = this.parseLineArg(module, arg.substring(colonAt + 1));
            wasFunc = arg.substring(colonAt + 1).length() > 1 && Character.isDigit(arg.substring(colonAt + 1).charAt(0)) ? 0 : 1;
        }
        return new int[]{module, line, wasFunc};
    }

    public String module2ClassName(int moduleId) {
        String pkg = null;
        try {
            SourceFile file = this.m_fileInfo.getFile(moduleId);
            pkg = file.getPackageName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pkg;
    }

    private void dumpCreatedBkptString(BreakAction b, Location l, int line) {
    }

    private void handleNoMatchException(String moduleName) {
    }

    private void handleNullPointerException(int moduleNum, int line) {
        try {
            String filename = this.m_fileInfo.getFile(moduleNum).getName() + ":" + line;
            this.getAuthMgr().notify(filename, 12);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private AuthDebugMgr getAuthMgr() {
        return AuthDebugMgr.getAuthMgr();
    }

    private static class ModuleFunctionPair
    implements Comparable {
        public int moduleId;
        public String functionName;

        public ModuleFunctionPair(int moduleId, String functionName) {
            this.moduleId = moduleId;
            this.functionName = functionName;
        }

        public int compareTo(Object arg0) {
            ModuleFunctionPair other = (ModuleFunctionPair)arg0;
            return this.functionName.compareTo(other.functionName);
        }
    }
}

