/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.expression;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.expression.AuthStackContext;
import com.adobe.authoring.debug.expression.AuthVariableContext;
import com.adobe.authoring.debug.expression.IllegalContext;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthValue;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthVariable;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;

public abstract class AuthExpressionContext
implements Context {
    protected Object lookupInVariableList(String name, IAuthVariable[] variables) {
        if (variables == null) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            AuthVariable authVariable = (AuthVariable)variables[i];
            if (!name.equals(authVariable.getName())) continue;
            return authVariable;
        }
        return null;
    }

    protected Object lookupWithinVariable(String member, AuthVariable parentVariable) throws NoSuchVariableException {
        if (member.equals("*")) {
            return parentVariable;
        }
        try {
            return this.lookupInVariableList(member, ((AuthValue)parentVariable.getValue()).getVariables());
        }
        catch (DebugElementNoLongerExistsException e) {
            throw new NoSuchVariableException(member);
        }
    }

    public Object lookupMembers(Object o) throws NoSuchVariableException {
        AuthValue flexValue = null;
        if (o instanceof AuthVariable) {
            try {
                flexValue = (AuthValue)((AuthVariable)o).getValue();
            }
            catch (DebugElementNoLongerExistsException e) {
                return new IAuthVariable[0];
            }
        } else if (o instanceof AuthValue) {
            flexValue = (AuthValue)o;
        }
        if (flexValue != null) {
            return flexValue.getVariables();
        }
        throw new NoSuchVariableException(o);
    }

    public Context createContext(Object o) {
        if (o instanceof AuthStackFrame) {
            return new AuthStackContext((AuthStackFrame)o);
        }
        if (o instanceof AuthVariable) {
            return new AuthVariableContext((AuthVariable)o);
        }
        return new IllegalContext(o);
    }

    public Object assign(Object o, Object v) throws NoSuchVariableException, PlayerFaultException {
        if (!(o instanceof AuthVariable)) {
            throw new NoSuchVariableException(o);
        }
        boolean worked = false;
        if (!(o instanceof AuthVariable)) {
            throw new NoSuchVariableException(o);
        }
        AuthVariable authVariable = (AuthVariable)o;
        try {
            authVariable.setValue(v.toString());
            worked = true;
        }
        catch (AuthDebugException e) {
            // empty catch block
        }
        return new Boolean(worked);
    }
}

