/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.launching;

import flash.tools.debugger.DefaultDebuggerCallbacks;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class AuthDebuggerCallbacks
extends DefaultDebuggerCallbacks {
    private boolean m_computedExeLocations;
    private File m_httpExe;
    private File m_playerExe;

    public synchronized File getHttpExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_httpExe;
    }

    public synchronized File setHttpExe(String path) {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        this.m_httpExe = new File(path);
        return this.m_httpExe;
    }

    public synchronized File getPlayerExe() {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        return this.m_playerExe;
    }

    public synchronized File setPlayerExe(String path) {
        if (!this.m_computedExeLocations) {
            this.recomputeExeLocations();
        }
        this.m_playerExe = new File(path);
        return this.m_playerExe;
    }

    public synchronized void recomputeExeLocations() {
        this.m_httpExe = this.determineExeForType("http");
        this.m_playerExe = this.determineExeForType("ShockwaveFlash.ShockwaveFlash");
        this.m_computedExeLocations = true;
    }

    private File determineExeForType(String type) {
        String it = null;
        try {
            String string = "os.name";
            if (System.getProperty(string).startsWith("Windows")) {
                String[] cmd = new String[]{"cmd", "/c", "ftype", type};
                Process p = Runtime.getRuntime().exec(cmd);
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                type = type + "=";
                while (it == null && (line = lnr.readLine()) != null) {
                    if (line.substring(0, type.length()).compareToIgnoreCase(type) != 0) continue;
                    it = line;
                    break;
                }
                p.destroy();
                if (it != null) {
                    int equalSign = it.indexOf(61);
                    if (equalSign != -1) {
                        it = it.substring(equalSign + 1);
                    }
                    it = this.extractExenameFromCommandString(it);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (it != null) {
            return new File(it);
        }
        return null;
    }

    protected String extractExenameFromCommandString(String cmd) {
        if (cmd.startsWith("\"")) {
            int closingQuote = cmd.indexOf(34, 1);
            if (closingQuote == -1) {
                closingQuote = cmd.length();
            }
            cmd = cmd.substring(1, closingQuote);
        } else {
            int endOfFilename = -1;
            while (true) {
                int nextSpace;
                if ((nextSpace = cmd.indexOf(32, endOfFilename + 1)) == -1) {
                    endOfFilename = -1;
                    break;
                }
                String filename = cmd.substring(0, nextSpace);
                if (!filename.toLowerCase().endsWith(".exe")) {
                    filename = filename + ".exe";
                }
                if (new File(filename).exists()) {
                    endOfFilename = nextSpace;
                    break;
                }
                endOfFilename = nextSpace;
            }
            if (endOfFilename != -1 && endOfFilename < cmd.length()) {
                cmd = cmd.substring(0, endOfFilename);
            }
        }
        return cmd;
    }

    public Process launchDebugTarget(String[] cmd) throws IOException {
        return Runtime.getRuntime().exec(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryWindowsRegistry(String key, String value) throws IOException {
        Process p = null;
        String result = null;
        ArrayList<String> arguments = new ArrayList<String>(6);
        arguments.add("reg.exe");
        arguments.add("query");
        arguments.add(key);
        if (value == null || value.length() == 0) {
            arguments.add("/ve");
        } else {
            arguments.add("/v");
            arguments.add(value);
        }
        p = Runtime.getRuntime().exec(arguments.toArray(new String[arguments.size()]));
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                int lastTab;
                if (!line.equals(key)) continue;
                line = reader.readLine();
                if (line != null && (lastTab = line.lastIndexOf(9)) != -1) {
                    result = line.substring(lastTab + 1);
                }
                break;
            }
        }
        catch (IOException e) {
            if (Trace.error) {
                e.printStackTrace();
            }
        }
        finally {
            if (p != null) {
                p.destroy();
                p = null;
            }
        }
        return result;
    }
}

