/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugTarget;

public abstract class AuthDebugElement {
    protected AuthDebugTarget fTarget;
    protected int fStateCount;

    public AuthDebugElement(AuthDebugTarget target) {
        this.fStateCount = target != null ? target.getStateCount() : 0;
    }

    protected AuthDebugException newAuthDebugException(String message, Throwable e) {
        return new AuthDebugException(message, e);
    }

    public AuthDebugTarget getAuthDebugTarget() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget();
    }

    protected Object getLock() {
        return this.getAuthDebugTarget().getLock();
    }

    protected boolean isStateSynchronized() {
        int sessionStateCount = this.getAuthDebugTarget().getStateCount();
        return this.fStateCount == sessionStateCount;
    }

    protected void synchronizeState() {
        int sessionStateCount;
        this.fStateCount = sessionStateCount = this.getAuthDebugTarget().getStateCount();
    }
}

