/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthDebugTarget;
import com.adobe.authoring.debug.model.AuthMemberVariable;
import com.adobe.authoring.debug.model.AuthScopeChainVariable;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthValue;
import com.adobe.authoring.debug.model.IAuthVariable;
import com.adobe.authoring.debug.model.Messages;
import com.adobe.authoring.debug.model.ScopeChainVariable;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Variable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class AuthValue
extends AuthDebugElement
implements IAuthValue {
    public static final String OBJECT_ADDRESS_PREFIX = "@";
    private static final IAuthVariable[] EMPTY_VARIABLE_ARRAY;
    private AuthVariable fAuthVariable;
    private Variable fUnderlyingVariable;
    private AuthVariableMembers fMembers;
    private String fValueAsString;
    private int fType;
    private String fQualifiedTypeName;
    private String fShortTypeName;
    private int fAttributes;
    private String fXmlNodeKind;
    private String fXmlValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthValue(AuthDebugTarget target, AuthVariable variable, Variable underlyingVariable) throws DebugElementNoLongerExistsException {
        super(target);
        this.fAuthVariable = variable;
        this.fUnderlyingVariable = underlyingVariable;
        this.fMembers = new AuthVariableMembers();
        this.init();
    }

    public String getReferenceTypeName() {
        this.init();
        return this.fQualifiedTypeName;
    }

    public String getValueString() {
        this.init();
        return this.fValueAsString;
    }

    public int getUnderlyingID() {
        this.init();
        return this.fUnderlyingVariable.getValue().getId();
    }

    public String getDisplayValue(boolean forRoundTripEditing, boolean displayQualifiedTypeNames, boolean displayHex, boolean isScopeChainEntry) {
        this.init();
        if (this.isException() && forRoundTripEditing) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        switch (this.fType) {
            case 2: {
                if (this.isException()) {
                    sb.append(MessageFormat.format("<{0}>", Messages.getString("AuthValue.messageToRightOfEqualsInVariablesView")));
                } else {
                    sb.append('\"');
                    if (forRoundTripEditing) {
                        int pos = 0;
                        char[] charArray = this.fValueAsString.toCharArray();
                        while (pos < this.fValueAsString.length()) {
                            int nextQuote = this.fValueAsString.indexOf("\"", pos);
                            int length = nextQuote == -1 ? this.fValueAsString.length() - pos : nextQuote - pos;
                            sb.append(charArray, pos, length);
                            pos += length;
                            if (nextQuote == -1) continue;
                            sb.append("\\\"");
                            ++pos;
                        }
                    } else {
                        sb.append(this.fValueAsString);
                    }
                    sb.append('\"');
                }
                return sb.toString();
            }
            case 3: {
                if (this.isXml()) {
                    sb.append(this.getXmlText());
                } else {
                    String name = displayQualifiedTypeNames ? this.fQualifiedTypeName : this.fShortTypeName;
                    ScopeChainEntryType scopeChainEntryType = null;
                    if (isScopeChainEntry) {
                        scopeChainEntryType = this.getScopeChainEntryType();
                        if (name.endsWith("$")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        if (scopeChainEntryType == ScopeChainEntryType.LOCALS_OF_FUNCTION) {
                            name = AuthValue.demangleFunctionName(name);
                        }
                    }
                    sb.append(name);
                    boolean showObjectAddress = isScopeChainEntry ? this.getScopeChainEntryType() == ScopeChainEntryType.MEMBERS_OF_OBJECT : true;
                    if (showObjectAddress) {
                        sb.append(" (@");
                        sb.append(Integer.toHexString(this.fUnderlyingVariable.getValue().getId()));
                        sb.append(")");
                    }
                }
                return sb.toString();
            }
            case 0: {
                sb.append(this.fValueAsString);
                if (displayHex) {
                    try {
                        long l = Long.parseLong(this.fValueAsString);
                        if (l < 0L || l >= 10L) {
                            sb.append(" [0x");
                            if (l >= Integer.MIN_VALUE && l < 0L) {
                                sb.append(Integer.toHexString((int)l));
                            } else {
                                sb.append(Long.toHexString(l));
                            }
                            sb.append("]");
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                return sb.toString();
            }
        }
        return this.fValueAsString;
    }

    public boolean isXml() {
        this.init();
        return this.fXmlNodeKind != null && this.fXmlValue != null;
    }

    public String getXmlText() {
        this.init();
        if (this.isXml()) {
            boolean needsQuotes;
            StringBuffer sb = new StringBuffer();
            boolean isRegularText = this.fXmlNodeKind.equals("text") && !this.fXmlValue.startsWith("<![CDATA[");
            boolean isAttribute = this.fXmlNodeKind.equals("attribute");
            boolean bl = needsQuotes = isRegularText || isAttribute;
            if (needsQuotes) {
                sb.append('\"');
            }
            sb.append(this.fXmlValue);
            if (needsQuotes) {
                sb.append('\"');
            }
            return sb.toString();
        }
        return null;
    }

    public static String demangleFunctionName(String functionName) {
        String INSTANCE_CTOR = "$iinit";
        String STATIC_CTOR = "$cinit";
        if (functionName.endsWith("$iinit")) {
            int lastDot = functionName.lastIndexOf(46);
            String qualifier = functionName.substring(0, lastDot + 1);
            if (lastDot == -1) {
                ++lastDot;
            }
            String className = functionName.substring(lastDot, functionName.length() - "$iinit".length());
            functionName = qualifier + className + '.' + className;
        } else if (!functionName.endsWith("$cinit")) {
            if (functionName.length() == 0) {
                functionName = Messages.getString("AuthValue.anonymousFunctionInScopeChain");
            } else {
                int slash = functionName.indexOf(47);
                if (slash != -1) {
                    String className = functionName.substring(0, slash);
                    int lastDot = -1;
                    for (int i = functionName.length() - 1; i > slash; --i) {
                        if (functionName.charAt(i) != '.') continue;
                        lastDot = i;
                        break;
                    }
                    String newFunctionName = lastDot == -1 ? functionName.substring(slash + 1) : functionName.substring(lastDot + 1);
                    functionName = className + "." + newFunctionName;
                }
            }
        }
        return functionName + "()";
    }

    public IAuthVariable[] getVariables() {
        return this.fMembers.getMembers();
    }

    public boolean hasVariables() {
        switch (this.getFlashVariableType()) {
            case 3: {
                if (this.fXmlNodeKind != null) {
                    if (this.fXmlNodeKind.equals("element")) {
                        String expr = this.getXmlText();
                        return !expr.endsWith("/>");
                    }
                    return false;
                }
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public int getFlashVariableType() {
        this.init();
        return this.fType;
    }

    public boolean isScalar() {
        this.init();
        switch (this.fType) {
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    public boolean isException() {
        return (this.getAttributes() & 0x40000) != 0;
    }

    public int getAttributes() {
        this.init();
        return this.fAttributes;
    }

    public boolean needsToInvokeGetter() {
        return this.fUnderlyingVariable.needsToInvokeGetter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeGetter() throws DebugElementNoLongerExistsException {
        boolean invokedGetter = false;
        Object object = this.getLock();
        synchronized (object) {
            try {
                if (this.fUnderlyingVariable.needsToInvokeGetter()) {
                    this.fUnderlyingVariable.invokeGetter(this.getAuthDebugTarget().getSession());
                    this.reinit();
                    invokedGetter = true;
                }
            }
            catch (NotSuspendedException e) {
                throw new DebugElementNoLongerExistsException(1);
            }
            catch (NotConnectedException e) {
                throw new DebugElementNoLongerExistsException(1);
            }
            catch (NoResponseException e) {
                AuthDebugMgr.log(e);
                throw new DebugElementNoLongerExistsException(1);
            }
        }
        if (!invokedGetter || this.fAuthVariable.getParentFrame() != null) {
            // empty if block
        }
    }

    public ScopeChainEntryType getScopeChainEntryType() {
        this.init();
        int attributes = this.getAttributes();
        if ((attributes & 0x4000000) != 0) {
            return ScopeChainEntryType.STATICS_OF_CLASS;
        }
        String valueString = this.getValueString();
        if (valueString.indexOf(47) != -1 || valueString.indexOf("$cinit") != -1 || valueString.indexOf("$iinit") != -1 || valueString.indexOf("$init") != -1 || valueString.startsWith(" (@")) {
            return ScopeChainEntryType.LOCALS_OF_FUNCTION;
        }
        return ScopeChainEntryType.MEMBERS_OF_OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        Object object = this.getLock();
        synchronized (object) {
            this.fValueAsString = null;
            this.init();
            this.fMembers.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fValueAsString == null) {
                Variable variable = this.fUnderlyingVariable;
                this.fType = variable.getValue().getType();
                String className = variable.getValue().getClassName();
                this.fAttributes = variable.getValue().getAttributes();
                String typeName = variable.getValue().getTypeName();
                if (typeName != null && typeName.length() == 0) {
                    typeName = null;
                }
                StringBuffer sb = new StringBuffer();
                switch (this.fType) {
                    case 0: {
                        double d;
                        this.fQualifiedTypeName = "Number";
                        String s = variable.getValue().getValueAsString();
                        if (s.endsWith(".0")) {
                            s = s.substring(0, s.length() - 2);
                        } else if (s.indexOf("E") >= 0 && (d = Double.parseDouble(s)) == Math.floor(d)) {
                            long l = (long)d;
                            s = Long.toString(l);
                        }
                        sb.append(s);
                        break;
                    }
                    case 1: {
                        this.fQualifiedTypeName = "Boolean";
                        Boolean b = (Boolean)variable.getValue().getValue();
                        if (b.booleanValue()) {
                            sb.append("true");
                            break;
                        }
                        sb.append("false");
                        break;
                    }
                    case 2: {
                        this.fQualifiedTypeName = "String";
                        sb.append(variable.getValue().getValueAsString());
                        break;
                    }
                    case 3: {
                        this.fQualifiedTypeName = "Object";
                        boolean displayedAsXml = false;
                        if (!(variable instanceof ScopeChainVariable)) {
                            if (className.equals("Object")) {
                                int at = typeName.indexOf(64);
                                if (at != -1) {
                                    int secondSpace;
                                    int firstSpace;
                                    this.fQualifiedTypeName = typeName.substring(0, at);
                                    int doubleColon = this.fQualifiedTypeName.indexOf("::");
                                    if (doubleColon >= 0) {
                                        this.fShortTypeName = this.fQualifiedTypeName.substring(doubleColon + 2);
                                        this.fQualifiedTypeName = this.fQualifiedTypeName.substring(0, doubleColon) + '.' + this.fShortTypeName;
                                    } else {
                                        this.fShortTypeName = this.fQualifiedTypeName;
                                    }
                                    if (this.fQualifiedTypeName.equals("XML") && (firstSpace = typeName.indexOf(32, at)) != -1 && (secondSpace = typeName.indexOf(32, firstSpace + 1)) != -1) {
                                        this.fXmlNodeKind = typeName.substring(firstSpace + 1, secondSpace);
                                        this.fXmlValue = typeName.substring(secondSpace + 1);
                                        sb.append(this.fXmlValue);
                                        displayedAsXml = true;
                                    }
                                    if (!displayedAsXml) {
                                        sb.append(this.fQualifiedTypeName);
                                    }
                                } else {
                                    sb.append(typeName);
                                }
                            } else {
                                this.fQualifiedTypeName = className;
                                sb.append(className);
                                sb.append(" ");
                                sb.append(variable.getValue().getValue());
                                if (typeName != null && !typeName.equals(className)) {
                                    sb.append(MessageFormat.format(Messages.getString("AuthValue.appendClassnameToObject"), typeName));
                                }
                            }
                        }
                        if (displayedAsXml || variable instanceof ScopeChainVariable) break;
                        sb.append(" (@");
                        sb.append(Integer.toHexString(variable.getValue().getId()));
                        sb.append(")");
                        break;
                    }
                    case 4: {
                        if (variable.isAttributeSet(524288)) {
                            this.fQualifiedTypeName = Messages.getString("AuthValue.getter");
                            sb.append(Messages.getString("AuthValue.getter"));
                            break;
                        }
                        if (variable.isAttributeSet(0x100000)) {
                            this.fQualifiedTypeName = Messages.getString("AuthValue.setter");
                            sb.append(Messages.getString("AuthValue.setter"));
                            break;
                        }
                        this.fQualifiedTypeName = Messages.getString("AuthValue.function");
                        sb.append(Messages.getString("AuthValue.function"));
                        sb.append(" (@");
                        sb.append(Integer.toHexString(variable.getValue().getId()));
                        sb.append(")");
                        break;
                    }
                    case 5: {
                        this.fQualifiedTypeName = "MovieClip";
                        sb.append(className);
                        sb.append(" ");
                        sb.append(variable.getValue().getValue());
                        if (typeName == null || typeName.equals(className)) break;
                        sb.append(MessageFormat.format(Messages.getString("AuthValue.appendMovieClipName"), typeName));
                        break;
                    }
                    case 6: {
                        this.fQualifiedTypeName = "";
                        sb.append("null");
                        break;
                    }
                    case 7: {
                        this.fQualifiedTypeName = "";
                        sb.append("undefined");
                        break;
                    }
                    case 8: {
                        this.fQualifiedTypeName = "";
                        sb.append(Messages.getString("AuthValue.unknownVariableType"));
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("Unknown VariableType " + this.fType));
                        }
                        break;
                    }
                }
                if (this.fShortTypeName == null) {
                    this.fShortTypeName = this.fQualifiedTypeName;
                }
                this.fValueAsString = sb.toString();
            }
        }
    }

    public String getXmlNodeKind() {
        return this.fXmlNodeKind;
    }

    static {
        $assertionsDisabled = !AuthValue.class.desiredAssertionStatus();
        EMPTY_VARIABLE_ARRAY = new AuthVariable[0];
    }

    private class AuthVariableMembers {
        private IAuthVariable[] fLazyMembers;

        private AuthVariableMembers() {
        }

        public IAuthVariable[] getMembers() {
            this.init();
            return this.fLazyMembers;
        }

        public void reinit() {
            this.fLazyMembers = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Object object = AuthValue.this.getLock();
            synchronized (object) {
                if (this.fLazyMembers == null) {
                    try {
                        Variable[] members = null;
                        try {
                            members = AuthValue.this.fAuthVariable.getFlashVariable().getValue().getMembers(AuthValue.this.getAuthDebugTarget().getSession());
                        }
                        catch (NotSuspendedException e) {
                            throw new DebugElementNoLongerExistsException(1);
                        }
                        catch (NotConnectedException e) {
                            throw new DebugElementNoLongerExistsException(1);
                        }
                        catch (NoResponseException e) {
                            AuthDebugMgr.log(e);
                            throw new DebugElementNoLongerExistsException(1);
                        }
                        ArrayList<AuthMemberVariable> lazyMembers = new ArrayList<AuthMemberVariable>(members.length);
                        boolean parentIsScopeChainEntry = AuthValue.this.fAuthVariable.isScopeChainMember();
                        for (int i = 0; i < members.length; ++i) {
                            boolean acceptMember = true;
                            if (parentIsScopeChainEntry) {
                                if (members[i].isAttributeSet(0x200000)) {
                                    acceptMember = false;
                                } else if (members[i].getQualifiedName().equals("prototype")) {
                                    acceptMember = false;
                                }
                            }
                            if (!acceptMember) continue;
                            AuthMemberVariable member = new AuthMemberVariable(AuthValue.this.getAuthDebugTarget(), AuthValue.this.fAuthVariable, members[i], members[i].getName());
                            if (AuthValue.this.fAuthVariable instanceof AuthScopeChainVariable) {
                                member.setScopeChainMember(true);
                            }
                            lazyMembers.add(member);
                        }
                        this.fLazyMembers = lazyMembers.toArray(new IAuthVariable[0]);
                        Arrays.sort(this.fLazyMembers);
                    }
                    catch (DebugElementNoLongerExistsException e) {
                        this.fLazyMembers = EMPTY_VARIABLE_ARRAY;
                    }
                }
            }
        }
    }

    public static class ScopeChainEntryType {
        public static ScopeChainEntryType LOCALS_OF_FUNCTION = new ScopeChainEntryType();
        public static ScopeChainEntryType MEMBERS_OF_OBJECT = new ScopeChainEntryType();
        public static ScopeChainEntryType STATICS_OF_CLASS = new ScopeChainEntryType();

        private ScopeChainEntryType() {
        }
    }
}

