/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.util.Trace;
import java.io.UnsupportedEncodingException;

public class DMessage {
    public static final int InUnknown = -1;
    public static final int InSetMenuState = 0;
    public static final int InSetProperty = 1;
    public static final int InExit = 2;
    public static final int InNewObject = 3;
    public static final int InRemoveObject = 4;
    public static final int InTrace = 5;
    public static final int InErrorTarget = 6;
    public static final int InErrorExecLimit = 7;
    public static final int InErrorWith = 8;
    public static final int InErrorProtoLimit = 9;
    public static final int InSetVariable = 10;
    public static final int InDeleteVariable = 11;
    public static final int InParam = 12;
    public static final int InPlaceObject = 13;
    public static final int InScript = 14;
    public static final int InAskBreakpoints = 15;
    public static final int InBreakAt = 16;
    public static final int InContinue = 17;
    public static final int InSetLocalVariables = 18;
    public static final int InSetBreakpoint = 19;
    public static final int InNumScript = 20;
    public static final int InRemoveScript = 21;
    public static final int InRemoveBreakpoint = 22;
    public static final int InNotSynced = 23;
    public static final int InErrorURLOpen = 24;
    public static final int InProcessTag = 25;
    public static final int InVersion = 26;
    public static final int InBreakAtExt = 27;
    public static final int InSetVariable2 = 28;
    public static final int InSquelch = 29;
    public static final int InGetVariable = 30;
    public static final int InFrame = 31;
    public static final int InOption = 32;
    public static final int InWatch = 33;
    public static final int InGetSwf = 34;
    public static final int InGetSwd = 35;
    public static final int InErrorException = 36;
    public static final int InErrorStackUnderflow = 37;
    public static final int InErrorZeroDivide = 38;
    public static final int InErrorScriptStuck = 39;
    public static final int InBreakReason = 40;
    public static final int InGetActions = 41;
    public static final int InSwfInfo = 42;
    public static final int InConstantPool = 43;
    public static final int InErrorConsole = 44;
    public static final int InGetFncNames = 45;
    public static final int InWatch2 = 55;
    public static final int InSIZE = 56;
    public static final int OutUnknown = -2;
    public static final int OutZoomIn = 0;
    public static final int OutZoomOut = 1;
    public static final int OutZoom100 = 2;
    public static final int OutHome = 3;
    public static final int OutSetQuality = 4;
    public static final int OutPlay = 5;
    public static final int OutLoop = 6;
    public static final int OutRewind = 7;
    public static final int OutForward = 8;
    public static final int OutBack = 9;
    public static final int OutPrint = 10;
    public static final int OutSetVariable = 11;
    public static final int OutSetProperty = 12;
    public static final int OutExit = 13;
    public static final int OutSetFocus = 14;
    public static final int OutContinue = 15;
    public static final int OutStopDebug = 16;
    public static final int OutSetBreakpoints = 17;
    public static final int OutRemoveBreakpoints = 18;
    public static final int OutRemoveAllBreakpoints = 19;
    public static final int OutStepOver = 20;
    public static final int OutStepInto = 21;
    public static final int OutStepOut = 22;
    public static final int OutProcessedTag = 23;
    public static final int OutSetSquelch = 24;
    public static final int OutGetVariable = 25;
    public static final int OutGetFrame = 26;
    public static final int OutGetOption = 27;
    public static final int OutSetOption = 28;
    public static final int OutAddWatch = 29;
    public static final int OutRemoveWatch = 30;
    public static final int OutStepContinue = 31;
    public static final int OutGetSwf = 32;
    public static final int OutGetSwd = 33;
    public static final int OutGetVariableWhichInvokesGetter = 34;
    public static final int OutGetBreakReason = 35;
    public static final int OutGetActions = 36;
    public static final int OutSetActions = 37;
    public static final int OutSwfInfo = 38;
    public static final int OutConstantPool = 39;
    public static final int OutGetFncNames = 40;
    public static final int OutAddWatch2 = 49;
    public static final int OutRemoveWatch2 = 50;
    public static final int OutSIZE = 41;
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    public static final int kNamespaceType = 18;
    byte[] m_content;
    int m_index;
    int m_type;

    public DMessage(int size) {
        this.m_content = new byte[size];
        this.clear();
    }

    public int getType() {
        return this.m_type;
    }

    public String getInTypeName() {
        return DMessage.inTypeName(this.getType());
    }

    public String getOutTypeName() {
        return DMessage.outTypeName(this.getType());
    }

    public byte[] getData() {
        return this.m_content;
    }

    public int getSize() {
        return this.m_content == null ? 0 : this.m_content.length;
    }

    public int getRemaining() {
        return this.getSize() - this.m_index;
    }

    public int getPosition() {
        return this.m_index;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    public void reset() {
        this.m_index = 0;
    }

    public void clear() {
        this.setType(-1);
        this.reset();
    }

    public int getByte() throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 1 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 1");
        }
        byte value = this.m_content[this.m_index++];
        return value;
    }

    public int getWord() throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 2 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 2");
        }
        byte b0 = this.m_content[this.m_index++];
        byte b1 = this.m_content[this.m_index++];
        int value = b1 << 8 & 0xFF00 | b0 & 0xFF;
        return value;
    }

    public long getDWord() throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 4 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 4");
        }
        byte b0 = this.m_content[this.m_index++];
        byte b1 = this.m_content[this.m_index++];
        byte b2 = this.m_content[this.m_index++];
        byte b3 = this.m_content[this.m_index++];
        long value = b3 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b1 << 8 & 0xFF00 | b0 & 0xFF;
        return value;
    }

    public String getString() throws ArrayIndexOutOfBoundsException {
        String s;
        int startAt = this.m_index;
        boolean done = false;
        while (!done) {
            byte ch;
            if ((ch = this.m_content[this.m_index++]) == 0) {
                done = true;
                continue;
            }
            if (this.m_index <= this.m_content.length) continue;
            throw new ArrayIndexOutOfBoundsException("no string terminator found @" + this.m_index);
        }
        try {
            s = new String(this.m_content, startAt, this.m_index - startAt - 1, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            s = new String(this.m_content, startAt, this.m_index - startAt - 1);
        }
        return s;
    }

    public void putByte(byte b0) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 1 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 1");
        }
        this.m_content[this.m_index++] = b0;
    }

    public void putWord(int val) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 2 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 2");
        }
        this.m_content[this.m_index++] = (byte)val;
        this.m_content[this.m_index++] = (byte)(val >> 8);
    }

    public void putDWord(long val) throws ArrayIndexOutOfBoundsException {
        if (this.m_index + 4 > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(this.m_content.length - this.m_index + " < 4");
        }
        this.m_content[this.m_index++] = (byte)val;
        this.m_content[this.m_index++] = (byte)(val >> 8);
        this.m_content[this.m_index++] = (byte)(val >> 16);
        this.m_content[this.m_index++] = (byte)(val >> 24);
    }

    public static int getStringLength(String s) {
        try {
            return s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            if (Trace.error) {
                Trace.trace(e.toString());
            }
            return 0;
        }
    }

    public void putString(String s) throws ArrayIndexOutOfBoundsException, UnsupportedEncodingException {
        byte[] bytes = s.getBytes("UTF-8");
        int length = bytes.length;
        int endAt = this.m_index + length + 1;
        if (endAt > this.m_content.length) {
            throw new ArrayIndexOutOfBoundsException(endAt + " > " + this.m_content.length);
        }
        System.arraycopy(bytes, 0, this.m_content, this.m_index, length);
        this.m_index += length;
        this.m_content[this.m_index++] = 0;
    }

    public String inToString() {
        return this.inToString(16);
    }

    public String inToString(int maxContentBytes) {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public String outToString() {
        return this.outToString(16);
    }

    public String outToString(int maxContentBytes) {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public static String inTypeName(int type) {
        String s = "InUnknown(" + type + ")";
        return s;
    }

    public static String outTypeName(int type) {
        String s = "OutUnknown(" + type + ")";
        return s;
    }
}

