/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.ApolloLaunchInfo;
import flash.tools.debugger.Frame;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DManager;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.FaultEvent;
import flash.util.Trace;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlayerSession
implements Session,
DProtocolNotifierIF,
Runnable {
    public static final int MAX_STACK_DEPTH = 256;
    private Socket m_socket;
    private DProtocol m_protocol;
    private DManager m_manager;
    private Process m_process;
    private Map m_prefs;
    private String m_newline = System.getProperty("line.separator");
    private volatile boolean m_isConnected = false;
    private volatile boolean m_isHalted = false;
    private volatile boolean m_incoming;
    private volatile boolean m_lastResponse;
    private int m_watchTransactionTag;
    private String m_launchUrl;
    private ApolloLaunchInfo m_apolloLaunchInfo;
    static volatile boolean m_debugMsgOn;
    volatile int m_debugMsgSize;
    static volatile boolean m_debugMsgFileOn;
    volatile int m_debugMsgFileSize;
    Writer m_trace;

    PlayerSession(Socket s, DProtocol proto, DManager manager) {
        this.m_socket = s;
        this.m_protocol = proto;
        this.m_manager = manager;
        this.m_prefs = Collections.synchronizedMap(new HashMap());
        this.m_incoming = false;
        m_debugMsgOn = false;
        this.m_debugMsgSize = 16;
        m_debugMsgFileOn = false;
        this.m_debugMsgFileSize = 128;
        this.m_watchTransactionTag = 1;
    }

    public static PlayerSession createFromSocket(Socket s) throws IOException {
        DProtocol proto = DProtocol.createFromSocket(s);
        DManager manager = new DManager();
        manager.attach(proto);
        PlayerSession session = new PlayerSession(s, proto, manager);
        return session;
    }

    public DMessageCounter getMessageCounter() {
        return this.m_protocol.getMessageCounter();
    }

    public String getURI() {
        return this.m_manager.getURI();
    }

    public boolean playerSupportsGet() {
        return this.m_manager.isGetSupported();
    }

    public int playerVersion() {
        return this.m_manager.getVersion();
    }

    public SourceLocator getSourceLocator() {
        return this.m_manager.getSourceLocator();
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_manager.setSourceLocator(sourceLocator);
    }

    void setProcess(Process proc) {
        this.m_process = proc;
    }

    public Process getLaunchProcess() {
        return this.m_process;
    }

    public void setPreferences(Map map) {
        this.m_prefs.putAll(map);
        this.mapBack();
    }

    public Set keySet() {
        return this.m_prefs.keySet();
    }

    public Object getPreferenceAsObject(String pref) {
        return this.m_prefs.get(pref);
    }

    public void setPreference(String pref, int value) {
        this.m_prefs.put(pref, new Integer(value));
        this.mapBack();
        if (pref.equals("$console_errors")) {
            this.sendConsoleErrorsAsTrace(value == 1);
        }
        if (pref.startsWith("$flash_")) {
            this.sendOptionMessage(pref.substring(7), Integer.toString(value));
        }
    }

    private int mapBackOnePreference(String preferenceName, int defaultValue) {
        Object prefValue = this.getPreferenceAsObject(preferenceName);
        if (prefValue != null) {
            return (Integer)prefValue;
        }
        return defaultValue;
    }

    private boolean mapBackOnePreference(String preferenceName, boolean defaultValue) {
        Object prefValue = this.getPreferenceAsObject(preferenceName);
        if (prefValue != null) {
            return (Integer)prefValue != 0;
        }
        return defaultValue;
    }

    private void mapBack() {
        m_debugMsgOn = this.mapBackOnePreference("$debug_messages", m_debugMsgOn);
        this.m_debugMsgSize = this.mapBackOnePreference("$debug_message_size", this.m_debugMsgSize);
        m_debugMsgFileOn = this.mapBackOnePreference("$debug_message_file", m_debugMsgFileOn);
        this.m_debugMsgFileSize = this.mapBackOnePreference("$debug_message_file_size", this.m_debugMsgFileSize);
    }

    public int getPreference(String pref) {
        int val = 0;
        Integer i = (Integer)this.m_prefs.get(pref);
        if (i == null) {
            throw new NullPointerException();
        }
        val = i;
        return val;
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public boolean isSuspended() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.m_isHalted;
    }

    public boolean bind() throws VersionException {
        boolean bound = false;
        this.m_isConnected = true;
        this.m_protocol.addListener(this);
        bound = this.m_protocol.bind();
        this.sendStopWarning();
        this.sendStopOnFault();
        this.sendEnumerateOverride();
        this.sendFailureNotify();
        this.sendInvokeSetters();
        this.sendSwfloadNotify();
        this.sendGetterTimeout();
        this.sendSetterTimeout();
        boolean responded = this.sendSquelch(true);
        this.setPreference("$playersupportsget", this.playerSupportsGet() ? 1 : 0);
        Thread t = new Thread((Runnable)this, "SWF/SWD reader");
        t.setDaemon(true);
        t.start();
        if (!responded) {
            throw new VersionException();
        }
        return bound;
    }

    public void unbind() {
        this.sendMessage(13);
        this.m_manager.release(this.m_protocol);
        this.m_protocol.unbind();
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_isConnected = false;
        this.m_isHalted = false;
    }

    private String executeAppleScript(String[] appleScript, String[] argv) {
        StringBuffer retval = new StringBuffer();
        try {
            int ch;
            LinkedList<String> execArgs = new LinkedList<String>();
            execArgs.add("/usr/bin/osascript");
            execArgs.add("-");
            if (argv != null) {
                for (int i = 0; i < argv.length; ++i) {
                    execArgs.add(argv[i]);
                }
            }
            Process osascript = Runtime.getRuntime().exec(execArgs.toArray(new String[execArgs.size()]));
            OutputStream outputStream = osascript.getOutputStream();
            PrintWriter writer = new PrintWriter(outputStream, true);
            writer.println("on run argv");
            for (int i = 0; i < appleScript.length; ++i) {
                writer.println(appleScript[i]);
            }
            writer.println("end run");
            writer.close();
            InputStreamReader reader = new InputStreamReader(osascript.getInputStream());
            while ((ch = reader.read()) != -1) {
                retval.append((char)ch);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return retval.toString().replaceAll("\n$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAppleScript(String appleScriptFilename, String[] argv) throws IOException {
        InputStream stm = null;
        try {
            String line;
            stm = PlayerSession.class.getResourceAsStream(appleScriptFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stm));
            ArrayList<String> appleScriptLines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                appleScriptLines.add(line);
            }
            String[] lines = appleScriptLines.toArray(new String[appleScriptLines.size()]);
            String string = this.executeAppleScript(lines, argv);
            return string;
        }
        finally {
            if (stm != null) {
                stm.close();
            }
        }
    }

    private Set runningApplications() {
        String running = this.executeAppleScript(new String[]{"tell application \"System Events\"", "\tname of processes", "end tell"}, null);
        String[] apps = running.split(", ");
        HashSet<String> retval = new HashSet<String>();
        for (int i = 0; i < apps.length; ++i) {
            retval.add(apps[i]);
        }
        return retval;
    }

    public void terminate() {
        try {
            this.unbind();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            Runnable r = new Runnable(){

                public void run() {
                    if (PlayerSession.this.m_apolloLaunchInfo == null && PlayerSession.this.m_launchUrl != null && PlayerSession.this.m_launchUrl.length() > 0) {
                        boolean closedAnyWindows = false;
                        Set runningApps = PlayerSession.this.runningApplications();
                        if (!closedAnyWindows && runningApps.contains("Safari")) {
                            try {
                                String safariClosedAnyWindows = PlayerSession.this.executeAppleScript("appleScriptCloseSafariWindow.txt", new String[]{PlayerSession.this.m_launchUrl});
                                if ("true".equals(safariClosedAnyWindows)) {
                                    closedAnyWindows = true;
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (!closedAnyWindows && runningApps.contains("Camino")) {
                            String url = PlayerSession.this.m_launchUrl.replaceFirst("^file:///", "file://localhost/");
                            try {
                                String caminoClosedAnyWindows = PlayerSession.this.executeAppleScript("appleScriptCloseCaminoWindow.txt", new String[]{url});
                                if ("true".equals(caminoClosedAnyWindows)) {
                                    closedAnyWindows = true;
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        String[] macStandalonePlayerNames = new String[]{"Flash Player", "SAFlashPlayer", "standalone"};
                        for (int i = 0; !closedAnyWindows && i < macStandalonePlayerNames.length; ++i) {
                            if (!runningApps.contains(macStandalonePlayerNames[i])) continue;
                            PlayerSession.this.executeAppleScript(new String[]{"tell application \"" + macStandalonePlayerNames[i] + "\" to quit"}, null);
                            closedAnyWindows = true;
                        }
                    }
                }
            };
            new Thread(r, "Terminate Mac debug target").start();
        }
        if (this.m_process != null) {
            try {
                this.m_process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_protocol = null;
        this.m_socket = null;
        this.m_manager = null;
        this.m_process = null;
        this.m_isConnected = false;
        this.m_isHalted = false;
    }

    public void resume() throws NotSuspendedException, NotConnectedException, NoResponseException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessage(15, 17)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    public void suspend() throws SuspendedException, NotConnectedException, NoResponseException {
        int wait;
        int every = 50;
        if (this.isSuspended()) {
            throw new SuspendedException();
        }
        for (wait = this.getPreference("$suspendwait"); !this.isSuspended() && wait > 0; wait -= every) {
            this.simpleRequestResponseMessage(16, 27, every);
        }
        if (!this.isSuspended()) {
            throw new NoResponseException(wait);
        }
    }

    public DSuspendInfo getSuspendInfo() {
        DSuspendInfo info = this.m_manager.getSuspendInfo();
        if (info == null) {
            if (this.simpleRequestResponseMessage(35, 40)) {
                info = this.m_manager.getSuspendInfo();
            }
            if (info == null) {
                info = new DSuspendInfo();
            }
        }
        return info;
    }

    public int suspendReason() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getReason();
    }

    public int getSuspendOffset() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getOffset();
    }

    public int getSuspendActionIndex() {
        DSuspendInfo info = this.getSuspendInfo();
        return info.getActionIndex();
    }

    public SwfInfo[] getSwfs() throws NoResponseException {
        if (this.m_manager.getSwfInfoCount() == 0) {
            this.requestSwfInfo(0);
        }
        SwfInfo[] swfs = this.m_manager.getSwfInfos();
        return swfs;
    }

    public void requestSwfInfo(int at) throws NoResponseException {
        DMessage dm = DMessageCache.alloc(4);
        dm.setType(38);
        dm.putWord(at);
        dm.putWord(0);
        int to = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, 42, to)) {
            throw new NoResponseException(to);
        }
    }

    public byte[] getActions(int which, int at, int len) throws NoResponseException {
        byte[] actions = null;
        DMessage dm = DMessageCache.alloc(12);
        dm.setType(36);
        dm.putWord(which);
        dm.putWord(0);
        dm.putDWord(at);
        dm.putDWord(len);
        int to = this.getPreference("$contextresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, 41, to)) {
            throw new NoResponseException(to);
        }
        actions = this.m_manager.getActions();
        return actions;
    }

    public void stepInto() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isSuspended()) {
            if (!this.simpleRequestResponseMessage(21, 17)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    public void stepOut() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isSuspended()) {
            if (!this.simpleRequestResponseMessage(22, 17)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    public void stepOver() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.isSuspended()) {
            if (!this.simpleRequestResponseMessage(20, 17)) {
                throw new NoResponseException(this.getPreference("$responsetimeout"));
            }
        } else {
            throw new NotSuspendedException();
        }
    }

    public void stepContinue() throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        if (!this.simpleRequestResponseMessage(31, 17)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
    }

    public void requestFunctionNames(int moduleId, int lineNbr) throws VersionException, NoResponseException {
        if (this.m_manager.getVersion() >= 9) {
            DMessage dm = DMessageCache.alloc(8);
            dm.setType(40);
            dm.putDWord(moduleId);
            dm.putDWord(lineNbr);
            if (!this.simpleRequestResponseMessage(dm, 45)) {
                throw new NoResponseException(0);
            }
        } else {
            throw new VersionException();
        }
    }

    public SourceFile getFile(int fileId) {
        return this.m_manager.getSource(fileId);
    }

    public Location[] getBreakpointList() {
        return this.m_manager.getBreakpoints();
    }

    public Location setBreakpoint(int fileId, int lineNum) throws NoResponseException, NotConnectedException {
        DLocation l = null;
        int bp = DLocation.encodeId(fileId, lineNum);
        DMessage dm = DMessageCache.alloc(8);
        dm.setType(17);
        dm.putDWord(1L);
        dm.putDWord(bp);
        boolean gotResponse = this.simpleRequestResponseMessage(dm, 19);
        if (!gotResponse) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        l = this.m_manager.getBreakpoint(bp);
        return l;
    }

    public Location clearBreakpoint(Location local) {
        int lineNum;
        SourceFile source = local.getFile();
        int fileId = source.getId();
        int bp = DLocation.encodeId(fileId, lineNum = local.getLine());
        DLocation l = this.m_manager.getBreakpoint(bp);
        if (l != null) {
            DMessage dm = DMessageCache.alloc(8);
            dm.setType(18);
            dm.putDWord(1L);
            dm.putDWord(bp);
            this.sendMessage(dm);
            this.m_manager.removeBreakpoint(bp);
        }
        return l;
    }

    public Watch[] getWatchList() throws NoResponseException, NotConnectedException {
        return this.m_manager.getWatchpoints();
    }

    public Watch setWatch(Value v, String memberName, int kind) throws NoResponseException, NotConnectedException {
        DWatch lastWatch;
        int count;
        DWatch w = null;
        int tag = this.m_watchTransactionTag++;
        if (this.addWatch(v.getId(), memberName, kind, tag) && (count = this.m_manager.getWatchpointCount()) > 0 && (lastWatch = this.m_manager.getWatchpoint(count - 1)).getTag() == tag) {
            w = lastWatch;
        }
        return w;
    }

    public Watch clearWatch(Watch watch) throws NoResponseException, NotConnectedException {
        Watch[] list = this.getWatchList();
        Watch w = null;
        if (this.removeWatch(watch.getValueId(), watch.getMemberName()) && this.m_manager.getWatchpointCount() < list.length) {
            Watch[] newList = this.getWatchList();
            for (int i = 0; i < newList.length; ++i) {
                if (list[i] == newList[i]) continue;
                w = list[i];
                break;
            }
            if (w == null) {
                w = list[list.length - 1];
            }
        }
        return w;
    }

    public Variable[] getVariableList() throws NotSuspendedException, NoResponseException, NotConnectedException, VersionException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        this.requestFrame(0);
        this.getValue(-2);
        this.getValue(-3);
        this.getValue(-4);
        int i = 0;
        Value v = null;
        do {
            v = this.getValue(-300 - i);
        } while (i++ < 128 && v != null);
        v = this.m_manager.getValue(-100L);
        if (v == null) {
            throw new VersionException();
        }
        return v.getMembers(this);
    }

    public Frame[] getFrames() throws NotConnectedException {
        return this.m_manager.getFrames();
    }

    public void requestFrame(int depth) throws NotSuspendedException, NoResponseException, NotConnectedException {
        if (this.playerSupportsGet()) {
            if (!this.isSuspended()) {
                throw new NotSuspendedException();
            }
            int timeout = this.getPreference("$contextresponsetimeout");
            DMessage dm = DMessageCache.alloc(4);
            dm.setType(26);
            dm.putDWord(depth);
            if (!this.simpleRequestResponseMessage(dm, 31, timeout)) {
                throw new NoResponseException(timeout);
            }
            this.pullUpActivationObjectVariables(depth);
        }
    }

    private void pullUpActivationObjectVariables(int depth) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int i;
        DValue frame = this.m_manager.getValue(-100 - depth);
        DStackContext context = this.m_manager.getFrame(depth);
        DVariable[] frameVars = (DVariable[])frame.getMembers(this);
        LinkedHashMap<String, DVariable> varmap = new LinkedHashMap<String, DVariable>(frameVars.length);
        ArrayList<DVariable> activationObjects = new ArrayList<DVariable>();
        Pattern activationObjectNamePattern = Pattern.compile("^.*\\$\\d+$");
        for (i = 0; i < frameVars.length; ++i) {
            DVariable member = frameVars[i];
            Matcher matcher = activationObjectNamePattern.matcher(member.getName());
            if (matcher.matches()) {
                activationObjects.add(member);
                continue;
            }
            varmap.put(member.getName(), member);
        }
        if (activationObjects.size() == 0) {
            return;
        }
        for (i = 0; i < activationObjects.size(); ++i) {
            DVariable activationObject = (DVariable)activationObjects.get(i);
            DVariable[] activationMembers = (DVariable[])activationObject.getValue().getMembers(this);
            for (int j = 0; j < activationMembers.length; ++j) {
                DVariable member = activationMembers[j];
                int attributes = member.getAttributes();
                if ((attributes & 0x200000) != 0) continue;
                attributes &= 0xFC7FFFFF;
                member.setAttributes(attributes |= 0);
                String name = member.getName();
                DVariable oldvar = (DVariable)varmap.get(name);
                int vartype = oldvar != null ? oldvar.getAttributes() & 0x10020 : 32;
                member.setAttributes(member.getAttributes() | vartype);
                varmap.put(name, member);
            }
            context.convertLocalToActivationObject(activationObject);
        }
        Iterator iter = varmap.values().iterator();
        while (iter.hasNext()) {
            DVariable next = (DVariable)iter.next();
            frame.addMember(next);
            if (next.isAttributeSet(32)) {
                context.addLocal(next);
                continue;
            }
            if (!next.isAttributeSet(65536)) continue;
            if (next.getName().equals("this")) {
                context.setThis(next);
                continue;
            }
            context.addArgument(next);
        }
    }

    public Value getValue(int valueId) throws NotSuspendedException, NoResponseException, NotConnectedException {
        DValue val = null;
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        val = this.m_manager.getValue(valueId);
        if (val == null) {
            if (valueId < -1) {
                this.requestFrame(0);
            } else if (valueId > -1) {
                this.requestVariable(valueId, null);
            }
            val = this.m_manager.getValue(valueId);
        }
        return val;
    }

    void obtainMembers(int valueId) throws NoResponseException, NotConnectedException, NotSuspendedException {
        DValue v = this.m_manager.getValue(valueId);
        if (!v.membersObtained()) {
            this.requestVariable(valueId, null, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(int varId, String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Value v = null;
        if (this.isSuspended()) {
            int fireGetter = this.getPreference("$invokegetters");
            this.m_manager.clearLastVariable();
            this.m_manager.enableChildAttach(false);
            try {
                this.requestVariable(varId, name, fireGetter != 0, false);
                v = this.m_manager.lastVariable().getValue();
            }
            catch (NoResponseException e) {
                if (fireGetter != 0) {
                    v = new DValue(2, "String", "String", 262144, e.getLocalizedMessage());
                    DVariable var = new DVariable(name, (DValue)v);
                    this.m_manager.enableChildAttach(true);
                    this.m_manager.addVariableMember(varId, var);
                }
                throw e;
            }
            finally {
                this.m_manager.enableChildAttach(true);
            }
        } else {
            throw new NotSuspendedException();
        }
        return v;
    }

    private void requestVariable(int id, String name) throws NoResponseException, NotConnectedException, NotSuspendedException {
        this.requestVariable(id, name, false, false);
    }

    private void requestVariable(int id, String name, boolean fireGetter, boolean alsoGetChildren) throws NoResponseException, NotConnectedException, NotSuspendedException {
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        name = this.getRawMemberName(id, name);
        DMessage dm = this.buildOutGetMessage(id, name, fireGetter, alsoGetChildren);
        this.m_manager.beginGetterSetter();
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 30, timeout += 500);
        this.m_manager.endGetterSetter();
        if (!result) {
            throw new NoResponseException(timeout);
        }
    }

    private DMessage buildOutGetMessage(int id, String name, boolean fireGetter, boolean alsoGetChildren) {
        int FLAGS_SIZE = 4;
        name = name == null ? "" : name;
        DMessage dm = DMessageCache.alloc(4 + DMessage.getStringLength(name) + 1 + 4);
        dm.setType(!fireGetter ? 25 : 34);
        dm.putDWord(id);
        try {
            dm.putString(name);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        int flags = 4;
        if (fireGetter) {
            flags |= 1;
        }
        if (alsoGetChildren) {
            flags |= 2;
        }
        dm.putDWord(flags);
        return dm;
    }

    public FaultEvent setScalarMember(int varId, String memberName, int type, String value) throws NotSuspendedException, NoResponseException, NotConnectedException {
        int depth;
        DStackContext context;
        DVariable activationObject;
        if (!this.isSuspended()) {
            throw new NotSuspendedException();
        }
        if (varId <= -100 && varId > -300 && (activationObject = (context = this.m_manager.getFrame(depth = -100 - varId)).getActivationObject()) != null) {
            varId = activationObject.getValue().getId();
        }
        memberName = this.getRawMemberName(varId, memberName);
        FaultEvent faultEvent = this.requestSetVariable(this.isPseudoVarId(varId) ? 0 : varId, memberName, type, value);
        if (this.isPseudoVarId(varId) && this.m_manager.getFrameCount() > 0) {
            this.m_manager.getFrame(0).markStale();
        } else {
            DValue parent = this.m_manager.getValue(varId);
            if (parent != null) {
                parent.removeAllMembers();
            }
        }
        return faultEvent;
    }

    private boolean isPseudoVarId(int varId) {
        return varId < 0 && varId > -65535;
    }

    private String getRawMemberName(int parentValueId, String memberName) {
        int doubleColon;
        String shortName;
        DVariable member;
        DValue parent;
        if (memberName != null && (parent = this.m_manager.getValue(parentValueId)) != null && (member = parent.findMember(shortName = (doubleColon = memberName.indexOf("::")) == -1 ? memberName : memberName.substring(doubleColon + 2))) != null) {
            memberName = member.getRawName();
        }
        return memberName;
    }

    private FaultEvent requestSetVariable(int id, String name, int t, String value) throws NoResponseException {
        String type = DVariable.typeNameFor(t);
        DMessage dm = this.buildOutSetMessage(id, name, type, value);
        FaultEvent faultEvent = null;
        this.m_manager.beginGetterSetter();
        this.sendSquelch(false);
        int timeout = this.getPreference("$getvarresponsetimeout");
        if (!this.simpleRequestResponseMessage(dm, t == 2 ? 10 : 28, timeout)) {
            throw new NoResponseException(this.getPreference("$responsetimeout"));
        }
        this.sendSquelch(true);
        faultEvent = this.m_manager.endGetterSetter();
        this.m_manager.freeValueCache();
        return faultEvent;
    }

    private DMessage buildOutSetMessage(int id, String name, String type, String v) {
        DMessage dm = DMessageCache.alloc(4 + DMessage.getStringLength(name) + DMessage.getStringLength(type) + DMessage.getStringLength(v) + 3);
        dm.setType(11);
        dm.putDWord(id);
        try {
            dm.putString(name);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(type);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(v);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        return dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws NotConnectedException, InterruptedException {
        Object eventNotifier = this.m_manager.getEventNotifier();
        while (this.getEventCount() == 0 && this.isConnected()) {
            Object object = eventNotifier;
            synchronized (object) {
                eventNotifier.wait();
            }
        }
        if (this.nextEvent() == null && !this.isConnected()) {
            throw new NotConnectedException();
        }
    }

    public int getEventCount() {
        return this.m_manager.getEventCount();
    }

    public DebugEvent nextEvent() {
        return this.m_manager.nextEvent();
    }

    public boolean addWatch(int varId, String varName, int type, int tag) throws NoResponseException, NotConnectedException {
        varName = this.getRawMemberName(varId, varName);
        DMessage dm = DMessageCache.alloc(10 + DMessage.getStringLength(varName) + 1);
        dm.setType(49);
        dm.putDWord(varId);
        try {
            dm.putString(varName);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        dm.putWord(type);
        dm.putWord(tag);
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 55, timeout);
        return result;
    }

    public boolean removeWatch(int varId, String memberName) throws NoResponseException, NotConnectedException {
        memberName = this.getRawMemberName(varId, memberName);
        DMessage dm = DMessageCache.alloc(6 + DMessage.getStringLength(memberName) + 1);
        dm.setType(50);
        dm.putDWord(varId);
        try {
            dm.putString(memberName);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        int timeout = this.getPreference("$getvarresponsetimeout");
        boolean result = this.simpleRequestResponseMessage(dm, 55, timeout);
        return result;
    }

    void sendMessage(int message) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setType(message);
        this.sendMessage(dm);
    }

    synchronized void sendMessage(DMessage dm) {
        block3: {
            try {
                this.m_protocol.txMessage(dm);
                if (m_debugMsgOn || m_debugMsgFileOn) {
                    this.trace(dm, false);
                }
            }
            catch (IOException io) {
                if (!Trace.error) break block3;
                Trace.trace("Attempt to send message " + dm.outToString() + " failed");
                io.printStackTrace();
            }
        }
        DMessageCache.free(dm);
    }

    boolean sendSquelch(boolean on) {
        DMessage dm = DMessageCache.alloc(4);
        dm.setType(24);
        dm.putDWord(on ? 1L : 0L);
        boolean responded = this.simpleRequestResponseMessage(dm, 29);
        return responded;
    }

    void sendStopWarning() {
        String option = "disable_script_stuck_dialog";
        String value = "on";
        this.sendOptionMessage(option, value);
        option = "disable_script_stuck";
        value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendStopOnFault() {
        String option = "break_on_fault";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendEnumerateOverride() {
        String option = "enumerate_override";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendFailureNotify() {
        String option = "notify_on_failure";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendInvokeSetters() {
        String option = "invoke_setters";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendSwfloadNotify() {
        String option = "swf_load_messages";
        String value = "on";
        this.sendOptionMessage(option, value);
    }

    void sendConsoleErrorsAsTrace(boolean on) {
        String option = "console_errors";
        String value = on ? "on" : "off";
        this.sendOptionMessage(option, value);
    }

    void sendGetterTimeout() {
        String option = "getter_timeout";
        String value = "" + this.getPreference("$getvarresponsetimeout");
        this.sendOptionMessage(option, value);
    }

    void sendSetterTimeout() {
        String option = "setter_timeout";
        String value = "" + this.getPreference("$setvarresponsetimeout");
        this.sendOptionMessage(option, value);
    }

    void sendOptionMessage(String option, String value) {
        int msgSize = DMessage.getStringLength(option) + DMessage.getStringLength(value) + 2;
        DMessage dm = DMessageCache.alloc(msgSize);
        dm.setType(28);
        try {
            dm.putString(option);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        try {
            dm.putString(value);
        }
        catch (UnsupportedEncodingException uee) {
            dm.putByte((byte)0);
        }
        this.simpleRequestResponseMessage(dm, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean simpleRequestResponseMessage(DMessage msg, int msgType, int timeout) {
        boolean response = false;
        timeout = timeout > 0 ? timeout : this.getPreference("$responsetimeout");
        DMessageCounter msgCounter = this.getMessageCounter();
        long num = msgCounter.getInCount(msgType);
        long expect = num + 1L;
        this.sendMessage(msg);
        long startTime = System.currentTimeMillis();
        this.m_incoming = false;
        Object object = msgCounter.getInLock();
        synchronized (object) {
            while (expect > msgCounter.getInCount(msgType) && System.currentTimeMillis() < startTime + (long)timeout && this.isConnected()) {
                try {
                    msgCounter.getInLock().wait(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PlayerSession playerSession = this;
                synchronized (playerSession) {
                    if (this.m_incoming) {
                        startTime = System.currentTimeMillis();
                        this.m_incoming = false;
                    }
                }
            }
        }
        if (msgCounter.getInCount(msgType) >= expect) {
            response = true;
        } else if (timeout <= 0 && Trace.error) {
            Trace.trace("Timed-out waiting for " + DMessage.inTypeName(msgType) + " response to message " + msg.outToString());
        }
        this.m_lastResponse = response;
        return response;
    }

    boolean simpleRequestResponseMessage(DMessage msg, int msgType) {
        return this.simpleRequestResponseMessage(msg, msgType, -1);
    }

    boolean simpleRequestResponseMessage(int msg, int msgType) {
        return this.simpleRequestResponseMessage(msg, msgType, -1);
    }

    boolean simpleRequestResponseMessage(int msg, int msgType, int timeout) {
        DMessage dm = DMessageCache.alloc(0);
        dm.setType(msg);
        return this.simpleRequestResponseMessage(dm, msgType, timeout);
    }

    public void disconnected() {
        this.m_isHalted = false;
        this.m_isConnected = false;
    }

    public void messageArrived(DMessage msg, DProtocol which) {
        if (m_debugMsgOn || m_debugMsgFileOn) {
            this.trace(msg, true);
        }
        int type = msg.getType();
        switch (type) {
            case 2: {
                this.m_isConnected = false;
                break;
            }
            case 25: {
                this.sendMessage(23);
                break;
            }
            case 15: 
            case 27: {
                this.m_isHalted = true;
                break;
            }
            case 17: {
                this.m_isHalted = false;
                break;
            }
            case 32: {
                String s = msg.getString();
                String v = msg.getString();
                this.m_prefs.put(s, v);
                break;
            }
            default: {
                this.m_incoming = true;
            }
        }
        this.m_lastResponse = true;
    }

    public void run() {
        long last = 0L;
        while (this.isConnected()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                long current = this.m_protocol.messagesReceived();
                long delta = last - current;
                last = current;
                if (!this.m_lastResponse || !this.isSuspended() && delta > 5L) {
                    throw new NotSuspendedException();
                }
                int count = this.m_manager.getSwfInfoCount();
                for (int i = 0; i < count; ++i) {
                    DSwfInfo info = this.m_manager.getSwfInfo(i);
                    if (info == null || info.isUnloaded() || info.isPopulated() || info.getVmVersion() > 0) continue;
                    int size = info.getSwdSize(this);
                    if (info.getVmVersion() > 0) {
                        info.setPopulated();
                        continue;
                    }
                    if (info.isSwdLoading() || info.isUnloaded()) continue;
                    if (info.getSwf() == null && !info.isUnloaded()) {
                        info.setSwf(this.requestSwf(i));
                    }
                    if (info.getSwd() == null && !info.isUnloaded()) {
                        info.setSwd(this.requestSwd(i));
                    }
                    try {
                        if (info.isUnloaded()) continue;
                        info.parseSwfSwd(this.m_manager);
                        continue;
                    }
                    catch (Throwable e) {
                        if (Trace.error) {
                            Trace.trace("Error while parsing swf/swd '" + info.getUrl() + "'. Giving up and marking it processed");
                            e.printStackTrace();
                        }
                        info.setPopulated();
                    }
                }
            }
            catch (InProgressException ipe) {
            }
            catch (NoResponseException nre) {
            }
            catch (NotSuspendedException nse) {
            }
            catch (Exception e) {
                if (!Trace.error) continue;
                Trace.trace("Exception in background swf/swd processing thread");
                e.printStackTrace();
            }
        }
    }

    byte[] requestSwf(int index) throws NoResponseException {
        int to = this.getPreference("$swfswdloadtimeout");
        byte[] swf = null;
        DMessage dm = DMessageCache.alloc(2);
        dm.setType(32);
        dm.putWord(index);
        if (!this.simpleRequestResponseMessage(dm, 34, to)) {
            throw new NoResponseException(to);
        }
        swf = this.m_manager.getSWF();
        return swf;
    }

    byte[] requestSwd(int index) throws NoResponseException {
        int to = this.getPreference("$swfswdloadtimeout");
        byte[] swd = null;
        DMessage dm = DMessageCache.alloc(2);
        dm.setType(33);
        dm.putWord(index);
        if (!this.simpleRequestResponseMessage(dm, 35, to)) {
            throw new NoResponseException(to);
        }
        swd = this.m_manager.getSWD();
        return swd;
    }

    synchronized void trace(DMessage dm, boolean in) {
        try {
            if (m_debugMsgOn) {
                System.out.println(in ? dm.inToString(this.m_debugMsgSize) : dm.outToString(this.m_debugMsgSize));
            }
            if (m_debugMsgFileOn) {
                this.traceFile().write(in ? dm.inToString(this.m_debugMsgFileSize) : dm.outToString(this.m_debugMsgFileSize));
                this.m_trace.write(this.m_newline);
                this.m_trace.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Writer traceFile() throws IOException {
        if (this.m_trace == null) {
            block6: {
                this.m_trace = new FileWriter("mm_debug_api_trace.txt");
                try {
                    this.m_trace.write(new Date().toString());
                }
                catch (Exception e) {
                    this.m_trace.write("Date unknown");
                }
                try {
                    this.m_trace.write(this.m_newline);
                    Properties props = System.getProperties();
                    props.list(new PrintWriter(this.m_trace));
                    this.m_trace.write(this.m_newline);
                    Iterator keys = this.m_prefs.keySet().iterator();
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        Object value = this.m_prefs.get(key);
                        this.m_trace.write(key.toString());
                        this.m_trace.write(" = ");
                        this.m_trace.write(value.toString());
                        this.m_trace.write(this.m_newline);
                    }
                }
                catch (Exception e) {
                    if (!Trace.error) break block6;
                    e.printStackTrace();
                }
            }
            this.m_trace.write(this.m_newline);
        }
        return this.m_trace;
    }

    public void setLaunchUrl(String url) {
        if (url.startsWith("/")) {
            url = "file://" + url;
        }
        this.m_launchUrl = url;
    }

    public void setApolloLaunchInfo(ApolloLaunchInfo apolloLaunchInfo) {
        this.m_apolloLaunchInfo = apolloLaunchInfo;
    }
}

