/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.IncompleteExpressionException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.UnknownOperationException;
import flash.tools.debugger.expression.ValueExp;
import flex.tools.debugger.cli.DebugCLI;
import flex.tools.debugger.cli.ExpressionContext;
import flex.tools.debugger.cli.IntProperties;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class ExpressionCache {
    Session m_session;
    ASTBuilder m_builder = new ASTBuilder(true);
    Vector m_expressions = new Vector();
    IntProperties m_props = new IntProperties();
    DebugCLI m_cli;

    public ExpressionCache(DebugCLI cli) {
        this.m_cli = cli;
    }

    public void clear() {
        this.m_expressions.clear();
    }

    public void unbind() {
        this.m_session = null;
    }

    public int size() {
        return this.m_expressions.size();
    }

    public Object at(int i) {
        return this.m_expressions.elementAt(i);
    }

    void setSession(Session s) {
        this.m_session = s;
    }

    public Session getSession() {
        return this.m_session;
    }

    public String getPackageName(int id) {
        return this.m_cli.module2ClassName(id);
    }

    public void bind(Session s) {
        this.setSession(s);
        try {
            ((PlayerSession)s).setPreferences(this.m_props.map());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object evaluate(ValueExp e) throws NumberFormatException, NoSuchVariableException, PlayerFaultException {
        ExpressionContext c = new ExpressionContext(this);
        return e.evaluate(c);
    }

    public ValueExp parse(String s) throws IOException, EmptyStackException, UnknownOperationException, IncompleteExpressionException, ParseException {
        return this.m_builder.parse(new StringReader(s));
    }

    public int add(Object e) {
        int at = this.m_expressions.size();
        this.m_expressions.add(e);
        return at + 1;
    }

    public boolean propertyEnabled(String which) {
        boolean enabled = false;
        try {
            Number number = (Number)this.get(which);
            if (number != null) {
                enabled = number.intValue() != 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enabled;
    }

    public void put(String s, int value) {
        this.m_props.put(s, value);
        this.setSessionProperty(s, value);
    }

    public Set keySet() {
        return this.m_props.keySet();
    }

    void setSessionProperty(String s, int value) {
        Session sess = this.getSession();
        if (sess != null) {
            sess.setPreference(s, value);
        }
        Bootstrap.sessionManager().setPreference(s, value);
    }

    public Object get(String s) throws NumberFormatException, ArrayIndexOutOfBoundsException, NoSuchElementException {
        Object exp = null;
        if (s.charAt(0) != '$') {
            throw new NoSuchElementException(s);
        }
        String num = s.substring(1);
        if (num == null || num.length() == 0) {
            exp = this.at(this.size() - 1);
        } else if (num.equals("$")) {
            exp = this.at(this.size() - 2);
        } else {
            try {
                int index = Integer.parseInt(num);
                exp = this.at(index - 1);
            }
            catch (NumberFormatException nfe) {
                exp = this.m_props.getInteger(s);
            }
        }
        return exp;
    }

    public static void appendVariable(StringBuffer sb, Variable v) {
        String name = v.getName();
        sb.append(name);
        sb.append(" = ");
        ExpressionCache.appendVariableValue(sb, v.getValue(), name);
    }

    public static void appendVariableValue(StringBuffer sb, Value val) {
        ExpressionCache.appendVariableValue(sb, val, "");
    }

    public static void appendVariableValue(StringBuffer sb, Value val, String variableName) {
        int type = val.getType();
        String typeName = val.getTypeName();
        String className = val.getClassName();
        if (typeName != null && typeName.length() == 0) {
            typeName = null;
        }
        switch (type) {
            case 0: {
                double value = (Double)val.getValue();
                long longValue = (long)value;
                if ((double)longValue == value) {
                    sb.append(longValue);
                    sb.append(" (0x");
                    sb.append(Long.toHexString(longValue));
                    sb.append(")");
                    break;
                }
                sb.append(value);
                break;
            }
            case 1: {
                Boolean b = (Boolean)val.getValue();
                if (b.booleanValue()) {
                    sb.append("true");
                    break;
                }
                sb.append("false");
                break;
            }
            case 2: {
                boolean isException = val.isAttributeSet(262144);
                sb.append(isException ? (char)'<' : '\"');
                sb.append(val.getValueAsString());
                sb.append(isException ? (char)'>' : '\"');
                break;
            }
            case 3: {
                sb.append("[");
                sb.append(className);
                if (System.getProperty("fdbunit") == null) {
                    sb.append(" ");
                    sb.append(val.getValue());
                }
                if (typeName != null && !typeName.equals(className)) {
                    sb.append(", class='");
                    int at = typeName.indexOf(64);
                    if (at != -1) {
                        typeName = typeName.substring(0, at);
                    }
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 4: {
                sb.append('[');
                if (val.isAttributeSet(524288)) {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("getterFunction"));
                } else if (val.isAttributeSet(0x100000)) {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("setterFunction"));
                } else {
                    sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("function"));
                }
                sb.append(' ');
                sb.append(val.getValue());
                if (typeName != null && !typeName.equals(variableName)) {
                    sb.append(", name='");
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 5: {
                sb.append("[");
                sb.append(className);
                sb.append(" ");
                sb.append(val.getValue());
                if (typeName != null && !typeName.equals(className)) {
                    sb.append(", named='");
                    sb.append(typeName);
                    sb.append('\'');
                }
                sb.append(']');
                break;
            }
            case 6: {
                sb.append("null");
                break;
            }
            case 7: {
                sb.append("undefined");
                break;
            }
            case 8: {
                sb.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("unknownVariableType"));
            }
        }
    }

    private static LocalizationManager getLocalizationManager() {
        return DebugCLI.getLocalizationManager();
    }

    public static void appendVariableAttributes(StringBuffer sb, Variable v) {
        if (v.getAttributes() == 0) {
            return;
        }
        sb.append("  ");
        if (v.isAttributeSet(1)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_dontEnumerate"));
        }
        if (v.isAttributeSet(4)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_readOnly"));
        }
        if (v.isAttributeSet(32)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_localVariable"));
        }
        if (v.isAttributeSet(65536)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_functionArgument"));
        }
        if (v.isAttributeSet(524288)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_getterFunction"));
        }
        if (v.isAttributeSet(0x100000)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_setterFunction"));
        }
        if (v.isAttributeSet(131072)) {
            sb.append(", dynamic");
        }
        if (v.isAttributeSet(0x200000)) {
            sb.append(", static");
        }
        if (v.isAttributeSet(0x400000)) {
            sb.append(", const");
        }
        if (v.isAttributeSet(0x800000)) {
            sb.append(", private");
        }
        if (v.isAttributeSet(0)) {
            sb.append(", public");
        }
        if (v.isAttributeSet(0x1000000)) {
            sb.append(", protected");
        }
        if (v.isAttributeSet(0x1800000)) {
            sb.append(", internal");
        }
        if (v.isAttributeSet(0x2000000)) {
            sb.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_hasNamespace"));
        }
    }
}

