/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.dump;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ProxyOutputStream;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.dump.DumpDexCodeAdapter;
import pxb.android.dex2jar.reader.DexFileReader;
import pxb.android.dex2jar.visitors.DexClassAdapter;
import pxb.android.dex2jar.visitors.DexClassVisitor;
import pxb.android.dex2jar.visitors.DexCodeVisitor;
import pxb.android.dex2jar.visitors.DexFieldVisitor;
import pxb.android.dex2jar.visitors.DexFileVisitor;
import pxb.android.dex2jar.visitors.DexMethodAdapter;
import pxb.android.dex2jar.visitors.DexMethodVisitor;
import pxb.android.dex2jar.visitors.EmptyVisitor;

public class Dump
implements DexFileVisitor {
    private int class_count = 0;
    private DexFileVisitor dfv;
    private PrintWriter out;
    WriterManager writerManager;

    public static String getAccDes(int acc) {
        StringBuilder sb = new StringBuilder();
        if ((acc & 1) != 0) {
            sb.append("public ");
        }
        if ((acc & 4) != 0) {
            sb.append("protected ");
        }
        if ((acc & 2) != 0) {
            sb.append("private ");
        }
        if ((acc & 8) != 0) {
            sb.append("static ");
        }
        if ((acc & 0x400) != 0 && (acc & 0x200) == 0) {
            sb.append("abstract ");
        }
        if ((acc & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((acc & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((acc & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        if ((acc & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((acc & 0x10) != 0) {
            sb.append("final ");
        }
        if ((acc & 0x200) != 0) {
            sb.append("interace ");
        }
        if ((acc & 0x100) != 0) {
            sb.append("native ");
        }
        if ((acc & 0x800) != 0) {
            sb.append("strict ");
        }
        if ((acc & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((acc & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((acc & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((acc & 0x40) != 0) {
            sb.append("volatile ");
        }
        return sb.toString();
    }

    public Dump(DexFileVisitor dfv, WriterManager writerManager) {
        this.dfv = dfv;
        this.writerManager = writerManager;
    }

    @Override
    public DexClassVisitor visit(int access_flags, String className, String superClass, String ... interfaceNames) {
        String javaClassName = Type.getType((String)className).getClassName();
        this.out = this.writerManager.get(javaClassName);
        this.out.printf("//class:%04d  access:0x%04x\n", this.class_count++, access_flags);
        this.out.print(Dump.getAccDes(access_flags));
        if ((access_flags & 0x200) == 0) {
            this.out.print("class ");
        }
        this.out.print(javaClassName);
        if (!"Ljava/lang/Object;".equals(superClass)) {
            this.out.print(" extends ");
            this.out.print(Type.getType((String)superClass).getClassName());
        }
        if (interfaceNames != null && interfaceNames.length > 0) {
            this.out.print(" implements ");
            this.out.print(Type.getType((String)interfaceNames[0]).getClassName());
            for (int i = 1; i < interfaceNames.length; ++i) {
                this.out.print(',');
                this.out.print(Type.getType((String)interfaceNames[i]).getClassName());
            }
        }
        this.out.println();
        DexClassVisitor dcv = this.dfv.visit(access_flags, className, superClass, interfaceNames);
        if (dcv == null) {
            return null;
        }
        return new DexClassAdapter(dcv){
            int method_count;
            int field_count;
            {
                this.method_count = 0;
                this.field_count = 0;
            }

            @Override
            public DexFieldVisitor visitField(Field field, Object value) {
                Dump.this.out.printf("//field:%04d  access:0x%04x\n", this.field_count++, field.getAccessFlags());
                Dump.this.out.printf("//%s\n", field);
                Dump.this.out.printf("%s %s %s", Dump.getAccDes(field.getAccessFlags()), Type.getType((String)field.getType()).getClassName(), field.getName());
                if (value != null) {
                    Dump.this.out.print('=');
                    Dump.this.out.print(value);
                }
                Dump.this.out.println(';');
                return this.dcv.visitField(field, value);
            }

            @Override
            public void visitEnd() {
                Dump.this.out.flush();
                Dump.this.out.close();
                Dump.this.out = null;
                super.visitEnd();
            }

            @Override
            public DexMethodVisitor visitMethod(final Method method) {
                Dump.this.out.println();
                Dump.this.out.printf("//method:%04d  access:0x%04x\n", this.method_count++, method.getAccessFlags());
                Dump.this.out.printf("//%s\n", method);
                Dump.this.out.printf("%s%s %s(", Dump.getAccDes(method.getAccessFlags()), Type.getType((String)method.getType().getReturnType()).getClassName(), method.getName());
                String[] ps = method.getType().getParameterTypes();
                if (ps != null && ps.length > 0) {
                    Dump.this.out.print(Type.getType((String)ps[0]).getClassName());
                    for (int i = 1; i < ps.length; ++i) {
                        Dump.this.out.print(',');
                        Dump.this.out.print(Type.getType((String)ps[i]).getClassName());
                    }
                }
                Dump.this.out.println(')');
                DexMethodVisitor dmv = this.dcv.visitMethod(method);
                if (dmv == null) {
                    return null;
                }
                return new DexMethodAdapter(dmv){

                    @Override
                    public DexCodeVisitor visitCode() {
                        DexCodeVisitor dcv = this.mv.visitCode();
                        if (dcv == null) {
                            return null;
                        }
                        return new DumpDexCodeAdapter(dcv, method, Dump.this.out);
                    }
                };
            }
        };
    }

    public static void main(String ... args) throws IOException {
        if (args.length < 2) {
            System.out.println("Dump in.dexORapk out.dump.jar");
            return;
        }
        Dump.doFile(new File(args[0]), new File(args[1]));
    }

    public static void doFile(File srcDex) throws IOException {
        Dump.doFile(srcDex, new File(srcDex.getParentFile(), srcDex.getName() + ".dump.jar"));
    }

    public static void doFile(File srcDex, File destJar) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)srcDex);
        if ("dex".equals(new String(data, 0, 3))) {
            Dump.doData(data, destJar);
        } else if ("PK".equals(new String(data, 0, 2))) {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(data));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals("classes.dex")) {
                    data = IOUtils.toByteArray((InputStream)zis);
                    Dump.doData(data, destJar);
                }
                entry = zis.getNextEntry();
            }
        } else {
            throw new RuntimeException("the src file not a .dex file or a zip file");
        }
    }

    public static void doData(byte[] data, File destJar) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destJar)));
        new DexFileReader(data).accept(new Dump(new EmptyVisitor(), new WriterManager(){

            @Override
            public PrintWriter get(String name) {
                try {
                    String s = name.replace('.', '/') + ".dump.txt";
                    ZipEntry zipEntry = new ZipEntry(s);
                    zos.putNextEntry(zipEntry);
                    return new PrintWriter((OutputStream)new ProxyOutputStream(zos){

                        public void close() throws IOException {
                            zos.closeEntry();
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        zos.finish();
        zos.close();
    }

    @Override
    public void visitEnd() {
        this.dfv.visitEnd();
    }

    public static interface WriterManager {
        public PrintWriter get(String var1);
    }
}

