/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize;

import java.util.HashMap;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.util.TraceMethodVisitor;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.optimize.MethodTransformer;
import pxb.android.dex2jar.optimize.Util;
import pxb.android.dex2jar.optimize.c.CAnalyzer;
import pxb.android.dex2jar.optimize.c.CBasicValue;
import pxb.android.dex2jar.optimize.c.CFrame;
import pxb.android.dex2jar.optimize.c.DexInterpreter;

public class C
implements MethodTransformer,
Opcodes {
    private final Method m;

    @Override
    public void transform(MethodNode method) {
        DexInterpreter dx = new DexInterpreter();
        CAnalyzer a = new CAnalyzer(dx);
        try {
            a.analyze(Type.getType((String)this.m.getOwner()).getInternalName(), method);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException("fail on " + this.m, e);
        }
        Frame[] fs = a.getFrames();
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        int nIndex = 0;
        int oIndex = 0;
        if ((method.access & 8) == 0) {
            remap.put(oIndex++, nIndex++);
        }
        for (Type t : Type.getArgumentTypes((String)method.desc)) {
            remap.put(oIndex++, nIndex++);
            if (t.getSize() <= 1) continue;
            ++nIndex;
        }
        for (int i = 0; i < fs.length; ++i) {
            CFrame f;
            Integer oldVar;
            Type t;
            CBasicValue v;
            AbstractInsnNode node = method.instructions.get(i);
            if (fs[i] == null) continue;
            if (Util.isRead(node)) {
                Integer nVar;
                CFrame f2 = (CFrame)fs[i + 1];
                v = (CBasicValue)f2.peek();
                t = v.getType();
                if (t != null) {
                    ((VarInsnNode)node).setOpcode(t.getOpcode(21));
                }
                if ((nVar = (Integer)remap.get(oldVar = Integer.valueOf(Util.var(node)))) == null) {
                    nVar = nIndex++;
                    remap.put(oldVar, nVar);
                    if (t != null && t.getSize() > 1) {
                        ++nIndex;
                    }
                }
                Util.var(node, nVar);
                continue;
            }
            if (Util.isWrite(node)) {
                Integer nVar;
                CFrame f3 = (CFrame)fs[i];
                v = (CBasicValue)f3.peek();
                t = v.getType();
                if (t != null) {
                    ((VarInsnNode)node).setOpcode(t.getOpcode(54));
                }
                if ((nVar = (Integer)remap.get(oldVar = Integer.valueOf(Util.var(node)))) == null) {
                    nVar = nIndex++;
                    remap.put(oldVar, nVar);
                    if (t != null && t.getSize() > 1) {
                        ++nIndex;
                    }
                }
                Util.var(node, nVar);
                continue;
            }
            if (node.getOpcode() == 18) {
                CFrame f4 = (CFrame)fs[i + 1];
                v = (CBasicValue)f4.peek();
                t = v.getType();
                if (t == null) continue;
                LdcInsnNode ldcInsnNode = (LdcInsnNode)node;
                if (!(ldcInsnNode.cst instanceof Number)) continue;
                switch (t.getSort()) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        int iValue = ((Number)ldcInsnNode.cst).intValue();
                        ldcInsnNode.cst = (short)iValue;
                        break;
                    }
                    case 2: {
                        int iValue = ((Number)ldcInsnNode.cst).intValue();
                        ldcInsnNode.cst = Character.valueOf((char)iValue);
                        break;
                    }
                    case 4: {
                        int iValue = ((Number)ldcInsnNode.cst).intValue();
                        ldcInsnNode.cst = (short)iValue;
                        break;
                    }
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 6: {
                        int iValue = ((Number)ldcInsnNode.cst).intValue();
                        ldcInsnNode.cst = Float.valueOf(Float.intBitsToFloat(iValue));
                        break;
                    }
                    case 8: {
                        long iValue = ((Number)ldcInsnNode.cst).longValue();
                        ldcInsnNode.cst = Double.longBitsToDouble(iValue);
                        break;
                    }
                    default: {
                        ldcInsnNode.cst = null;
                    }
                }
                continue;
            }
            if (node.getOpcode() == 154) {
                CFrame f5 = (CFrame)fs[i];
                v = (CBasicValue)f5.peek();
                t = v.getType();
                if (t == null || t.getSort() != 9 && t.getSort() != 10) continue;
                ((JumpInsnNode)node).setOpcode(199);
                continue;
            }
            if (node.getOpcode() != 153 || (t = (v = (CBasicValue)(f = (CFrame)fs[i]).peek()).getType()) == null || t.getSort() != 9 && t.getSort() != 10) continue;
            ((JumpInsnNode)node).setOpcode(198);
        }
    }

    public C(Method m) {
        this.m = m;
    }

    public void dump(InsnList insnList) {
        TraceMethodVisitor tr = new TraceMethodVisitor();
        tr.text.clear();
        insnList.accept((MethodVisitor)tr);
        int i = 0;
        for (Object o : tr.text) {
            System.out.print(i++ + " " + o);
        }
        tr.text.clear();
    }

    public static void replace(AbstractInsnNode node) {
        if (Util.isRead(node)) {
            ((VarInsnNode)node).setOpcode(25);
        } else if (Util.isWrite(node)) {
            ((VarInsnNode)node).setOpcode(58);
        } else if (node.getOpcode() == 153) {
            ((JumpInsnNode)node).setOpcode(198);
        } else if (node.getOpcode() == 154) {
            ((JumpInsnNode)node).setOpcode(199);
        } else if (node.getOpcode() == 18) {
            ((LdcInsnNode)node).cst = null;
        }
    }
}

