/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import pxb.android.dex2jar.optimize.MethodTransformer;

public class D
implements MethodTransformer,
Opcodes {
    private Block first;
    private Map<LabelNode, Block> map = new HashMap<LabelNode, Block>();
    private Map<TcbK, Map<Block, String>> tcbs = new TreeMap<TcbK, Map<Block, String>>(new Comparator<TcbK>(){

        @Override
        public int compare(TcbK o1, TcbK o2) {
            int i = o1.start.id - o2.start.id;
            int j = o1.end.id - o2.end.id;
            return i == 0 ? j : i;
        }
    });

    private static LabelNode getNextLabelNode(AbstractInsnNode p, InsnList insns) {
        AbstractInsnNode q = p.getNext();
        if (q.getType() == 7) {
            return (LabelNode)q;
        }
        LabelNode r = new LabelNode();
        insns.insert(p, (AbstractInsnNode)r);
        return r;
    }

    private void addToMap(Block block) {
        this.map.put(block.label, block);
        if (block.id == 0) {
            this.first = block;
        }
    }

    private void cut(MethodNode method) {
        AbstractInsnNode q;
        InsnList insns = method.instructions;
        method.instructions = null;
        AbstractInsnNode p = insns.getFirst();
        if (!(p instanceof LabelNode)) {
            insns.insertBefore(p, (AbstractInsnNode)new LabelNode());
        }
        if (!((q = insns.getLast()) instanceof LabelNode)) {
            insns.insert(q, (AbstractInsnNode)new LabelNode());
        }
        HashMap<LabelNode, LabelNode> cloneMap = new HashMap<LabelNode, LabelNode>(){

            @Override
            public LabelNode get(Object key) {
                LabelNode l = (LabelNode)super.get(key);
                if (l == null) {
                    l = new LabelNode();
                    this.put((LabelNode)key, l);
                }
                return l;
            }
        };
        HashMap<LabelNode, Block> preBlockMap = new HashMap<LabelNode, Block>();
        int i = 0;
        LabelNode label = null;
        Block block = null;
        ArrayList<AbstractInsnNode> currentInsnList = null;
        block8: for (AbstractInsnNode p2 = insns.getFirst(); p2 != null; p2 = p2.getNext()) {
            AbstractInsnNode cp = p2.clone((Map)cloneMap);
            switch (cp.getType()) {
                case 7: {
                    if (label != null) {
                        block = new Block(i++, label);
                        block.insns = currentInsnList;
                        block.next = (LabelNode)cp;
                        this.addToMap(block);
                    }
                    currentInsnList = new ArrayList<AbstractInsnNode>();
                    label = (LabelNode)cp;
                    preBlockMap.put(label, block);
                    continue block8;
                }
                case 6: 
                case 10: 
                case 11: {
                    if (cp.getOpcode() == 167) {
                        block = new Block(i++, label);
                        block.next = ((JumpInsnNode)cp).label;
                    } else {
                        block = new BranchBlock(i++, label, cp);
                        block.next = (LabelNode)D.getNextLabelNode(p2, insns).clone((Map)cloneMap);
                    }
                    block.insns = currentInsnList;
                    this.addToMap(block);
                    currentInsnList = null;
                    label = null;
                    continue block8;
                }
                case 13: 
                case 14: {
                    continue block8;
                }
                default: {
                    switch (cp.getOpcode()) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: 
                        case 191: {
                            block = new EndBlock(i++, label, cp);
                            block.next = null;
                            D.getNextLabelNode(p2, insns);
                            block.insns = currentInsnList;
                            this.addToMap(block);
                            currentInsnList = null;
                            label = null;
                            continue block8;
                        }
                    }
                    currentInsnList.add(cp);
                }
            }
        }
        for (TryCatchBlockNode tcn : method.tryCatchBlocks) {
            Block s = this.map.get((LabelNode)tcn.start.clone((Map)cloneMap));
            Block e = this.map.get((LabelNode)tcn.end.clone((Map)cloneMap));
            Block handler = this.map.get(tcn.handler.clone((Map)cloneMap));
            TcbK key = new TcbK(s, e);
            Map<Block, String> handlers = this.tcbs.get(key);
            if (handlers == null) {
                handlers = new TreeMap<Block, String>(new Comparator<Block>(){

                    @Override
                    public int compare(Block o1, Block o2) {
                        return o1.id - o2.id;
                    }
                });
                this.tcbs.put(key, handlers);
            }
            handlers.put(handler, tcn.type);
            tcn.start = s.label;
            tcn.end = e.label;
            tcn.handler = handler.label;
        }
    }

    private void doRebuild(InsnList insnList, Stack<Block> toWriteBlock, List<LabelNode> visited) {
        block4: while (!toWriteBlock.empty()) {
            Block b = toWriteBlock.pop();
            if (visited.contains(b.label)) continue;
            visited.add(b.label);
            insnList.add((AbstractInsnNode)b.label);
            for (AbstractInsnNode p : b.insns) {
                insnList.add(p);
            }
            if (b instanceof BranchBlock) {
                BranchBlock bb = (BranchBlock)b;
                switch (bb.branchInsn.getType()) {
                    case 6: {
                        JumpInsnNode jump = (JumpInsnNode)bb.branchInsn;
                        insnList.add((AbstractInsnNode)jump);
                        toWriteBlock.push(this.map.get(jump.label));
                        if (visited.contains(bb.next)) {
                            insnList.add((AbstractInsnNode)new JumpInsnNode(167, bb.next));
                            continue block4;
                        }
                        toWriteBlock.push(this.map.get(bb.next));
                        continue block4;
                    }
                    case 10: 
                    case 11: {
                        AbstractInsnNode ts = bb.branchInsn;
                        LabelNode dfltLabel = ts.getType() == 11 ? ((LookupSwitchInsnNode)ts).dflt : ((TableSwitchInsnNode)ts).dflt;
                        List labels = ts.getType() == 11 ? ((LookupSwitchInsnNode)ts).labels : ((TableSwitchInsnNode)ts).labels;
                        insnList.add(ts);
                        toWriteBlock.push(this.map.get(dfltLabel));
                        ArrayList cLables = new ArrayList(labels);
                        Collections.reverse(cLables);
                        for (LabelNode labelNode : cLables) {
                            toWriteBlock.push(this.map.get(labelNode));
                        }
                        continue block4;
                    }
                }
                continue;
            }
            if (b instanceof EndBlock) {
                EndBlock eb = (EndBlock)b;
                insnList.add(eb.endInsn);
            }
            if (b.next == null) continue;
            if (visited.contains(b.next)) {
                insnList.add((AbstractInsnNode)new JumpInsnNode(167, b.next));
                continue;
            }
            toWriteBlock.push(this.map.get(b.next));
        }
    }

    private void rebuild(MethodNode method) {
        InsnList insnList;
        method.instructions = insnList = new InsnList();
        ArrayList<LabelNode> visited = new ArrayList<LabelNode>();
        Stack<Block> toWriteBlock = new Stack<Block>();
        toWriteBlock.push(this.first);
        this.doRebuild(insnList, toWriteBlock, visited);
        method.tryCatchBlocks = new ArrayList();
        for (TryCatchBlockNode tcn : method.tryCatchBlocks) {
            toWriteBlock.push(this.map.get(tcn.handler));
            this.doRebuild(insnList, toWriteBlock, visited);
        }
    }

    @Override
    public void transform(MethodNode method) {
        this.cut(method);
        this.rebuild(method);
    }

    private static class TcbK {
        public final Block start;
        public final Block end;

        public TcbK(Block start, Block end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object obj) {
            TcbK tcbk = (TcbK)obj;
            return tcbk.start.id == this.start.id && tcbk.end.id == this.end.id;
        }

        public int hashCode() {
            return this.start.id * 31 + this.end.id;
        }
    }

    private static class EndBlock
    extends Block {
        public final AbstractInsnNode endInsn;

        public EndBlock(int id, LabelNode label, AbstractInsnNode endInsn) {
            super(id, label);
            this.endInsn = endInsn;
        }

        public EndBlock clone() {
            EndBlock n = new EndBlock(this.id, new LabelNode(), this.endInsn.clone(null));
            ArrayList<AbstractInsnNode> insnList = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode p : this.insns) {
                insnList.add(p.clone(null));
            }
            n.insns = insnList;
            return n;
        }
    }

    private static final class BranchBlock
    extends Block {
        public final AbstractInsnNode branchInsn;

        public BranchBlock(int id, LabelNode label, AbstractInsnNode insn) {
            super(id, label);
            this.branchInsn = insn;
        }
    }

    private static class Block {
        public final int id;
        public List<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        public final LabelNode label;
        public LabelNode next;

        public Block(int id, LabelNode label) {
            this.id = id;
            this.label = label;
        }

        public String toString() {
            return String.format("B%03d", this.id);
        }
    }
}

