/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize.c;

import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;
import pxb.android.dex2jar.optimize.c.CBasicValue;

public class CBasicInterpreter
implements Opcodes,
Interpreter {
    public Value newValue(Type type) {
        if (type == null) {
            return new CBasicValue(type);
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return CBasicValue.INT_VALUE;
            }
            case 6: {
                return CBasicValue.FLOAT_VALUE;
            }
            case 7: {
                return CBasicValue.LONG_VALUE;
            }
            case 8: {
                return CBasicValue.DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return new CBasicValue(type);
            }
        }
        throw new Error("Internal error");
    }

    public Value newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return this.newValue(Type.getObjectType((String)"null"));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return CBasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return CBasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return CBasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return CBasicValue.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return CBasicValue.INT_VALUE;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return CBasicValue.INT_VALUE;
                }
                if (cst instanceof Float) {
                    return CBasicValue.FLOAT_VALUE;
                }
                if (cst instanceof Long) {
                    return CBasicValue.LONG_VALUE;
                }
                if (cst instanceof Double) {
                    return CBasicValue.DOUBLE_VALUE;
                }
                if (cst instanceof Type) {
                    return this.newValue(Type.getObjectType((String)"java/lang/Class"));
                }
                return this.newValue(Type.getType(cst.getClass()));
            }
            case 168: {
                return CBasicValue.RETURNADDRESS_VALUE;
            }
            case 178: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        throw new Error("Internal error.");
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        return value;
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return CBasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return CBasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return CBasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return CBasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.getType((String)"[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.getType((String)"[C"));
                    }
                    case 8: {
                        return this.newValue(Type.getType((String)"[B"));
                    }
                    case 9: {
                        return this.newValue(Type.getType((String)"[S"));
                    }
                    case 10: {
                        return this.newValue(Type.getType((String)"[I"));
                    }
                    case 6: {
                        return this.newValue(Type.getType((String)"[F"));
                    }
                    case 7: {
                        return this.newValue(Type.getType((String)"[D"));
                    }
                    case 11: {
                        return this.newValue(Type.getType((String)"[J"));
                    }
                }
                throw new AnalyzerException("Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType((String)("[" + Type.getObjectType((String)desc))));
            }
            case 190: {
                return CBasicValue.INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getObjectType((String)desc));
            }
            case 193: {
                return CBasicValue.INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return CBasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return CBasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return CBasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return CBasicValue.DOUBLE_VALUE;
            }
            case 50: {
                return new CBasicValue(null);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return CBasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        return null;
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn.getOpcode() == 197) {
            return this.newValue(Type.getType((String)((MultiANewArrayInsnNode)insn).desc));
        }
        return this.newValue(Type.getReturnType((String)((MethodInsnNode)insn).desc));
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) throws AnalyzerException {
    }

    public Value merge(Value v, Value w) {
        if (!v.equals(w)) {
            return new CBasicValue(null);
        }
        return v;
    }
}

