/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.DataInImpl;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.Proto;
import pxb.android.dex2jar.reader.Constant;
import pxb.android.dex2jar.reader.DexAnnotationReader;
import pxb.android.dex2jar.reader.DexCodeReader;
import pxb.android.dex2jar.visitors.DexAnnotationAble;
import pxb.android.dex2jar.visitors.DexClassVisitor;
import pxb.android.dex2jar.visitors.DexCodeVisitor;
import pxb.android.dex2jar.visitors.DexFieldVisitor;
import pxb.android.dex2jar.visitors.DexFileVisitor;
import pxb.android.dex2jar.visitors.DexMethodVisitor;

public class DexFileReader
implements Dex {
    private static final Logger log = LoggerFactory.getLogger(DexFileReader.class);
    private int class_defs_off;
    private int class_defs_size;
    private boolean continueOnException = false;
    private int data_off;
    private int data_size;
    private int field_ids_off;
    private int field_ids_size;
    private DataIn in;
    private int method_ids_off;
    private int method_ids_size;
    private int proto_ids_off;
    private int proto_ids_size;
    private int string_ids_off;
    private int string_ids_size;
    private int type_ids_off;
    private int type_ids_size;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public DexFileReader(byte[] data) {
        DataInImpl in = new DataInImpl(data);
        this.in = in;
        byte[] magic = in.readBytes(3);
        log.debug("magic:'{}'", (Object)new String(magic));
        in.skip(1);
        byte[] version = in.readBytes(3);
        log.debug("version:'{}'", (Object)new String(version));
        in.readByte();
        int checksum = in.readIntx();
        log.debug("checksum:0x{}", (Object)Integer.toHexString(checksum));
        in.skip(20);
        int fileSize = in.readIntx();
        log.debug("fileSize:{}", (Object)fileSize);
        int headSize = in.readIntx();
        log.debug("headSize:{}", (Object)headSize);
        int x28h = in.readIntx();
        log.debug("x28h:{} (0x{})", (Object)x28h, (Object)Integer.toHexString(x28h));
        int link_size = in.readIntx();
        log.debug("link_size:{}", (Object)link_size);
        int link_off = in.readIntx();
        log.debug("link_off:{} (0x{})", (Object)link_off, (Object)Integer.toHexString(link_off));
        int mapOff = in.readIntx();
        log.debug("x34h:{}", (Object)mapOff);
        this.string_ids_size = in.readIntx();
        log.debug("string_ids_size:{}", (Object)this.string_ids_size);
        this.string_ids_off = in.readIntx();
        log.debug("string_ids_off:{} (0x{})", (Object)this.string_ids_off, (Object)Integer.toHexString(this.string_ids_off));
        this.type_ids_size = in.readIntx();
        log.debug("type_ids_size:{} (0x{})", (Object)this.type_ids_size, (Object)Integer.toHexString(this.type_ids_size));
        this.type_ids_off = in.readIntx();
        log.debug("type_ids_off:{} (0x{})", (Object)this.type_ids_off, (Object)Integer.toHexString(this.type_ids_off));
        this.proto_ids_size = in.readIntx();
        log.debug("proto_ids_size:{} (0x{})", (Object)this.proto_ids_size, (Object)Integer.toHexString(this.proto_ids_size));
        this.proto_ids_off = in.readIntx();
        log.debug("proto_ids_off:{} (0x{})", (Object)this.proto_ids_off, (Object)Integer.toHexString(this.proto_ids_off));
        this.field_ids_size = in.readIntx();
        log.debug("field_ids_size:{} (0x{})", (Object)this.field_ids_size, (Object)Integer.toHexString(this.field_ids_size));
        this.field_ids_off = in.readIntx();
        log.debug("field_ids_off:{} (0x{})", (Object)this.field_ids_off, (Object)Integer.toHexString(this.field_ids_off));
        this.method_ids_size = in.readIntx();
        log.debug("method_ids_size:{} (0x{})", (Object)this.method_ids_size, (Object)Integer.toHexString(this.method_ids_size));
        this.method_ids_off = in.readIntx();
        log.debug("method_ids_off:{} (0x{})", (Object)this.method_ids_off, (Object)Integer.toHexString(this.method_ids_off));
        this.class_defs_size = in.readIntx();
        log.debug("class_defs_size:{} (0x{})", (Object)this.class_defs_size, (Object)Integer.toHexString(this.class_defs_size));
        this.class_defs_off = in.readIntx();
        log.debug("class_defs_off:{} (0x{})", (Object)this.class_defs_off, (Object)Integer.toHexString(this.class_defs_off));
        this.data_size = in.readIntx();
        log.debug("data_size:{} (0x{})", (Object)this.data_size, (Object)Integer.toHexString(this.data_size));
        this.data_off = in.readIntx();
        log.debug("data_off:{} (0x{})", (Object)this.data_off, (Object)Integer.toHexString(this.data_off));
        log.debug("=======End Of Head========");
    }

    public DexFileReader(File f) throws IOException {
        this(new BufferedInputStream(new FileInputStream(f)));
    }

    public DexFileReader(InputStream in) throws IOException {
        this(IOUtils.toByteArray((InputStream)in));
    }

    public void accept(DexFileVisitor dv) {
        DataIn in = this.in;
        for (int cid = 0; cid < this.class_defs_size; ++cid) {
            int idxOffset = this.class_defs_off + cid * 32;
            in.pushMove(idxOffset);
            try {
                this.acceptClass(dv);
            }
            catch (Exception e) {
                log.error("Fail on class", (Throwable)e);
                if (!this.continueOnException) {
                    throw new RuntimeException(e);
                }
                e.printStackTrace();
            }
            in.pop();
        }
        dv.visitEnd();
    }

    private void acceptClass(DexFileVisitor dv) {
        DexClassVisitor dcv;
        int i;
        DataIn in = this.in;
        int class_idx = in.readIntx();
        String className = this.getType(class_idx);
        int access_flags = in.readIntx();
        int superclass_idx = in.readIntx();
        String superClassName = superclass_idx == -1 ? null : this.getType(superclass_idx);
        String[] interfaceNames = null;
        int interfaces_off = in.readIntx();
        if (interfaces_off != 0) {
            in.pushMove(interfaces_off);
            int size = in.readIntx();
            interfaceNames = new String[size];
            for (i = 0; i < size; ++i) {
                interfaceNames[i] = this.getType(in.readShortx());
            }
            in.pop();
        }
        if ((dcv = dv.visit(access_flags, className, superClassName, interfaceNames)) == null) {
            return;
        }
        int source_file_idx = in.readIntx();
        if (source_file_idx != -1) {
            dcv.visitSource(this.getString(source_file_idx));
        }
        HashMap<Integer, Integer> fieldAnnotationPositions = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> methodAnnotationPositions = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> paramAnnotationPositions = new HashMap<Integer, Integer>();
        int annotations_off = in.readIntx();
        if (annotations_off != 0) {
            int method_idx;
            in.pushMove(annotations_off);
            int class_annotations_off = in.readIntx();
            if (class_annotations_off != 0) {
                in.pushMove(class_annotations_off);
                new DexAnnotationReader(this).accept(in, dcv);
                in.pop();
            }
            int field_annotation_size = in.readIntx();
            int method_annotation_size = in.readIntx();
            int parameter_annotation_size = in.readIntx();
            for (i = 0; i < field_annotation_size; ++i) {
                int field_idx = in.readIntx();
                int field_annotations_offset = in.readIntx();
                fieldAnnotationPositions.put(field_idx, field_annotations_offset);
            }
            for (i = 0; i < method_annotation_size; ++i) {
                method_idx = in.readIntx();
                int method_annotation_offset = in.readIntx();
                methodAnnotationPositions.put(method_idx, method_annotation_offset);
            }
            for (i = 0; i < parameter_annotation_size; ++i) {
                method_idx = in.readIntx();
                int parameter_annotation_offset = in.readIntx();
                paramAnnotationPositions.put(method_idx, parameter_annotation_offset);
            }
            in.pop();
        }
        int class_data_off = in.readIntx();
        int static_values_off = in.readIntx();
        if (class_data_off != 0) {
            int i2;
            in.pushMove(class_data_off);
            int static_fields = (int)in.readUnsignedLeb128();
            int instance_fields = (int)in.readUnsignedLeb128();
            int direct_methods = (int)in.readUnsignedLeb128();
            int virtual_methods = (int)in.readUnsignedLeb128();
            int lastIndex = 0;
            Object[] constant = null;
            if (static_values_off != 0) {
                in.pushMove(static_values_off);
                int size = (int)in.readUnsignedLeb128();
                constant = new Object[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    constant[i3] = Constant.ReadConstant(this, in);
                }
                in.pop();
            }
            for (int i4 = 0; i4 < static_fields; ++i4) {
                Object value = null;
                if (constant != null && i4 < constant.length) {
                    value = constant[i4];
                }
                lastIndex = this.visitField(lastIndex, dcv, fieldAnnotationPositions, value);
            }
            lastIndex = 0;
            for (i2 = 0; i2 < instance_fields; ++i2) {
                lastIndex = this.visitField(lastIndex, dcv, fieldAnnotationPositions, null);
            }
            lastIndex = 0;
            for (i2 = 0; i2 < direct_methods; ++i2) {
                lastIndex = this.visitMethod(lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions);
            }
            lastIndex = 0;
            for (i2 = 0; i2 < virtual_methods; ++i2) {
                lastIndex = this.visitMethod(lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions);
            }
            in.pop();
        }
        dcv.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field getField(int id) {
        if (id >= this.field_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.field_ids_off + id * 8;
        in.pushMove(idxOffset);
        try {
            Field field = new Field(this, in);
            return field;
        }
        finally {
            in.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method getMethod(int id) {
        if (id >= this.method_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.method_ids_off + id * 8;
        in.pushMove(idxOffset);
        try {
            Method method = new Method(this, in);
            return method;
        }
        finally {
            in.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Proto getProto(int id) {
        if (id >= this.proto_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.proto_ids_off + id * 12;
        in.pushMove(idxOffset);
        try {
            Proto proto = new Proto(this, in);
            return proto;
        }
        finally {
            in.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int id) {
        if (id >= this.string_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.string_ids_off + id * 4;
        in.pushMove(idxOffset);
        try {
            int offset = in.readIntx();
            in.pushMove(offset);
            try {
                int length = (int)in.readUnsignedLeb128();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
                int b = in.readByte();
                while (b != 0) {
                    baos.write(b);
                    b = in.readByte();
                }
                String string = new String(baos.toByteArray(), UTF8);
                in.pop();
                return string;
            }
            catch (Throwable throwable) {
                in.pop();
                throw throwable;
            }
        }
        finally {
            in.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType(int id) {
        if (id >= this.type_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.type_ids_off + id * 4;
        in.pushMove(idxOffset);
        try {
            int offset = in.readIntx();
            String string = this.getString(offset);
            return string;
        }
        finally {
            in.pop();
        }
    }

    protected int visitField(int lastIndex, DexClassVisitor dcv, Map<Integer, Integer> fieldAnnotationPositions, Object value) {
        int diff = (int)this.in.readUnsignedLeb128();
        int field_id = lastIndex + diff;
        Field field = this.getField(field_id);
        int field_access_flags = (int)this.in.readUnsignedLeb128();
        field.setAccessFlags(field_access_flags);
        DexFieldVisitor dfv = dcv.visitField(field, value);
        if (dfv != null) {
            Integer annotation_offset = fieldAnnotationPositions.get(field_id);
            if (annotation_offset != null) {
                this.in.pushMove(annotation_offset);
                new DexAnnotationReader(this).accept(this.in, dfv);
                this.in.pop();
            }
            dfv.visitEnd();
        }
        return field_id;
    }

    protected int visitMethod(int lastIndex, DexClassVisitor cv, Map<Integer, Integer> methodAnnos, Map<Integer, Integer> parameterAnnos) {
        int diff = (int)this.in.readUnsignedLeb128();
        int method_id = lastIndex + diff;
        Method method = this.getMethod(method_id);
        int method_access_flags = (int)this.in.readUnsignedLeb128();
        int code_off = (int)this.in.readUnsignedLeb128();
        method.setAccessFlags(method_access_flags);
        DexMethodVisitor dmv = cv.visitMethod(method);
        if (dmv != null) {
            Integer parameter_annotation_offset;
            Integer annotation_offset = methodAnnos.get(method_id);
            if (annotation_offset != null) {
                this.in.pushMove(annotation_offset);
                new DexAnnotationReader(this).accept(this.in, dmv);
                this.in.pop();
            }
            if ((parameter_annotation_offset = parameterAnnos.get(method_id)) != null) {
                this.in.pushMove(parameter_annotation_offset);
                int sizeJ = this.in.readIntx();
                for (int j = 0; j < sizeJ; ++j) {
                    int field_annotation_offset = this.in.readIntx();
                    this.in.pushMove(field_annotation_offset);
                    DexAnnotationAble dpav = dmv.visitParamesterAnnotation(j);
                    if (dpav != null) {
                        new DexAnnotationReader(this).accept(this.in, dpav);
                    }
                    this.in.pop();
                }
                this.in.pop();
            }
            if (code_off != 0) {
                this.in.pushMove(code_off);
                DexCodeVisitor dcv = dmv.visitCode();
                if (dcv != null) {
                    try {
                        new DexCodeReader(this, this.in, method).accept(dcv);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error in method:[" + method + "]", e);
                    }
                }
                this.in.pop();
            }
            dmv.visitEnd();
        }
        return method_id;
    }
}

