/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.v3.Ann;

public class V3AnnAdapter
implements AnnotationVisitor {
    Ann ann;
    private static final Logger logger = LoggerFactory.getLogger(V3AnnAdapter.class);

    public static void accept(List<Ann.Item> items, AnnotationVisitor av) {
        if (av == null) {
            return;
        }
        for (Ann.Item item : items) {
            Object v = item.value;
            if (v instanceof Ann) {
                AnnotationVisitor av1;
                Ann a = (Ann)v;
                if (a.type != null) {
                    av1 = av.visitAnnotation(item.name, a.type);
                    V3AnnAdapter.accept(a.items, av1);
                    av1.visitEnd();
                    continue;
                }
                av1 = av.visitArray(item.name);
                V3AnnAdapter.accept(a.items, av1);
                av1.visitEnd();
                continue;
            }
            if (v instanceof Field) {
                Field e = (Field)v;
                av.visitEnum(item.name, e.getType(), e.getName());
                continue;
            }
            if (v instanceof Method) {
                logger.debug("Find Method Annotation:{}", v);
                continue;
            }
            av.visit(item.name, v);
        }
    }

    public V3AnnAdapter(Ann ann) {
        this.ann = ann;
    }

    public void visit(String name, Object value) {
        this.ann.items.add(new Ann.Item(name, value));
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        Ann ann = new Ann(desc, true);
        this.ann.items.add(new Ann.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    public AnnotationVisitor visitArray(String name) {
        Ann ann = new Ann(null, true);
        this.ann.items.add(new Ann.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    public void visitEnd() {
    }

    public void visitEnum(String name, String desc, String value) {
    }
}

