/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.asm.TypeNameAdapter;
import pxb.android.dex2jar.v3.Ann;
import pxb.android.dex2jar.v3.V3AnnAdapter;
import pxb.android.dex2jar.v3.V3FieldAdapter;
import pxb.android.dex2jar.v3.V3MethodAdapter;
import pxb.android.dex2jar.visitors.DexClassVisitor;
import pxb.android.dex2jar.visitors.DexFieldVisitor;
import pxb.android.dex2jar.visitors.DexMethodVisitor;

public class V3ClassAdapter
implements DexClassVisitor {
    protected ClassVisitor cv;
    protected boolean build = false;
    protected int access_flags;
    protected String className;
    protected String superClass;
    protected String[] interfaceNames;
    protected List<Ann> anns = new ArrayList<Ann>();
    Map<String, Integer> accessFlagsMap;
    protected String file;

    protected void build() {
        if (!this.build) {
            String signature = null;
            Iterator<Ann> it = this.anns.iterator();
            while (it.hasNext()) {
                Ann ann = it.next();
                if (!"Ldalvik/annotation/Signature;".equals(ann.type)) continue;
                it.remove();
                for (Ann.Item item : ann.items) {
                    if (!item.name.equals("value")) continue;
                    Ann values = (Ann)item.value;
                    StringBuilder sb = new StringBuilder();
                    for (Ann.Item i : values.items) {
                        sb.append(i.value.toString());
                    }
                    signature = sb.toString();
                }
            }
            this.access_flags |= 0x20;
            this.cv.visit(50, this.access_flags | 0x20, this.className, signature, this.superClass, this.interfaceNames);
            for (Ann ann : this.anns) {
                if (ann.type.equals("Ldalvik/annotation/MemberClasses;")) {
                    for (Ann.Item i : ann.items) {
                        if (!i.name.equals("value")) continue;
                        for (Ann.Item j : ((Ann)i.value).items) {
                            String name = j.value.toString();
                            Integer access = this.accessFlagsMap.get(name);
                            int d = name.lastIndexOf(36);
                            String innerName = name.substring(d + 1, name.length() - 1);
                            this.cv.visitInnerClass(name, this.className, innerName, access == null ? 0 : access);
                        }
                    }
                    continue;
                }
                if (ann.type.equals("Ldalvik/annotation/EnclosingClass;")) {
                    for (Ann.Item i : ann.items) {
                        if (!i.name.equals("value")) continue;
                        Type t = (Type)i.value;
                        int d = this.className.lastIndexOf(36);
                        String innerName = this.className.substring(d + 1, this.className.length() - 1);
                        this.cv.visitInnerClass(this.className, t.toString(), innerName, this.access_flags);
                    }
                    continue;
                }
                if (ann.type.equals("Ldalvik/annotation/InnerClass;")) continue;
                AnnotationVisitor av = this.cv.visitAnnotation(ann.type, ann.visible);
                V3AnnAdapter.accept(ann.items, av);
                av.visitEnd();
            }
            if (this.file != null) {
                this.cv.visitSource(this.file, null);
            }
            this.build = true;
        }
    }

    public V3ClassAdapter(Map<String, Integer> accessFlagsMap, ClassVisitor cv, int access_flags, String className, String superClass, String[] interfaceNames) {
        this.accessFlagsMap = accessFlagsMap;
        this.cv = new TypeNameAdapter(cv);
        this.access_flags = access_flags;
        this.className = className;
        this.superClass = superClass;
        this.interfaceNames = interfaceNames;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, boolean visitable) {
        Ann ann = new Ann(name, visitable);
        this.anns.add(ann);
        return new V3AnnAdapter(ann);
    }

    @Override
    public void visitEnd() {
        this.build();
        this.cv.visitEnd();
    }

    @Override
    public DexFieldVisitor visitField(Field field, Object value) {
        this.build();
        return new V3FieldAdapter(this.cv, field, value);
    }

    @Override
    public DexMethodVisitor visitMethod(Method method) {
        this.build();
        return new V3MethodAdapter(this.cv, method);
    }

    @Override
    public void visitSource(String file) {
        this.file = file;
    }
}

