/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.optimize.B;
import pxb.android.dex2jar.optimize.C;
import pxb.android.dex2jar.optimize.LdcOptimizeAdapter;
import pxb.android.dex2jar.optimize.MethodTransformer;
import pxb.android.dex2jar.v3.Ann;
import pxb.android.dex2jar.v3.V3AnnAdapter;
import pxb.android.dex2jar.v3.V3CodeAdapter;
import pxb.android.dex2jar.visitors.DexAnnotationAble;
import pxb.android.dex2jar.visitors.DexCodeVisitor;
import pxb.android.dex2jar.visitors.DexMethodVisitor;

public class V3MethodAdapter
implements DexMethodVisitor,
Opcodes {
    protected final List<Ann> anns = new ArrayList<Ann>();
    protected final ClassVisitor cv;
    protected final Method method;
    protected final List<Ann>[] paramAnns;
    protected final MethodNode methodNode = new MethodNode();
    private static final Logger log = LoggerFactory.getLogger(V3MethodAdapter.class);

    public V3MethodAdapter(ClassVisitor cv, Method method) {
        this.cv = cv;
        this.method = method;
        List[] paramAnns = new List[method.getType().getParameterTypes().length];
        for (int i = 0; i < paramAnns.length; ++i) {
            paramAnns[i] = new ArrayList();
        }
        this.paramAnns = paramAnns;
        this.methodNode.tryCatchBlocks = new ArrayList();
    }

    private void build() {
        ArrayList<String> exceptions = new ArrayList<String>();
        String signature = null;
        Iterator<Ann> it = this.anns.iterator();
        while (it.hasNext()) {
            Ann values;
            Ann ann = it.next();
            if ("Ldalvik/annotation/Throws;".equals(ann.type)) {
                it.remove();
                for (Ann.Item item : ann.items) {
                    if (!item.name.equals("value")) continue;
                    values = (Ann)item.value;
                    for (Ann.Item i : values.items) {
                        exceptions.add(i.value.toString());
                    }
                }
                continue;
            }
            if (!"Ldalvik/annotation/Signature;".equals(ann.type)) continue;
            it.remove();
            for (Ann.Item item : ann.items) {
                if (!item.name.equals("value")) continue;
                values = (Ann)item.value;
                StringBuilder sb = new StringBuilder();
                for (Ann.Item i : values.items) {
                    sb.append(i.value.toString());
                }
                signature = sb.toString();
            }
        }
        MethodNode methodNode = this.methodNode;
        methodNode.access = this.method.getAccessFlags();
        methodNode.name = this.method.getName();
        methodNode.desc = this.method.getType().getDesc();
        methodNode.signature = signature;
        methodNode.exceptions = exceptions;
        for (Ann ann : this.anns) {
            AnnotationVisitor av = methodNode.visitAnnotation(ann.type, ann.visible);
            V3AnnAdapter.accept(ann.items, av);
            av.visitEnd();
        }
        for (int i = 0; i < this.paramAnns.length; ++i) {
            for (Ann ann : this.paramAnns[i]) {
                AnnotationVisitor av = methodNode.visitParameterAnnotation(i, ann.type, ann.visible);
                V3AnnAdapter.accept(ann.items, av);
                av.visitEnd();
            }
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, boolean visitable) {
        Ann ann = new Ann(name, visitable);
        this.anns.add(ann);
        return new V3AnnAdapter(ann);
    }

    @Override
    public DexCodeVisitor visitCode() {
        return new V3CodeAdapter((MethodVisitor)this.methodNode);
    }

    @Override
    public void visitEnd() {
        this.build();
        MethodNode methodNode = this.methodNode;
        try {
            if (methodNode.instructions.size() > 2) {
                List<MethodTransformer> trs = Arrays.asList(new B(), new C(this.method));
                for (MethodTransformer tr : trs) {
                    tr.transform(methodNode);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error transform method:" + this.method, e);
        }
        MethodVisitor mv = this.cv.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[methodNode.exceptions.size()]));
        if (mv != null) {
            try {
                methodNode.accept((MethodVisitor)new LdcOptimizeAdapter(mv));
            }
            catch (Exception e) {
                throw new RuntimeException("Error visit method:" + this.method, e);
            }
        }
    }

    @Override
    public DexAnnotationAble visitParamesterAnnotation(int index) {
        final List<Ann> panns = this.paramAnns[index];
        return new DexAnnotationAble(){

            @Override
            public AnnotationVisitor visitAnnotation(String name, boolean visitable) {
                Ann ann = new Ann(name, visitable);
                panns.add(ann);
                return new V3AnnAdapter(ann);
            }
        };
    }

    static {
        log.debug("InsnList.check=false");
        InsnList.check = false;
    }
}

