/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.LocalType;
import com.googlecode.dex2jar.ir.ts.Transformer;
import org.objectweb.asm.Type;

public class LocalCurrect
implements Transformer {
    public void transform(IrMethod irMethod) {
        Stmt.E2Stmt s2;
        Stmt.E1Stmt s1;
        for (Stmt st : irMethod.stmts) {
            switch (st.et) {
                case E0: 
                case En: {
                    break;
                }
                case E1: {
                    s1 = (Stmt.E1Stmt)st;
                    this.currectArrayInExpr(s1.op);
                    break;
                }
                case E2: {
                    s2 = (Stmt.E2Stmt)st;
                    if (s2.op1.value.vt == Value.VT.ARRAY) {
                        Value.E2Expr array = (Value.E2Expr)s2.op1.value;
                        this.detectArray(array);
                    }
                    this.currectArrayInExpr(s2.op1);
                    this.currectArrayInExpr(s2.op2);
                }
            }
        }
        for (Stmt st : irMethod.stmts) {
            switch (st.et) {
                case E0: 
                case En: {
                    break;
                }
                case E1: {
                    s1 = (Stmt.E1Stmt)st;
                    this.currectCstInExpr(s1.op);
                    break;
                }
                case E2: {
                    s2 = (Stmt.E2Stmt)st;
                    this.currectCstInExpr(s2.op1);
                    this.currectCstInExpr(s2.op2);
                }
            }
        }
    }

    private void currectArrayInExpr(ValueBox vb) {
        if (vb == null) {
            return;
        }
        Value value = vb.value;
        switch (value.et) {
            case E0: {
                break;
            }
            case E1: {
                this.currectArrayInExpr(((Value.E1Expr)value).op);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                if (e2.vt == Value.VT.ARRAY) {
                    this.detectArray(e2);
                }
                this.currectArrayInExpr(e2.op1);
                this.currectArrayInExpr(e2.op2);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)value;
                for (ValueBox op : en.ops) {
                    this.currectArrayInExpr(op);
                }
                break;
            }
        }
    }

    private Type detectArray(Value.E2Expr e2) {
        Type nT1;
        Type t3;
        Type t1 = LocalType.typeOf((Value)e2);
        Type t2 = LocalType.typeOf((Value)e2.op1.value);
        if (t2 == null && e2.op1.value.vt == Value.VT.ARRAY && (t3 = this.detectArray((Value.E2Expr)e2.op1.value)) != null && t3.getSort() == 9) {
            Type t4 = Type.getType((String)t3.getDescriptor().substring(1));
            LocalType.type((Value)e2, (Type)t4);
            return t4;
        }
        if (t2 != null && t2.getSort() == 9 && !(nT1 = Type.getType((String)t2.getDescriptor().substring(1))).equals((Object)t1)) {
            LocalType.type((Value)e2, (Type)nT1);
            return nT1;
        }
        return t1;
    }

    private void currectCstInExpr(ValueBox vb) {
        if (vb == null) {
            return;
        }
        Value value = vb.value;
        block0 : switch (value.et) {
            case E0: {
                if (value.vt != Value.VT.CONSTANT) break;
                Constant cstExpr = (Constant)value;
                Type type = LocalType.typeOf((Value)value);
                if (type == null) {
                    type = cstExpr.type;
                    if (type == null) {
                        type = Type.INT_TYPE;
                    }
                    LocalType.type((Value)value, (Type)type);
                }
                Object cst = cstExpr.value;
                switch (type.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 6: {
                        if (!(cst instanceof Integer)) break block0;
                        cstExpr.value = Float.valueOf(Float.intBitsToFloat((Integer)cst));
                        break;
                    }
                    case 8: {
                        if (!(cst instanceof Long)) break block0;
                        cstExpr.value = Double.longBitsToDouble((Long)cst);
                        break;
                    }
                    default: {
                        if (!(cst instanceof Integer) || (Integer)cst != 0) break block0;
                        cstExpr.value = Constant.Null;
                        break;
                    }
                }
                break;
            }
            case E1: {
                this.currectCstInExpr(((Value.E1Expr)value).op);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                this.currectCstInExpr(e2.op1);
                this.currectCstInExpr(e2.op2);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)value;
                for (ValueBox op : en.ops) {
                    this.currectCstInExpr(op);
                }
                break;
            }
        }
    }
}

