/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.Util.ExceptionWithContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzedInstruction
implements Comparable<AnalyzedInstruction> {
    protected Instruction instruction;
    protected final int instructionIndex;
    protected final TreeSet<AnalyzedInstruction> predecessors = new TreeSet();
    protected final LinkedList<AnalyzedInstruction> successors = new LinkedList();
    protected final RegisterType[] preRegisterMap;
    protected final RegisterType[] postRegisterMap;
    protected final Instruction originalInstruction;
    protected boolean dead = false;

    public AnalyzedInstruction(Instruction instruction, int instructionIndex, int registerCount) {
        this.instruction = instruction;
        this.originalInstruction = instruction;
        this.instructionIndex = instructionIndex;
        this.postRegisterMap = new RegisterType[registerCount];
        this.preRegisterMap = new RegisterType[registerCount];
        RegisterType unknown = RegisterType.getRegisterType(RegisterType.Category.Unknown, null);
        for (int i = 0; i < registerCount; ++i) {
            this.preRegisterMap[i] = unknown;
            this.postRegisterMap[i] = unknown;
        }
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public int getPredecessorCount() {
        return this.predecessors.size();
    }

    public SortedSet<AnalyzedInstruction> getPredecessors() {
        return Collections.unmodifiableSortedSet(this.predecessors);
    }

    protected boolean addPredecessor(AnalyzedInstruction predecessor) {
        return this.predecessors.add(predecessor);
    }

    protected void addSuccessor(AnalyzedInstruction successor) {
        this.successors.add(successor);
    }

    protected void setDeodexedInstruction(Instruction instruction) {
        assert (this.originalInstruction.opcode.odexOnly());
        this.instruction = instruction;
    }

    protected void restoreOdexedInstruction() {
        assert (this.originalInstruction.opcode.odexOnly());
        this.instruction = this.originalInstruction;
    }

    public int getSuccessorCount() {
        return this.successors.size();
    }

    public List<AnalyzedInstruction> getSuccesors() {
        return Collections.unmodifiableList(this.successors);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public Instruction getOriginalInstruction() {
        return this.originalInstruction;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean isBeginningInstruction() {
        if (this.predecessors.size() == 0) {
            return false;
        }
        return this.predecessors.first().instructionIndex == -1;
    }

    protected boolean mergeRegister(int registerNumber, RegisterType registerType, BitSet verifiedInstructions) {
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType oldRegisterType = this.preRegisterMap[registerNumber];
        RegisterType mergedRegisterType = oldRegisterType.merge(registerType);
        if (mergedRegisterType == oldRegisterType) {
            return false;
        }
        this.preRegisterMap[registerNumber] = mergedRegisterType;
        verifiedInstructions.clear(this.instructionIndex);
        if (!this.setsRegister(registerNumber)) {
            this.postRegisterMap[registerNumber] = mergedRegisterType;
            return true;
        }
        return false;
    }

    protected RegisterType mergePreRegisterTypeFromPredecessors(int registerNumber) {
        RegisterType mergedRegisterType = null;
        for (AnalyzedInstruction predecessor : this.predecessors) {
            RegisterType predecessorRegisterType = predecessor.postRegisterMap[registerNumber];
            assert (predecessorRegisterType != null);
            mergedRegisterType = predecessorRegisterType.merge(mergedRegisterType);
        }
        return mergedRegisterType;
    }

    protected boolean setPostRegisterType(int registerNumber, RegisterType registerType) {
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType oldRegisterType = this.postRegisterMap[registerNumber];
        if (oldRegisterType == registerType) {
            return false;
        }
        this.postRegisterMap[registerNumber] = registerType;
        return true;
    }

    protected boolean isInvokeInit() {
        if (this.instruction == null || !this.instruction.opcode.canInitializeReference()) {
            return false;
        }
        InstructionWithReference instruction = (InstructionWithReference)this.instruction;
        Item item = instruction.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem method = (MethodIdItem)item;
        return method.getMethodName().getStringValue().equals("<init>");
    }

    public boolean setsRegister() {
        return this.instruction.opcode.setsRegister();
    }

    public boolean setsWideRegister() {
        return this.instruction.opcode.setsWideRegister();
    }

    public boolean setsRegister(int registerNumber) {
        if (this.isInvokeInit()) {
            int destinationRegister;
            if (this.instruction instanceof FiveRegisterInstruction) {
                destinationRegister = ((FiveRegisterInstruction)((Object)this.instruction)).getRegisterD();
            } else {
                assert (this.instruction instanceof RegisterRangeInstruction);
                RegisterRangeInstruction rangeInstruction = (RegisterRangeInstruction)((Object)this.instruction);
                assert (rangeInstruction.getRegCount() > 0);
                destinationRegister = rangeInstruction.getStartRegister();
            }
            if (registerNumber == destinationRegister) {
                return true;
            }
            RegisterType preInstructionDestRegisterType = this.getPreInstructionRegisterType(registerNumber);
            if (preInstructionDestRegisterType.category != RegisterType.Category.UninitRef && preInstructionDestRegisterType.category != RegisterType.Category.UninitThis) {
                return false;
            }
            return this.getPreInstructionRegisterType(registerNumber) == preInstructionDestRegisterType;
        }
        if (!this.setsRegister()) {
            return false;
        }
        int destinationRegister = this.getDestinationRegister();
        if (registerNumber == destinationRegister) {
            return true;
        }
        return this.setsWideRegister() && registerNumber == destinationRegister + 1;
    }

    public int getDestinationRegister() {
        if (!this.instruction.opcode.setsRegister()) {
            throw new ExceptionWithContext("Cannot call getDestinationRegister() for an instruction that doesn't store a value");
        }
        return ((SingleRegisterInstruction)((Object)this.instruction)).getRegisterA();
    }

    public int getRegisterCount() {
        return this.postRegisterMap.length;
    }

    public RegisterType getPostInstructionRegisterType(int registerNumber) {
        return this.postRegisterMap[registerNumber];
    }

    public RegisterType getPreInstructionRegisterType(int registerNumber) {
        return this.preRegisterMap[registerNumber];
    }

    @Override
    public int compareTo(AnalyzedInstruction analyzedInstruction) {
        if (this.instructionIndex < analyzedInstruction.instructionIndex) {
            return -1;
        }
        if (this.instructionIndex == analyzedInstruction.instructionIndex) {
            return 0;
        }
        return 1;
    }
}

