/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.DexInternalOpcode;
import pxb.android.dex2jar.DexOpcodeDump;
import pxb.android.dex2jar.DexOpcodes;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexOpcodeAdapter
implements DexOpcodes,
DexInternalOpcode {
    private DexCodeVisitor dcv;
    private Dex dex;
    Map<Integer, Label> labels;
    int offset;

    public DexOpcodeAdapter(Dex dex, DexCodeVisitor dcv2, Map<Integer, Label> labels) {
        this.dex = dex;
        this.dcv = dcv2;
        this.labels = labels;
    }

    public void visit(int opcode, int arg1) {
        switch (opcode) {
            case 1: 
            case 4: 
            case 7: 
            case 33: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                int to = arg1 & 0xF;
                int from = arg1 >> 4 & 0xF;
                this.dcv.visitInInsn(opcode, to, from);
                break;
            }
            case 40: {
                this.dcv.visitJumpInsn(opcode, this.labels.get(this.offset + (byte)arg1));
                break;
            }
            case 14: {
                this.dcv.visitInsn(opcode);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 29: 
            case 30: 
            case 39: {
                this.dcv.visitVarInsn(opcode, arg1);
                break;
            }
            case 18: {
                int b = arg1;
                int reg = b & 0xF;
                int value = b >> 4 & 0xF;
                if ((value & 8) != 0) {
                    value = -((Integer.reverse(value) & 7) + 1);
                }
                this.dcv.visitLdcInsn(opcode, value, reg);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode :[0x%04x] = %s", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    public void visit(int opcode, int arg1, int arg2) {
        switch (opcode) {
            case 31: 
            case 34: {
                String type = this.dex.getType(arg2);
                this.dcv.visitTypeInsn(opcode, type, arg1);
                break;
            }
            case 32: {
                String type = this.dex.getType(arg2);
                this.dcv.visitTypeInsn(opcode, type, arg1 & 0xF, arg1 >> 4 & 0xF);
                break;
            }
            case 28: {
                String type = this.dex.getType(arg2);
                this.dcv.visitLdcInsn(opcode, Type.getType((String)type), arg1);
                break;
            }
            case 26: {
                String string = this.dex.getString(arg2);
                this.dcv.visitLdcInsn(opcode, string, arg1);
                break;
            }
            case 21: {
                int intV = arg2 << 16;
                this.dcv.visitLdcInsn(opcode, intV, arg1);
                break;
            }
            case 19: {
                int intV = arg2 & 0xFFFF;
                this.dcv.visitLdcInsn(opcode, intV, arg1);
                break;
            }
            case 22: {
                long longV = (long)arg2 & 0xFFFFL;
                this.dcv.visitLdcInsn(opcode, longV, arg1);
                break;
            }
            case 25: {
                long longV = (long)arg2 << 48;
                this.dcv.visitLdcInsn(opcode, longV, arg1);
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.dcv.visitJumpInsn(opcode, this.labels.get(this.offset + arg2), arg1);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int reg1 = arg1 & 0xF;
                int reg2 = arg1 >> 4 & 0xF;
                this.dcv.visitJumpInsn(opcode, this.labels.get(this.offset + arg2), reg1, reg2);
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                Field field = this.dex.getField(arg2);
                this.dcv.visitFieldInsn(opcode, field, arg1 & 0xF, arg1 >> 4 & 0xF);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                Field field = this.dex.getField(arg2);
                this.dcv.visitFieldInsn(opcode, field, arg1, -1);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                int value = arg1;
                int index = arg2 >> 8 & 0xFF;
                int array = arg2 & 0xFF;
                this.dcv.visitArrayInsn(opcode, value, array, index);
                break;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                this.dcv.visitInInsn(opcode, arg1, arg2 & 0xFF, (byte)(arg2 >> 8 & 0xFF));
                break;
            }
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.dcv.visitInInsn(opcode, arg1 & 0xF, arg1 >> 4 & 0xF, (short)arg2);
                break;
            }
            case 35: {
                int a = arg1 & 0xF;
                int dem = arg1 >> 4 & 0xF;
                String type = this.dex.getType(arg2);
                this.dcv.visitArrayInsn(opcode, type, a, dem);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.dcv.visitInInsn(opcode, arg1, arg2 >> 8 & 0xFF, arg2 & 0xFF);
                break;
            }
            case 41: {
                this.dcv.visitJumpInsn(opcode, this.labels.get(this.offset + arg2));
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                this.dcv.visitInInsn(opcode, arg1, arg2 & 0xFF);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode :[0x%04x] = %s", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    public void visit(int opcode, int arg1, int arg2, int arg3) {
        switch (opcode) {
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                Method m = this.dex.getMethod(arg2);
                int[] args = DexOpcodeAdapter.getValues(arg1, arg3);
                args = this.filter(m, args);
                this.dcv.visitMethodInsn(opcode, m, args);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                int[] args = new int[arg1];
                int i = 0;
                while (i < arg1) {
                    args[i] = arg3 + i;
                    ++i;
                }
                Method m = this.dex.getMethod(arg2);
                args = this.filter(m, args);
                this.dcv.visitMethodInsn(opcode - 6, m, args);
                break;
            }
            case 20: {
                int intV = arg2 & 0xFFFF | arg3 << 16 & 0xFFFF0000;
                this.dcv.visitLdcInsn(opcode, intV, arg1);
                break;
            }
            case 23: {
                long longV = arg3 << 16 | arg2;
                this.dcv.visitLdcInsn(opcode, longV, arg1);
                break;
            }
            case 36: {
                this.dcv.visitFilledNewArrayIns(opcode, this.dex.getType(arg2), DexOpcodeAdapter.getValues(arg1, arg3));
                break;
            }
            case 37: {
                int[] args = new int[arg1];
                int i = 0;
                while (i < arg1) {
                    args[i] = arg3 + i;
                    ++i;
                }
                this.dcv.visitFilledNewArrayIns(36, this.dex.getType(arg2), args);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode :[0x%04x] = %s", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    private int[] filter(Method m, int[] args) {
        String[] types = m.getType().getParameterTypes();
        if (types.length == 0 || types.length == args.length) {
            return args;
        }
        int index = args.length - 1;
        int i = args.length - 1;
        int j = types.length - 1;
        while (j >= 0) {
            String type = types[j];
            if ("J".equals(type) || "D".equals(type)) {
                // empty if block
            }
            int n = index--;
            int n2 = --i;
            --i;
            args[n] = args[n2];
            --j;
        }
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                args[index--] = args[i--];
                break;
            }
            default: {
                throw new RuntimeException("Should never happen.");
            }
        }
        int start = index + 1;
        if (start == 0) {
            return args;
        }
        int length = args.length - start;
        int[] nArgs = new int[length];
        System.arraycopy(args, start, nArgs, 0, length);
        return nArgs;
    }

    private static int[] getValues(int arg1, int value) {
        int size = arg1 >> 4 & 0xF;
        int[] a = new int[size];
        int i = 0;
        while (i < size && i < 4) {
            a[i] = value & 0xF;
            value >>= 4;
            ++i;
        }
        if (size == 5) {
            a[4] = arg1 & 0xF;
        }
        return a;
    }

    public void visitOffset(int i) {
        this.offset = i;
    }
}

