/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import oms.GameEngine.ACTStruct;
import oms.GameEngine.GameCanvas;
import oms.GameEngine.GameMath;
import oms.GameEngine.PackageManager;
import oms.GameEngine.RESApp;
import oms.GameEngine.SpriteDEF;
import oms.GameEngine.SpriteResDEF;
import oms.GameEngine.SpriteResSeg;

public class SpriteManager {
    private ACTStruct ACTStructInfo;
    private SpriteDEF[] Sprite;
    private SpriteResDEF[] SpriteRes;
    private SpriteRESACTINFO[] SpriteResACTInfo;
    private boolean bLoadingSpriteRes;
    private Matrix cMatrix;
    private SpriteACTFILE cSpriteACTFile;
    private int mACTLibBeg = (int)null;
    private Context mContext;
    private boolean mIsLogOut = true;
    private long nCurBMPRamSize = 0L;
    private int nCurFlushSpriteNum;
    private int nCurSegLoadedSpriteNum;
    private int nCurSpriteFileNum;
    private int nMaxSpriteNum;
    private int nMaxSpriteResNum;
    private int nShowSpriteNum;
    private Rect nViewRc;
    public SpriteResSeg[] pSpriteResSegInfo;

    public SpriteManager(Context context, int n2, int n3) {
        Matrix matrix;
        Rect rect;
        this.mContext = context;
        this.Init();
        this.InitSpriteRes(n2);
        this.InitSprite(n3);
        this.InitSpriteACTFile();
        this.nViewRc = rect = GameCanvas.GetViewRect();
        this.cMatrix = matrix = new Matrix();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int GetBitmapSize(Bitmap bitmap) {
        Bitmap.Config config;
        int n2 = 1;
        Bitmap.Config config2 = bitmap.getConfig();
        if (config2 == (config = Bitmap.Config.ALPHA_8)) {
            n2 = 1;
        } else {
            Bitmap.Config config3;
            Bitmap.Config config4 = bitmap.getConfig();
            if (config4 == (config3 = Bitmap.Config.RGB_565)) {
                n2 = 2;
            } else {
                Bitmap.Config config5;
                Bitmap.Config config6 = bitmap.getConfig();
                if (config6 == (config5 = Bitmap.Config.ARGB_4444)) {
                    n2 = 2;
                } else {
                    Bitmap.Config config7;
                    Bitmap.Config config8 = bitmap.getConfig();
                    if (config8 == (config7 = Bitmap.Config.ARGB_8888)) {
                        n2 = 4;
                    }
                }
            }
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        return n3 * n4 * n2 + 128;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void GetFileHead(int n2) {
        int n3 = 2;
        Object var3_3 = null;
        int n4 = n2 * 4;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        this.ACTStructInfo.FileNum = (int)var3_3;
        Object var6_6 = null;
        while (true) {
            void var6_7;
            int n5;
            if (var6_6 >= n3) break;
            int n6 = n4 + var6_6;
            int n7 = byArray[n6] & 0xFF;
            Object var9_11 = var6_6 * 8;
            int n8 = n7 << var9_11;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileNum = n5 = aCTStruct.FileNum + n8;
            ++var6_7;
        }
        this.ACTStructInfo.FileIndexAddr = (int)var3_3;
        var6_6 = null;
        while (var6_6 < n3) {
            void var6_8;
            int n9;
            int n10 = n4 + 2 + var6_6;
            int n11 = byArray[n10] & 0xFF;
            Object var15_17 = var6_6 * 8;
            int n12 = n11 << var15_17;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileIndexAddr = n9 = aCTStruct.FileIndexAddr + n12;
            ++var6_8;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void GetFileHead(RESApp rESApp, int n2) {
        int n3 = 2;
        Object var4_4 = null;
        byte[] byArray = new byte[4];
        int n4 = n2 * 4;
        rESApp.ResRead(byArray, n4, 4);
        this.ACTStructInfo.FileNum = (int)var4_4;
        Object var7_7 = null;
        while (true) {
            void var7_8;
            int n5;
            if (var7_7 >= n3) break;
            int n6 = byArray[var7_7] & 0xFF;
            Object var9_11 = var7_7 * 8;
            int n7 = n6 << var9_11;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileNum = n5 = aCTStruct.FileNum + n7;
            ++var7_8;
        }
        this.ACTStructInfo.FileIndexAddr = (int)var4_4;
        var7_7 = null;
        while (var7_7 < n3) {
            void var7_9;
            int n8;
            int n9 = var7_7 + 2;
            int n10 = byArray[n9] & 0xFF;
            Object var15_17 = var7_7 * 8;
            int n11 = n10 << var15_17;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileIndexAddr = n8 = aCTStruct.FileIndexAddr + n11;
            ++var7_9;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void GetSpriteHead(int n2) {
        int n3 = 4;
        Object var3_3 = null;
        int n4 = n2 * 8;
        int n5 = this.ACTStructInfo.FileIndexAddr;
        int n6 = n4 + n5;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        this.ACTStructInfo.SpriteNum = (int)var3_3;
        Object var8_8 = null;
        while (true) {
            void var8_9;
            int n7;
            if (var8_8 >= n3) break;
            int n8 = n6 + var8_8;
            int n9 = byArray[n8] & 0xFF;
            Object var11_13 = var8_8 * 8;
            int n10 = n9 << var11_13;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.SpriteNum = n7 = aCTStruct.SpriteNum + n10;
            ++var8_9;
        }
        this.ACTStructInfo.SpriteIndexAddr = (int)var3_3;
        var8_8 = null;
        while (var8_8 < n3) {
            void var8_10;
            int n11;
            int n12 = n6 + var8_8;
            var16_18 += 4;
            int n13 = byArray[n12] & 0xFF;
            Object var18_20 = var8_8 * 8;
            int n14 = n13 << var18_20;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.SpriteIndexAddr = n11 = aCTStruct.SpriteIndexAddr + n14;
            ++var8_10;
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private int GetSpriteResID(int n2) {
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        int n3 = n2 * 20;
        int n4 = this.ACTStructInfo.SpriteIndexAddr;
        int n5 = n3 + n4;
        int n6 = null;
        Object var7_8 = null;
        while (var7_8 < 4) {
            void var7_9;
            int n7 = n5 + var7_8;
            int n8 = byArray[n7] & 0xFF;
            Object var10_12 = var7_8 * 8;
            int n9 = n8 << var10_12;
            Object var6_7 = n6 + n9;
            ++var7_9;
        }
        return n6;
    }

    private void Init() {
        this.SpriteRes = null;
        this.nMaxSpriteResNum = (int)null;
        this.SpriteResACTInfo = null;
        this.nCurSpriteFileNum = (int)null;
        this.bLoadingSpriteRes = null;
        this.pSpriteResSegInfo = null;
        this.nCurSegLoadedSpriteNum = (int)null;
        this.ACTStructInfo = null;
        this.Sprite = null;
        this.nMaxSpriteNum = (int)null;
        this.nShowSpriteNum = (int)null;
        this.nCurFlushSpriteNum = (int)null;
        this.nCurBMPRamSize = 0L;
        this.mACTLibBeg = (int)null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void ReadSpriteResInfo(int n2, int n3) {
        int n4;
        short s2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        long l2;
        int n14;
        int n15 = 65536;
        int n16 = 2;
        Object var5_5 = null;
        int n17 = 32768;
        Bitmap bitmap = null;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        int n18 = n2 * 20;
        int n19 = this.ACTStructInfo.SpriteIndexAddr;
        int n20 = n18 + n19;
        this.ACTStructInfo.ResID = (int)var5_5;
        Object var12_12 = null;
        while (true) {
            void var12_13;
            int n21;
            if (var12_12 >= 4) {
                n20 += 4;
                break;
            }
            int n22 = n20 + var12_12;
            int n23 = byArray[n22] & 0xFF;
            Object var45_24 = var12_12 * 8;
            int n24 = n23 << var45_24;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ResID = n21 = aCTStruct.ResID + n24;
            ++var12_13;
        }
        this.ACTStructInfo.CenterX = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_14;
            int n25;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.CenterX & n17) == n17) {
                    int n26;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n27 = this.ACTStructInfo.CenterX;
                    aCTStruct.CenterX = n26 = -(n15 - n27);
                }
                n20 += 2;
                break;
            }
            int n28 = n20 + var12_12;
            int n29 = byArray[n28] & 0xFF;
            Object var51_30 = var12_12 * 8;
            int n30 = n29 << var51_30;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.CenterX = n25 = aCTStruct.CenterX + n30;
            ++var12_14;
        }
        this.ACTStructInfo.CenterY = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_15;
            int n31;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.CenterY & n17) == n17) {
                    int n32;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n33 = this.ACTStructInfo.CenterY;
                    aCTStruct.CenterY = n32 = -(n15 - n33);
                }
                n20 += 2;
                break;
            }
            int n34 = n20 + var12_12;
            int n35 = byArray[n34] & 0xFF;
            Object var57_39 = var12_12 * 8;
            int n36 = n35 << var57_39;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.CenterY = n31 = aCTStruct.CenterY + n36;
            ++var12_15;
        }
        this.ACTStructInfo.XHitL = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_16;
            int n37;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.XHitL & n17) == n17) {
                    int n38;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n39 = this.ACTStructInfo.XHitL;
                    aCTStruct.XHitL = n38 = -(n15 - n39);
                }
                n20 += 2;
                break;
            }
            int n40 = n20 + var12_12;
            int n41 = byArray[n40] & 0xFF;
            Object var63_51 = var12_12 * 8;
            int n42 = n41 << var63_51;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.XHitL = n37 = aCTStruct.XHitL + n42;
            ++var12_16;
        }
        this.ACTStructInfo.XHitR = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_17;
            int n43;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.XHitR & n17) == n17) {
                    int n44;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n45 = this.ACTStructInfo.XHitR;
                    aCTStruct.XHitR = n44 = -(n15 - n45);
                }
                n20 += 2;
                break;
            }
            int n46 = n20 + var12_12;
            int n47 = byArray[n46] & 0xFF;
            Object var69_57 = var12_12 * 8;
            int n48 = n47 << var69_57;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.XHitR = n43 = aCTStruct.XHitR + n48;
            ++var12_17;
        }
        this.ACTStructInfo.YHitU = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_18;
            int n49;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.YHitU & n17) == n17) {
                    int n50;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n51 = this.ACTStructInfo.YHitU;
                    aCTStruct.YHitU = n50 = -(n15 - n51);
                }
                n20 += 2;
                break;
            }
            int n52 = n20 + var12_12;
            int n53 = byArray[n52] & 0xFF;
            Object var75_66 = var12_12 * 8;
            int n54 = n53 << var75_66;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.YHitU = n49 = aCTStruct.YHitU + n54;
            ++var12_18;
        }
        this.ACTStructInfo.YHitD = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_19;
            int n55;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.YHitD & n17) == n17) {
                    int n56;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n57 = this.ACTStructInfo.YHitD;
                    aCTStruct.YHitD = n56 = -(n15 - n57);
                }
                n20 += 2;
                break;
            }
            int n58 = n20 + var12_12;
            int n59 = byArray[n58] & 0xFF;
            Object var81_75 = var12_12 * 8;
            int n60 = n59 << var81_75;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.YHitD = n55 = aCTStruct.YHitD + n60;
            ++var12_19;
        }
        this.ACTStructInfo.ZHitF = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_20;
            int n61;
            if (var12_12 >= n16) {
                if ((this.ACTStructInfo.ZHitF & n17) == n17) {
                    int n62;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n63 = this.ACTStructInfo.ZHitF;
                    aCTStruct.ZHitF = n62 = -(n15 - n63);
                }
                n20 += 2;
                break;
            }
            int n64 = n20 + var12_12;
            int n65 = byArray[n64] & 0xFF;
            Object var87_84 = var12_12 * 8;
            int n66 = n65 << var87_84;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ZHitF = n61 = aCTStruct.ZHitF + n66;
            ++var12_20;
        }
        this.ACTStructInfo.ZHitB = (int)var5_5;
        var12_12 = null;
        while (true) {
            void var12_21;
            int n67;
            if (var12_12 >= n16) {
                int n68;
                if ((this.ACTStructInfo.ZHitB & n17) == n17) {
                    int n69;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n70 = this.ACTStructInfo.ZHitB;
                    aCTStruct.ZHitB = n69 = -(n15 - n70);
                }
                n20 += 2;
                Resources resources = this.mContext.getResources();
                bitmap = BitmapFactory.decodeResource((Resources)resources, (int)(n68 = this.ACTStructInfo.ResID));
                if (bitmap == null) {
                    Context context = this.mContext;
                    int n71 = this.ACTStructInfo.ResID;
                    bitmap = PackageManager.createBitmap(context, n71);
                }
                if (bitmap == null) return;
                n14 = this.ACTStructInfo.ResID & 0xFFFF;
                int n72 = this.nMaxSpriteResNum;
                if (n14 < n72) break;
                return;
            }
            int n73 = n20 + var12_12;
            int n74 = byArray[n73] & 0xFF;
            Object var93_93 = var12_12 * 8;
            int n75 = n74 << var93_93;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ZHitB = n67 = aCTStruct.ZHitB + n75;
            ++var12_21;
        }
        if (this.mIsLogOut) {
            StringBuilder stringBuilder = new StringBuilder("ResID: ");
            int n76 = this.ACTStructInfo.ResID;
            String string2 = stringBuilder.append(n76).toString();
            Log.v((String)"GameEngine", (String)string2);
            StringBuilder stringBuilder2 = new StringBuilder("Width: ");
            int n77 = bitmap.getWidth();
            String string3 = stringBuilder2.append(n77).toString();
            Log.v((String)"GameEngine", (String)string3);
            StringBuilder stringBuilder3 = new StringBuilder("Height: ");
            int n78 = bitmap.getHeight();
            String string4 = stringBuilder3.append(n78).toString();
            Log.v((String)"GameEngine", (String)string4);
            StringBuilder stringBuilder4 = new StringBuilder("OPtions: ");
            Bitmap.Config config = bitmap.getConfig();
            String string5 = stringBuilder4.append(config).toString();
            Log.v((String)"GameEngine", (String)string5);
            StringBuilder stringBuilder5 = new StringBuilder("Picture use RAM: ");
            long l3 = this.nCurBMPRamSize / 1024L;
            String string6 = stringBuilder5.append(l3).append(" KBytes").toString();
            Log.v((String)"GameEngine", (String)string6);
        }
        long l4 = this.nCurBMPRamSize;
        long l5 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l4 + l5;
        this.SpriteRes[n14].Sprite = bitmap;
        SpriteResDEF spriteResDEF = this.SpriteRes[n14];
        spriteResDEF.SpriteResID = n13 = this.ACTStructInfo.ResID;
        SpriteResDEF spriteResDEF2 = this.SpriteRes[n14];
        spriteResDEF2.SpriteCenterX = n12 = this.ACTStructInfo.CenterX;
        SpriteResDEF spriteResDEF3 = this.SpriteRes[n14];
        spriteResDEF3.SpriteCenterY = n11 = this.ACTStructInfo.CenterY;
        SpriteResDEF spriteResDEF4 = this.SpriteRes[n14];
        spriteResDEF4.SpriteXHitL = n10 = this.ACTStructInfo.XHitL;
        SpriteResDEF spriteResDEF5 = this.SpriteRes[n14];
        spriteResDEF5.SpriteXHitR = n9 = this.ACTStructInfo.XHitR;
        SpriteResDEF spriteResDEF6 = this.SpriteRes[n14];
        spriteResDEF6.SpriteYHitU = n8 = this.ACTStructInfo.YHitU;
        SpriteResDEF spriteResDEF7 = this.SpriteRes[n14];
        spriteResDEF7.SpriteYHitD = n7 = this.ACTStructInfo.YHitD;
        SpriteResDEF spriteResDEF8 = this.SpriteRes[n14];
        spriteResDEF8.SpriteZHitF = n6 = this.ACTStructInfo.ZHitF;
        SpriteResDEF spriteResDEF9 = this.SpriteRes[n14];
        spriteResDEF9.SpriteZHitB = n5 = this.ACTStructInfo.ZHitB;
        SpriteRESACTINFO spriteRESACTINFO = this.SpriteResACTInfo[n14];
        spriteRESACTINFO.RESACTIdx = s2 = (short)n3;
        SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n3];
        int n79 = spriteResSeg.SegSize;
        int n80 = bitmap.getWidth();
        int n81 = bitmap.getHeight();
        int n82 = n80 * n81 * 4 + 128;
        spriteResSeg.SegSize = n4 = n79 + n82;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        SpriteManager spriteManager;
        int n9;
        int n10;
        int n11;
        SpriteManager spriteManager2;
        int n12;
        int n13;
        int n14;
        int n15;
        boolean bl;
        int n16;
        SpriteManager spriteManager3;
        int n17;
        int n18;
        int n19;
        SpriteManager spriteManager4;
        int n20;
        int n21;
        boolean bl2;
        int n22 = this.GetSpriteXHitL(n2);
        boolean bl3 = GameMath.CHKTouch(n22, (bl2 = n3) ? 1 : 0, n21 = this.GetSpriteXHitR(n2), n20 = (spriteManager4 = this).GetSpriteXHitL(n19 = n5), n18 = n6, n17 = (spriteManager3 = this).GetSpriteXHitR(n16 = n5));
        if (bl3 && (bl = GameMath.CHKTouch(n15 = this.GetSpriteYHitU(n2), n14 = n4, n13 = this.GetSpriteYHitD(n2), n12 = (spriteManager2 = this).GetSpriteYHitU(n11 = n5), n10 = n7, n9 = (spriteManager = this).GetSpriteYHitD(n8 = n5)))) {
            return bl2;
        }
        Object var15_20 = null;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        SpriteManager spriteManager;
        int n12;
        int n13;
        int n14;
        SpriteManager spriteManager2;
        int n15;
        int n16;
        int n17;
        int n18;
        boolean bl;
        int n19;
        SpriteManager spriteManager3;
        int n20;
        int n21;
        int n22 = n4;
        int n23 = n2;
        int n24 = n5;
        SpriteManager spriteManager4 = this;
        int n25 = n8;
        int n26 = spriteManager4.GetSpriteXHitL(n25);
        boolean bl2 = GameMath.CHKTouch(n22, n23, n24, n26, n21 = n9, n20 = (spriteManager3 = this).GetSpriteXHitR(n19 = n8));
        if (bl2 && (bl = GameMath.CHKTouch(n18 = n6, n17 = n3, n16 = n7, n15 = (spriteManager2 = this).GetSpriteYHitU(n14 = n8), n13 = n10, n12 = (spriteManager = this).GetSpriteYHitD(n11 = n8)))) {
            return n22 != 0;
        }
        Object var16_21 = null;
        return n22 != 0;
    }

    /*
     * WARNING - void declaration
     */
    public void ClearACT() {
        int n2 = 1065353216;
        int n3 = null;
        while (true) {
            void var2_3;
            int n4;
            if (n3 >= (n4 = this.nShowSpriteNum)) {
                this.nShowSpriteNum = (int)null;
                return;
            }
            this.Sprite[n3].SpriteResID = (short)-1;
            this.Sprite[n3].Rotate = (float)null;
            this.Sprite[n3].ScaleX = n2;
            this.Sprite[n3].ScaleY = n2;
            ++var2_3;
        }
    }

    public void CloseSpriteACTFile() {
        this.cSpriteACTFile.release();
    }

    /*
     * WARNING - void declaration
     */
    public void FreeACT(int n2) {
        int n3 = -1;
        int n4 = this.mACTLibBeg;
        n2 += n4;
        int n5 = null;
        while (true) {
            void var4_5;
            int n6;
            if (n5 >= (n6 = this.nMaxSpriteResNum)) {
                if (this.mIsLogOut) {
                    StringBuilder stringBuilder = new StringBuilder("Picture use RAM: ");
                    long l2 = this.nCurBMPRamSize / 1024L;
                    String string2 = stringBuilder.append(l2).append(" KBytes").toString();
                    Log.v((String)"GameEngine", (String)string2);
                }
                System.gc();
                return;
            }
            if (this.SpriteResACTInfo[n5].RESACTIdx == n2) {
                if (this.SpriteRes[n5].Sprite != null) {
                    int n7;
                    long l3;
                    Bitmap bitmap = this.SpriteRes[n5].Sprite;
                    int n8 = this.GetBitmapSize(bitmap);
                    long l4 = this.nCurBMPRamSize;
                    long l5 = n8;
                    this.nCurBMPRamSize = l3 = l4 - l5;
                    SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
                    spriteResSeg.SegSize = n7 = spriteResSeg.SegSize - n8;
                    this.pSpriteResSegInfo[n2].SegIdx = (short)n3;
                    this.SpriteRes[n5].Sprite.recycle();
                }
                this.SpriteRes[n5].Sprite = null;
                this.SpriteRes[n5].SpriteResID = n3;
                this.SpriteResACTInfo[n5].RESACTIdx = (short)n3;
            }
            ++var4_5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void FreeACT(int n2, int n3) {
        short s2 = -1;
        if (n3 < 2130837504) {
            return;
        }
        int n4 = this.mACTLibBeg;
        n2 += n4;
        int n5 = this.nMaxSpriteResNum;
        if ((n3 &= 0xFFFF) < n5 && this.SpriteResACTInfo[n3].RESACTIdx != s2) {
            if (this.SpriteRes[n3].Sprite != null) {
                int n6;
                long l2;
                Bitmap bitmap = this.SpriteRes[n3].Sprite;
                int n7 = this.GetBitmapSize(bitmap);
                long l3 = this.nCurBMPRamSize;
                long l4 = n7;
                this.nCurBMPRamSize = l2 = l3 - l4;
                SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
                spriteResSeg.SegSize = n6 = spriteResSeg.SegSize - n7;
                this.SpriteRes[n3].Sprite.recycle();
            }
            this.SpriteRes[n3].Sprite = null;
            this.SpriteRes[n3].SpriteResID = s2;
            this.SpriteResACTInfo[n3].RESACTIdx = s2;
        }
        if (!this.mIsLogOut) return;
        StringBuilder stringBuilder = new StringBuilder("Picture use RAM: ");
        long l5 = this.nCurBMPRamSize / 1024L;
        String string2 = stringBuilder.append(l5).append(" KBytes").toString();
        Log.v((String)"GameEngine", (String)string2);
    }

    /*
     * WARNING - void declaration
     */
    public void FreeAllACT() {
        int n2 = -1;
        int n3 = null;
        while (true) {
            void var2_3;
            int n4;
            if (n3 >= (n4 = this.nMaxSpriteResNum)) {
                this.nCurBMPRamSize = 0L;
                System.gc();
                return;
            }
            if (this.SpriteRes[n3].Sprite != null) {
                this.SpriteRes[n3].Sprite.recycle();
            }
            this.SpriteRes[n3].Sprite = null;
            this.SpriteRes[n3].SpriteResID = n2;
            this.SpriteResACTInfo[n3].RESACTIdx = (short)n2;
            this.pSpriteResSegInfo[n3].SegSize = (int)null;
            this.pSpriteResSegInfo[n3].SegIdx = (short)n2;
            ++var2_3;
        }
    }

    public int GetACTCount(int n2, int n3) {
        int n4 = this.mACTLibBeg;
        int n5 = n2 + n4;
        Context context = this.mContext;
        RESApp rESApp = new RESApp(context);
        rESApp.OpenRes(n3);
        this.GetFileHead(rESApp, n2);
        rESApp.CloseRes();
        return this.ACTStructInfo.FileNum;
    }

    public long GetBMPRamSize() {
        return this.nCurBMPRamSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap GetSpriteBitmap(int n2) {
        int n3 = 2130837504;
        if (n2 < n3) {
            return 0;
        }
        int n4 = n2 & 0xFFFF;
        Bitmap bitmap = this.SpriteRes[n4].Sprite;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long GetSpriteSegSize(int n2) {
        int n3 = this.nMaxSpriteResNum;
        if (n2 < n3) return this.pSpriteResSegInfo[n2].SegSize;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitL(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteXHitL;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitR(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteXHitR;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitD(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteYHitD;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitU(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteYHitU;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitB(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteZHitB;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitF(int n2) {
        int n3 = 65535;
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n4 = n2 & n3;
        int n5 = spriteRESACTINFOArray[n4].RESACTIdx;
        if (n5 == -1) return (int)spriteRESACTINFOArray;
        int n6 = n2 & n3;
        n5 = this.SpriteRes[n6].SpriteZHitF;
        return (int)spriteRESACTINFOArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitACT(int n2, int n3) {
        short s2;
        int n4 = this.mACTLibBeg;
        int n5 = this.nMaxSpriteResNum;
        if ((n2 += n4) >= n5) {
            return;
        }
        if (this.pSpriteResSegInfo[n2].SegIdx == n2) return;
        this.InitSpriteResInfo(n3, n2);
        this.CloseSpriteACTFile();
        SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
        spriteResSeg.SegIdx = s2 = (short)n2;
    }

    public void InitSprite(int n2) {
        this.nShowSpriteNum = (int)null;
        this.nMaxSpriteNum = n2;
        if (this.nMaxSpriteNum == 0) {
            this.nMaxSpriteNum = 1;
        }
        SpriteDEF[] spriteDEFArray = new SpriteDEF[this.nMaxSpriteNum];
        this.Sprite = spriteDEFArray;
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.nMaxSpriteNum)) {
            SpriteDEF spriteDEF;
            SpriteDEF[] spriteDEFArray2 = this.Sprite;
            spriteDEFArray2[n3] = spriteDEF = new SpriteDEF();
            ++n3;
        }
        return;
    }

    public void InitSpriteACTFile() {
        SpriteACTFILE spriteACTFILE;
        this.cSpriteACTFile = spriteACTFILE = new SpriteACTFILE();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitSpriteRes(int n2) {
        Object var2_2 = null;
        this.nMaxSpriteResNum = n2;
        if (n2 <= 0) {
            this.nMaxSpriteResNum = 1;
        }
        SpriteResDEF[] spriteResDEFArray = new SpriteResDEF[this.nMaxSpriteResNum];
        this.SpriteRes = spriteResDEFArray;
        SpriteRESACTINFO[] spriteRESACTINFOArray = new SpriteRESACTINFO[this.nMaxSpriteResNum];
        this.SpriteResACTInfo = spriteRESACTINFOArray;
        int n3 = 0;
        while (true) {
            SpriteRESACTINFO spriteRESACTINFO;
            SpriteResDEF spriteResDEF;
            int n4;
            if (n3 >= (n4 = this.nMaxSpriteResNum)) break;
            SpriteResDEF[] spriteResDEFArray2 = this.SpriteRes;
            spriteResDEFArray2[n3] = spriteResDEF = new SpriteResDEF();
            SpriteRESACTINFO[] spriteRESACTINFOArray2 = this.SpriteResACTInfo;
            spriteRESACTINFOArray2[n3] = spriteRESACTINFO = new SpriteRESACTINFO();
            ++n3;
        }
        SpriteResSeg[] spriteResSegArray = new SpriteResSeg[this.nMaxSpriteResNum];
        this.pSpriteResSegInfo = spriteResSegArray;
        n3 = 0;
        while (true) {
            SpriteResSeg spriteResSeg;
            int n5;
            if (n3 >= (n5 = this.nMaxSpriteResNum)) {
                ACTStruct aCTStruct;
                this.ACTStructInfo = aCTStruct = new ACTStruct();
                this.bLoadingSpriteRes = var2_2;
                this.nCurSpriteFileNum = (int)var2_2;
                return;
            }
            SpriteResSeg[] spriteResSegArray2 = this.pSpriteResSegInfo;
            spriteResSegArray2[n3] = spriteResSeg = new SpriteResSeg();
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void InitSpriteResInfo(int n2, int n3) {
        this.nCurSegLoadedSpriteNum = (int)null;
        if (!this.LoadSpriteACTFile(n2)) {
            return;
        }
        this.GetFileHead(n3);
        int n4 = 0;
        int n5;
        block0: while (n4 < (n5 = this.ACTStructInfo.FileNum)) {
            this.GetSpriteHead(n4);
            int n6 = null;
            while (true) {
                int n7;
                if (n6 >= (n7 = this.ACTStructInfo.SpriteNum)) {
                    int n8;
                    int n9 = this.nCurSegLoadedSpriteNum;
                    int n10 = this.ACTStructInfo.SpriteNum;
                    this.nCurSegLoadedSpriteNum = n8 = n9 + n10;
                    ++n4;
                    continue block0;
                }
                int n11 = this.GetSpriteResID(n6) & 0xFFFF;
                if (this.SpriteResACTInfo[n11].RESACTIdx == -1) {
                    this.ReadSpriteResInfo(n6, n3);
                }
                ++n6;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitSpriteResInfo(int n2, int n3, int n4) {
        block6: {
            int n5;
            Object var4_4 = null;
            if (!this.LoadSpriteACTFile(n2)) break block6;
            this.GetFileHead(n3);
            block0: for (int i2 = 0; i2 < (n5 = this.ACTStructInfo.FileNum); ++i2) {
                this.GetSpriteHead(i2);
                int n6 = null;
                while (true) {
                    block8: {
                        block7: {
                            int n7;
                            if (n6 >= (n7 = this.ACTStructInfo.SpriteNum)) break block7;
                            if (this.GetSpriteResID(n6) != n4) break block8;
                            if (this.SpriteResACTInfo[n4 &= 0xFFFF].RESACTIdx == -1) {
                                this.ReadSpriteResInfo(n6, n3);
                            }
                            boolean bl = true;
                        }
                        if (var4_4 != null) break block0;
                        continue block0;
                    }
                    ++n6;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitSpriteResInfo(int n2, int n3, int n4, int n5) {
        if (this.LoadSpriteACTFile(n2)) {
            this.GetFileHead(n3);
            this.GetSpriteHead(0);
            int n6 = this.ACTStructInfo.SpriteNum;
            int n7 = n5 < n6 ? n5 : this.ACTStructInfo.SpriteNum;
            for (int i2 = n4; i2 < n7; ++i2) {
                int n8 = this.GetSpriteResID(i2) & 0xFFFF;
                if (this.SpriteResACTInfo[n8].RESACTIdx != -1) continue;
                this.ReadSpriteResInfo(i2, n3);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void LoadACT(int n2, int n3, int n4) {
        int n5 = this.mACTLibBeg;
        int n6 = this.nMaxSpriteResNum;
        if ((n2 += n5) >= n6) {
            return;
        }
        this.InitSpriteResInfo(n4, n2, n3);
        this.CloseSpriteACTFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void LoadACT(int n2, int n3, int n4, int n5) {
        int n6 = this.mACTLibBeg;
        int n7 = this.nMaxSpriteResNum;
        if ((n2 += n6) >= n7) {
            return;
        }
        this.InitSpriteResInfo(n5, n2, n3, n4);
        this.CloseSpriteACTFile();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LoadACT(int n2, int n3) {
        void var4_8;
        Object var3_3 = null;
        short s2 = this.pSpriteResSegInfo[n2].SegIdx;
        int n4 = this.mACTLibBeg;
        if (s2 == (n2 += n4)) {
            return (boolean)var4_8;
        }
        boolean bl = this.LoadSpriteResInfo(n3, n2);
        if (bl) {
            short s3;
            this.CloseSpriteACTFile();
            SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
            spriteResSeg.SegIdx = s3 = (short)n2;
        }
        boolean bl2 = bl;
        return (boolean)var4_8;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LoadSpriteACTFile(int n2) {
        void var3_9;
        int n3 = 0;
        Context context = this.mContext;
        RESApp rESApp = new RESApp(context);
        rESApp.OpenRes(n2);
        int n4 = rESApp.getLength();
        if (n4 > 0) {
            int n5;
            SpriteACTFILE spriteACTFILE = this.cSpriteACTFile;
            spriteACTFILE.nACTBuffLen = n5 = rESApp.getLength();
            SpriteACTFILE spriteACTFILE2 = this.cSpriteACTFile;
            byte[] byArray = new byte[this.cSpriteACTFile.nACTBuffLen];
            spriteACTFILE2.pACTBuff = byArray;
            byte[] byArray2 = this.cSpriteACTFile.pACTBuff;
            int n6 = this.cSpriteACTFile.nACTBuffLen;
            rESApp.ResRead(byArray2, n3, n6);
            rESApp.CloseRes();
            return (boolean)var3_9;
        }
        rESApp.CloseRes();
        int n7 = n3;
        return (boolean)var3_9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean LoadSpriteResInfo(int n2, int n3) {
        int n4;
        int n5 = 1;
        Object var4_4 = null;
        Object var5_5 = null;
        int n6 = this.bLoadingSpriteRes;
        if (n6 == 0) {
            n6 = this.nMaxSpriteResNum;
            if (n3 >= n6) {
                return n5 != 0;
            }
            boolean bl = this.LoadSpriteACTFile(n2);
            if (!bl) {
                int n7 = n5;
                return n6 != 0;
            }
            this.GetFileHead(n3);
            this.nCurSegLoadedSpriteNum = (int)var4_4;
            this.nCurSpriteFileNum = (int)var4_4;
            this.bLoadingSpriteRes = n5;
        }
        if ((n6 = this.nCurSpriteFileNum) >= (n4 = this.ACTStructInfo.FileNum)) {
            this.bLoadingSpriteRes = var4_4;
            boolean bl = true;
        } else {
            n6 = this.nCurSpriteFileNum;
            this.GetSpriteHead(n6);
            int n8 = 0;
            while (true) {
                if (n8 >= (n6 = this.ACTStructInfo.SpriteNum)) {
                    n6 = this.nCurSegLoadedSpriteNum;
                    int n9 = this.ACTStructInfo.SpriteNum;
                    this.nCurSegLoadedSpriteNum = n6 += n9;
                    n6 = this.nCurSpriteFileNum;
                    this.nCurSpriteFileNum = ++n6;
                    break;
                }
                int n10 = this.GetSpriteResID(n8) & 0xFFFF;
                n6 = this.SpriteResACTInfo[n10].RESACTIdx;
                if (n6 == -1) {
                    this.ReadSpriteResInfo(n8, n3);
                }
                ++n8;
            }
        }
        Object var6_10 = var5_5;
        return n6 != 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean OnDraw(Canvas canvas, int n2, int n3, int n4, Paint paint) {
        int n5;
        int n6;
        boolean bl;
        if (n2 == 0) {
            boolean bl2 = bl = null;
            this.nCurFlushSpriteNum = bl2 ? 1 : 0;
        }
        if ((n6 = this.nCurFlushSpriteNum) < (n5 = this.nShowSpriteNum)) {
            int n7 = null;
            while (n7 < (n6 = this.nShowSpriteNum)) {
                void var9_17;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                short s2 = this.Sprite[n7].SpriteResID;
                n6 = -1;
                if (!(s2 == n6 || (n12 = (n6 = this.Sprite[n7].SpriteAttrib)) != (n11 = n2) || (n10 = this.Sprite[n7].SpriteYVal) < (n6 = this.nViewRc.top) && n10 > (n6 = this.nViewRc.bottom) || (n9 = this.Sprite[n7].SpriteXVal) < (n6 = this.nViewRc.left) && n9 > (n6 = this.nViewRc.right))) {
                    int n13;
                    Bitmap bitmap;
                    float f2;
                    float f3;
                    float f4 = this.Sprite[n7].Rotate - null;
                    float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
                    if (f5 == false && (f5 = (f3 = this.Sprite[n7].ScaleX - 1065353216) == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1)) == false && (f5 = (f2 = this.Sprite[n7].ScaleY - 1065353216) == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1)) == false) {
                        bitmap = this.SpriteRes[s2].Sprite;
                        int n14 = n9 + n3;
                        short s3 = this.Sprite[n7].SpriteCenterX;
                        float f6 = n14 - s3;
                        int n15 = n10 + n4;
                        short s4 = this.Sprite[n7].SpriteCenterY;
                        float f7 = n15 - s4;
                        Canvas canvas2 = canvas;
                        Bitmap bitmap2 = bitmap;
                        float f8 = f6;
                        float f9 = f7;
                        Paint paint2 = paint;
                        canvas2.drawBitmap(bitmap2, f8, f9, paint2);
                    } else {
                        int n16 = n9 + n3;
                        short s5 = this.Sprite[n7].SpriteCenterX;
                        int n17 = n16 - s5;
                        n16 = n10 + n4;
                        short s6 = this.Sprite[n7].SpriteCenterY;
                        int n18 = n16 - s6;
                        Matrix matrix = this.cMatrix;
                        float f10 = n17;
                        float f11 = n18;
                        matrix.setTranslate(f10, f11);
                        matrix = this.cMatrix;
                        float f12 = this.Sprite[n7].ScaleX;
                        float f13 = this.Sprite[n7].ScaleY;
                        float f14 = n9 + n3;
                        float f15 = n10 + n4;
                        matrix.postScale(f12, f13, f14, f15);
                        short s7 = this.Sprite[n7].RotateX;
                        if (s7 != -1 && (s7 = this.Sprite[n7].RotateY) != -1) {
                            bitmap = this.cMatrix;
                            float f16 = this.Sprite[n7].Rotate;
                            float f17 = this.Sprite[n7].RotateX + n3;
                            float f18 = this.Sprite[n7].RotateY + n4;
                            bitmap.postRotate(f16, f17, f18);
                        } else {
                            bitmap = this.cMatrix;
                            float f19 = this.Sprite[n7].Rotate;
                            float f20 = n9 + n3;
                            float f21 = n10 + n4;
                            bitmap.postRotate(f19, f20, f21);
                        }
                        bitmap = this.SpriteRes[s2].Sprite;
                        Matrix matrix2 = this.cMatrix;
                        Canvas canvas3 = canvas;
                        Bitmap bitmap3 = bitmap;
                        Matrix matrix3 = matrix2;
                        Paint paint3 = paint;
                        canvas3.drawBitmap(bitmap3, matrix3, paint3);
                    }
                    n6 = this.nCurFlushSpriteNum;
                    this.nCurFlushSpriteNum = n13 = ++n6;
                }
                if ((n6 = this.nCurFlushSpriteNum) == (n8 = this.nShowSpriteNum)) {
                    return bl;
                }
                ++var9_17;
            }
        }
        Object var6_8 = null;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean OnDraw(Canvas canvas, int n2, Paint paint) {
        int n3;
        int n4;
        Object var4_4 = null;
        if (n2 == 0) {
            this.nCurFlushSpriteNum = (int)var4_4;
        }
        if ((n4 = this.nCurFlushSpriteNum) < (n3 = this.nShowSpriteNum)) {
            int n5 = null;
            while (n5 < (n4 = this.nShowSpriteNum)) {
                void var7_10;
                int n6;
                int n7;
                int n8;
                short s2 = this.Sprite[n5].SpriteResID;
                n4 = -1;
                if (!(s2 == n4 || (n4 = this.Sprite[n5].SpriteAttrib) != n2 || (n8 = this.Sprite[n5].SpriteYVal) < (n4 = this.nViewRc.top) && n8 > (n4 = this.nViewRc.bottom) || (n7 = this.Sprite[n5].SpriteXVal) < (n4 = this.nViewRc.left) && n7 > (n4 = this.nViewRc.right))) {
                    Bitmap bitmap = this.SpriteRes[s2].Sprite;
                    short s3 = this.Sprite[n5].SpriteCenterX;
                    float f2 = n7 - s3;
                    short s4 = this.Sprite[n5].SpriteCenterY;
                    float f3 = n8 - s4;
                    canvas.drawBitmap(bitmap, f2, f3, paint);
                    n4 = this.nCurFlushSpriteNum;
                    this.nCurFlushSpriteNum = ++n4;
                }
                if ((n4 = this.nCurFlushSpriteNum) == (n6 = this.nShowSpriteNum)) {
                    return 1 != 0;
                }
                ++var7_10;
            }
        }
        Object var5_6 = var4_4;
        return n4 != 0;
    }

    public void SetACTLibBeg(int n2) {
        this.mACTLibBeg = n2;
    }

    public void SetBMPSizeOut(boolean bl) {
        this.mIsLogOut = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int WriteSprite(int n2, int n3, int n4, int n5) {
        short s2;
        short s3;
        short s4;
        int n6 = 65535;
        int n7 = 1065353216;
        int n8 = -1;
        int n9 = -1;
        int n10 = this.nShowSpriteNum;
        int n11 = this.nMaxSpriteNum;
        if (n10 >= n11) {
            return n9;
        }
        if (n2 < 2130837504) {
            return n9;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n12 = n2 & n6;
        if (spriteRESACTINFOArray[n12].RESACTIdx != n8) {
            n9 = n2 & n6;
        }
        if (n9 == n8) return n9;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n13 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n13];
        spriteDEF.SpriteResID = s4 = (short)n9;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray2[n14].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray3[n15].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray4[n16].Rotate = (float)null;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        spriteDEFArray5[n17].ScaleX = n7;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        spriteDEFArray6[n18].ScaleY = n7;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n19];
        spriteDEF2.SpriteCenterX = s3 = (short)this.SpriteRes[n9].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n20 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n20];
        spriteDEF3.SpriteCenterY = s2 = (short)this.SpriteRes[n9].SpriteCenterY;
        SpriteDEF[] spriteDEFArray9 = this.Sprite;
        int n21 = this.nShowSpriteNum;
        spriteDEFArray9[n21].RotateX = (short)n8;
        SpriteDEF[] spriteDEFArray10 = this.Sprite;
        int n22 = this.nShowSpriteNum;
        spriteDEFArray10[n22].RotateY = (short)n8;
        n9 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray11 = this.Sprite;
        int n23 = this.nShowSpriteNum;
        int n24 = n23 + 1;
        this.nShowSpriteNum = n8;
        spriteDEFArray11[n23].SpriteAttrib = n5;
        return n9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3) {
        short s2;
        short s3;
        short s4;
        int n6 = 65535;
        int n7 = -1;
        int n8 = -1;
        int n9 = this.nShowSpriteNum;
        int n10 = this.nMaxSpriteNum;
        if (n9 >= n10) {
            return n8;
        }
        if (n2 < 2130837504) {
            return n8;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n11 = n2 & n6;
        if (spriteRESACTINFOArray[n11].RESACTIdx != n7) {
            n8 = n2 & n6;
        }
        if (n8 == n7) return n8;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n12 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n12];
        spriteDEF.SpriteResID = s4 = (short)n8;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray2[n13].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray3[n14].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray4[n15].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray5[n16].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        spriteDEFArray6[n17].ScaleY = f3;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n18];
        spriteDEF2.SpriteCenterX = s3 = (short)this.SpriteRes[n8].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n19];
        spriteDEF3.SpriteCenterY = s2 = (short)this.SpriteRes[n8].SpriteCenterY;
        SpriteDEF[] spriteDEFArray9 = this.Sprite;
        int n20 = this.nShowSpriteNum;
        spriteDEFArray9[n20].RotateX = (short)n7;
        SpriteDEF[] spriteDEFArray10 = this.Sprite;
        int n21 = this.nShowSpriteNum;
        spriteDEFArray10[n21].RotateY = (short)n7;
        n8 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray11 = this.Sprite;
        int n22 = this.nShowSpriteNum;
        int n23 = n22 + 1;
        this.nShowSpriteNum = n7;
        spriteDEFArray11[n22].SpriteAttrib = n5;
        return n8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3, float f4, short s2, short s3) {
        int n6;
        short s4;
        short s5;
        short s6;
        int n7 = -1;
        short s7 = 65535;
        int n8 = -1;
        int n9 = this.nShowSpriteNum;
        int n10 = this.nMaxSpriteNum;
        if (n9 >= n10) {
            return n8;
        }
        if (n2 < 2130837504) {
            return n8;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n11 = n2 & s7;
        if (spriteRESACTINFOArray[n11].RESACTIdx != n7) {
            n8 = n2 & s7;
        }
        if (n8 == n7) return n8;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n12 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n12];
        spriteDEF.SpriteResID = s6 = (short)n8;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray2[n13].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray3[n14].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray4[n15].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray5[n16].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        spriteDEFArray6[n17].ScaleY = f4;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n18];
        spriteDEF2.SpriteCenterX = s5 = (short)this.SpriteRes[n8].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n19];
        spriteDEF3.SpriteCenterY = s4 = (short)this.SpriteRes[n8].SpriteCenterY;
        if (s2 != s7) {
            SpriteDEF[] spriteDEFArray9 = this.Sprite;
            int n20 = this.nShowSpriteNum;
            spriteDEFArray9[n20].RotateX = s2;
        } else {
            short s8;
            SpriteDEF[] spriteDEFArray10 = this.Sprite;
            int n21 = this.nShowSpriteNum;
            SpriteDEF spriteDEF4 = spriteDEFArray10[n21];
            SpriteDEF[] spriteDEFArray11 = this.Sprite;
            int n22 = this.nShowSpriteNum;
            spriteDEF4.RotateX = s8 = spriteDEFArray11[n22].SpriteCenterX;
        }
        if (s2 != s7) {
            SpriteDEF[] spriteDEFArray12 = this.Sprite;
            int n23 = this.nShowSpriteNum;
            spriteDEFArray12[n23].RotateY = s3;
        } else {
            short s9;
            SpriteDEF[] spriteDEFArray13 = this.Sprite;
            int n24 = this.nShowSpriteNum;
            SpriteDEF spriteDEF5 = spriteDEFArray13[n24];
            SpriteDEF[] spriteDEFArray14 = this.Sprite;
            int n25 = this.nShowSpriteNum;
            spriteDEF5.RotateY = s9 = spriteDEFArray14[n25].SpriteCenterY;
        }
        n8 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray15 = this.Sprite;
        int n26 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n26 + 1;
        spriteDEFArray15[n26].SpriteAttrib = n5;
        return n8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3, short s2, short s3) {
        int n6;
        short s4;
        short s5;
        short s6;
        int n7 = -1;
        short s7 = 65535;
        int n8 = -1;
        int n9 = this.nShowSpriteNum;
        int n10 = this.nMaxSpriteNum;
        if (n9 >= n10) {
            return n8;
        }
        if (n2 < 2130837504) {
            return n8;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n11 = n2 & s7;
        if (spriteRESACTINFOArray[n11].RESACTIdx != n7) {
            n8 = n2 & s7;
        }
        if (n8 == n7) return n8;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n12 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n12];
        spriteDEF.SpriteResID = s6 = (short)n8;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray2[n13].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray3[n14].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray4[n15].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray5[n16].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        spriteDEFArray6[n17].ScaleY = f3;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n18];
        spriteDEF2.SpriteCenterX = s5 = (short)this.SpriteRes[n8].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n19];
        spriteDEF3.SpriteCenterY = s4 = (short)this.SpriteRes[n8].SpriteCenterY;
        if (s2 != s7) {
            SpriteDEF[] spriteDEFArray9 = this.Sprite;
            int n20 = this.nShowSpriteNum;
            spriteDEFArray9[n20].RotateX = s2;
        } else {
            short s8;
            SpriteDEF[] spriteDEFArray10 = this.Sprite;
            int n21 = this.nShowSpriteNum;
            SpriteDEF spriteDEF4 = spriteDEFArray10[n21];
            SpriteDEF[] spriteDEFArray11 = this.Sprite;
            int n22 = this.nShowSpriteNum;
            spriteDEF4.RotateX = s8 = spriteDEFArray11[n22].SpriteCenterX;
        }
        if (s2 != s7) {
            SpriteDEF[] spriteDEFArray12 = this.Sprite;
            int n23 = this.nShowSpriteNum;
            spriteDEFArray12[n23].RotateY = s3;
        } else {
            short s9;
            SpriteDEF[] spriteDEFArray13 = this.Sprite;
            int n24 = this.nShowSpriteNum;
            SpriteDEF spriteDEF5 = spriteDEFArray13[n24];
            SpriteDEF[] spriteDEFArray14 = this.Sprite;
            int n25 = this.nShowSpriteNum;
            spriteDEF5.RotateY = s9 = spriteDEFArray14[n25].SpriteCenterY;
        }
        n8 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray15 = this.Sprite;
        int n26 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n26 + 1;
        spriteDEFArray15[n26].SpriteAttrib = n5;
        return n8;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void release() {
        Object var2_2;
        boolean bl;
        block5: {
            int n2;
            int n3;
            bl = false;
            var2_2 = null;
            boolean bl2 = true;
            while (true) {
                void var3_5;
                block8: {
                    block7: {
                        int n4;
                        block6: {
                            if (!bl2 || (bl2 = false)) break block6;
                            if (this.SpriteRes == null) break block7;
                            n3 = null;
                        }
                        if (n3 < (n4 = this.nMaxSpriteResNum)) break block8;
                    }
                    this.SpriteRes = (SpriteResDEF[])bl;
                    this.nMaxSpriteResNum = (int)var2_2;
                    this.SpriteResACTInfo = (SpriteRESACTINFO[])bl;
                    this.nCurSpriteFileNum = (int)var2_2;
                    this.bLoadingSpriteRes = var2_2;
                    this.pSpriteResSegInfo = (SpriteResSeg[])bl;
                    this.nCurSegLoadedSpriteNum = (int)var2_2;
                    this.ACTStructInfo = (ACTStruct)bl;
                    if (this.Sprite != null) {
                        Object var3_4 = null;
                        break;
                    }
                    break block5;
                }
                if (this.SpriteRes[n3] != null) {
                    this.SpriteRes[n3].release();
                }
                ++var3_5;
            }
            while (n3 < (n2 = this.nMaxSpriteNum)) {
                void var3_6;
                this.Sprite[n3].release();
                ++var3_6;
            }
        }
        this.Sprite = (SpriteDEF[])bl;
        this.nMaxSpriteNum = (int)var2_2;
        this.nShowSpriteNum = (int)var2_2;
        this.CloseSpriteACTFile();
    }

    class SpriteACTFILE {
        int nACTBuffLen = (int)null;
        byte[] pACTBuff = null;

        public void release() {
            if (this.pACTBuff != null) {
                this.pACTBuff = null;
            }
            this.nACTBuffLen = (int)null;
        }
    }

    class SpriteRESACTINFO {
        short RESACTIdx = (short)-1;
    }
}

