/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class ResEnumAttr
extends ResAttr {
    private final Duo<ResReferenceValue, ResIntValue>[] mItems;
    private final Map<Integer, String> mItemsCache = new HashMap<Integer, String>();

    ResEnumAttr(ResReferenceValue parent, int type, Integer min, Integer max, Boolean l10n, Duo<ResReferenceValue, ResIntValue>[] items) {
        super(parent, type, min, max, l10n);
        this.mItems = items;
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        String ret;
        if (value instanceof ResIntValue && (ret = this.decodeValue(((ResIntValue)value).getValue())) != null) {
            return ret;
        }
        return super.convertToResXmlFormat(value);
    }

    @Override
    protected void serializeBody(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        for (Duo<ResReferenceValue, ResIntValue> duo : this.mItems) {
            int intVal = ((ResIntValue)duo.m2).getValue();
            serializer.startTag(null, "enum");
            serializer.attribute(null, "name", ((ResReferenceValue)duo.m1).getReferent().getName());
            serializer.attribute(null, "value", String.valueOf(intVal));
            serializer.endTag(null, "enum");
        }
    }

    private String decodeValue(int value) throws AndrolibException {
        String value2 = this.mItemsCache.get(value);
        if (value2 == null) {
            ResReferenceValue ref = null;
            for (Duo<ResReferenceValue, ResIntValue> duo : this.mItems) {
                if (((ResIntValue)duo.m2).getValue() != value) continue;
                ref = (ResReferenceValue)duo.m1;
                break;
            }
            if (ref != null) {
                value2 = ref.getReferent().getName();
                this.mItemsCache.put(value, value2);
            }
        }
        return value2;
    }
}

