/*
 * Decompiled with CFR 0.152.
 */
package com.mindprod.ledatastream;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LEDataInputStream
implements DataInput {
    private static final String EMBEDDED_COPYRIGHT = "copyright (c) 1999-2010 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected final DataInputStream dis;
    protected final InputStream is;
    protected final byte[] work;

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public LEDataInputStream(InputStream in) {
        this.is = in;
        this.dis = new DataInputStream(in);
        this.work = new byte[8];
    }

    public final void close() throws IOException {
        this.dis.close();
    }

    public final int read(byte[] ba, int off, int len) throws IOException {
        return this.is.read(ba, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    @Override
    public final char readChar() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (char)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] ba) throws IOException {
        this.dis.readFully(ba, 0, ba.length);
    }

    @Override
    public final void readFully(byte[] ba, int off, int len) throws IOException {
        this.dis.readFully(ba, off, len);
    }

    @Override
    public final int readInt() throws IOException {
        this.dis.readFully(this.work, 0, 4);
        return this.work[3] << 24 | (this.work[2] & 0xFF) << 16 | (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    @Override
    public final String readLine() throws IOException {
        return this.dis.readLine();
    }

    @Override
    public final long readLong() throws IOException {
        this.dis.readFully(this.work, 0, 8);
        return (long)this.work[7] << 56 | (long)(this.work[6] & 0xFF) << 48 | (long)(this.work[5] & 0xFF) << 40 | (long)(this.work[4] & 0xFF) << 32 | (long)(this.work[3] & 0xFF) << 24 | (long)(this.work[2] & 0xFF) << 16 | (long)(this.work[1] & 0xFF) << 8 | (long)(this.work[0] & 0xFF);
    }

    @Override
    public final short readShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (short)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    @Override
    public final String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }
}

