/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction3rms
extends Instruction
implements RegisterRangeInstruction,
OdexedInvokeVirtual {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private short startReg;
    private short vtableIndex;

    public Instruction3rms(Opcode opcode, short regCount, int startReg, int vtableIndex) {
        super(opcode);
        if (regCount >= 256) {
            throw new RuntimeException("regCount must be less than 256");
        }
        if (regCount < 0) {
            throw new RuntimeException("regCount cannot be negative");
        }
        if (startReg >= 65536) {
            throw new RuntimeException("The beginning register of the range must be less than 65536");
        }
        if (startReg < 0) {
            throw new RuntimeException("The beginning register of the range cannot be negative");
        }
        if (vtableIndex >= 65536) {
            throw new RuntimeException("The method index must be less than 65536");
        }
        this.regCount = (byte)regCount;
        this.startReg = (short)startReg;
        this.vtableIndex = (short)vtableIndex;
    }

    private Instruction3rms(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regCount = (byte)NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
        this.vtableIndex = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 4);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount);
        out.writeShort(this.vtableIndex);
        out.writeShort(this.startReg);
    }

    public Format getFormat() {
        return Format.Format3rms;
    }

    public int getRegCount() {
        return (short)(this.regCount & 0xFF);
    }

    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    public int getVtableIndex() {
        return this.vtableIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction3rms(opcode, buffer, bufferIndex);
        }
    }
}

