/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.InstructionWithJumboReference;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction41c
extends InstructionWithJumboReference
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private short regA;

    public Instruction41c(Opcode opcode, int regA, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        if (opcode == Opcode.NEW_INSTANCE_JUMBO) {
            assert (referencedItem instanceof TypeIdItem);
            if (((TypeIdItem)referencedItem).getTypeDescriptor().charAt(0) != 'L') {
                throw new RuntimeException("Only class references can be used with the new-instance/jumbo opcode");
            }
        }
        this.regA = (short)regA;
    }

    private Instruction41c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        if (opcode == Opcode.NEW_INSTANCE_JUMBO && ((TypeIdItem)this.getReferencedItem()).getTypeDescriptor().charAt(0) != 'L') {
            throw new RuntimeException("Only class references can be used with the new-instance/jumbo opcode");
        }
        this.regA = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 6);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(255);
        out.writeByte(this.opcode.value);
        out.writeInt(this.getReferencedItem().getIndex());
        out.writeShort(this.getRegisterA());
    }

    public Format getFormat() {
        return Format.Format41c;
    }

    public int getRegisterA() {
        return this.regA & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction41c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

