/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VerificationErrorType {
    None(0, "no-error"),
    Generic(1, "generic-error"),
    NoClass(2, "no-such-class"),
    NoField(3, "no-such-field"),
    NoMethod(4, "no-such-method"),
    AccessClass(5, "illegal-class-access"),
    AccessField(6, "illegal-field-access"),
    AccessMethod(7, "illegal-method-access"),
    ClassChange(8, "class-change-error"),
    Instantiation(9, "instantiation-error");

    private static HashMap<String, VerificationErrorType> verificationErrorTypesByName;
    private int value;
    private String name;

    private VerificationErrorType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static VerificationErrorType fromString(String validationErrorType) {
        return verificationErrorTypesByName.get(validationErrorType);
    }

    public static VerificationErrorType getValidationErrorType(int validationErrorType) {
        switch (validationErrorType) {
            case 0: {
                return None;
            }
            case 1: {
                return Generic;
            }
            case 2: {
                return NoClass;
            }
            case 3: {
                return NoField;
            }
            case 4: {
                return NoMethod;
            }
            case 5: {
                return AccessClass;
            }
            case 6: {
                return AccessField;
            }
            case 7: {
                return AccessMethod;
            }
            case 8: {
                return ClassChange;
            }
            case 9: {
                return Instantiation;
            }
        }
        return null;
    }

    static {
        verificationErrorTypesByName = new HashMap();
        for (VerificationErrorType verificationErrorType : VerificationErrorType.values()) {
            verificationErrorTypesByName.put(verificationErrorType.getName(), verificationErrorType);
        }
    }
}

