/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Transformer;

public class ExceptionHandlerCurrectTransformer
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        Local ex = null;
        for (Trap t : irMethod.traps) {
            LabelStmt handler = t.handler;
            Stmt st = handler.getNext();
            Stmt pre = handler.getPre();
            while (st.st == Stmt.ST.LABEL) {
                st = st.getNext();
            }
            while (pre.st == Stmt.ST.LABEL) {
                pre = pre.getPre();
            }
            if (!this.needInsertMoveExceptionRef(st) || !this.needInsertGoto(pre)) continue;
            LabelStmt lbl = Stmts.nLabel();
            JumpStmt g = Stmts.nGoto(lbl);
            irMethod.stmts.insertAftre(pre, g);
            irMethod.stmts.insertBefore(st, lbl);
            if (ex == null) {
                ex = Exprs.nLocal("unRefEx");
            }
            irMethod.stmts.insertBefore(lbl, Stmts.nAssign(ex, Exprs.nExceptionRef(t.type)));
        }
        if (ex != null) {
            irMethod.locals.add(ex);
        }
    }

    private boolean needInsertGoto(Stmt pre) {
        switch (pre.st) {
            case RETURN: 
            case GOTO: 
            case RETURN_VOID: 
            case THROW: {
                return false;
            }
        }
        return true;
    }

    private boolean needInsertMoveExceptionRef(Stmt st) {
        return st.st != Stmt.ST.ASSIGN || ((AssignStmt)st).op2.value.vt != Value.VT.EXCEPTION_REF;
    }
}

