/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.LocalVar;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LocalSplit
implements Transformer {
    static ValueBox exec(ValueBox vb, Phi[] currentFrame) {
        if (vb == null) {
            return null;
        }
        Value v = vb.value;
        switch (v.et) {
            case E0: {
                if (v.vt != Value.VT.LOCAL) break;
                Local local = LocalSplit.trim(currentFrame[((Local)v)._ls_index]);
                ++local._ls_read_count;
                vb = local._ls_vb;
                break;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)v;
                e1.op = LocalSplit.exec(e1.op, currentFrame);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)v;
                e2.op1 = LocalSplit.exec(e2.op1, currentFrame);
                e2.op2 = LocalSplit.exec(e2.op2, currentFrame);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)v;
                for (int i = 0; i < en.ops.length; ++i) {
                    en.ops[i] = LocalSplit.exec(en.ops[i], currentFrame);
                }
                break;
            }
        }
        return vb;
    }

    static Local trim(ValueBox vb) {
        Local local = (Local)vb.value;
        if (local == null) {
            return null;
        }
        while (local._ls_vb.value != local) {
            local = (Local)local._ls_vb.value;
        }
        return local;
    }

    @Override
    public void transform(IrMethod jm) {
        final int orgLocalSize = jm.locals.size();
        StmtList list = jm.stmts;
        int i = 0;
        while (i < orgLocalSize) {
            Local local = jm.locals.get(i);
            local._ls_index = i++;
        }
        jm.locals.clear();
        Cfg.createCFG(jm);
        final ArrayList<Stmt> _ls_visit_order = new ArrayList<Stmt>(list.getSize());
        final int[] localId = new int[]{0};
        Cfg.Forward(jm, new Cfg.FrameVisitor<Phi[]>(){
            Phi[] tmp;
            {
                this.tmp = new Phi[orgLocalSize];
            }

            private void doLocalRef(ValueBox vb, Phi[] frame) {
                if (vb == null) {
                    return;
                }
                Value v = vb.value;
                switch (v.et) {
                    case E0: {
                        ValueBox nvb;
                        if (v.vt != Value.VT.LOCAL) break;
                        Phi p = frame[((Local)v)._ls_index];
                        if (p.value != null) break;
                        int n = localId[0];
                        localId[0] = n + 1;
                        Local local = new Local("a" + n);
                        local._ls_vb = nvb = new ValueBox(local);
                        p.setLocal(local);
                        break;
                    }
                    case E1: {
                        Value.E1Expr e1 = (Value.E1Expr)v;
                        this.doLocalRef(e1.op, frame);
                        break;
                    }
                    case E2: {
                        Value.E2Expr e2 = (Value.E2Expr)v;
                        this.doLocalRef(e2.op1, frame);
                        this.doLocalRef(e2.op2, frame);
                        break;
                    }
                    case En: {
                        Value.EnExpr en = (Value.EnExpr)v;
                        for (ValueBox op : en.ops) {
                            this.doLocalRef(op, frame);
                        }
                        break;
                    }
                }
            }

            @Override
            public Phi[] exec(Stmt stmt) {
                _ls_visit_order.add(stmt);
                Phi[] currentFrame = (Phi[])stmt._ls_forward_frame;
                if (currentFrame == null) {
                    currentFrame = new Phi[orgLocalSize];
                    stmt._ls_forward_frame = currentFrame;
                    for (int i = 0; i < currentFrame.length; ++i) {
                        currentFrame[i] = new Phi();
                    }
                }
                System.arraycopy(currentFrame, 0, this.tmp, 0, this.tmp.length);
                switch (stmt.et) {
                    case E0: {
                        break;
                    }
                    case E1: {
                        Stmt.E1Stmt e1 = (Stmt.E1Stmt)stmt;
                        this.doLocalRef(e1.op, this.tmp);
                        break;
                    }
                    case E2: {
                        Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                        if (e2.op1.value.vt == Value.VT.LOCAL) {
                            Phi phi;
                            this.doLocalRef(e2.op2, this.tmp);
                            this.tmp[((Local)e2.op1.value)._ls_index] = phi = new Phi();
                            e2.op1 = phi;
                            break;
                        }
                        this.doLocalRef(e2.op1, this.tmp);
                        this.doLocalRef(e2.op2, this.tmp);
                        break;
                    }
                    case En: {
                        Stmt.EnStmt en = (Stmt.EnStmt)stmt;
                        for (ValueBox op : en.ops) {
                            this.doLocalRef(op, this.tmp);
                        }
                        break;
                    }
                }
                return this.tmp;
            }

            @Override
            public void merge(Phi[] sourceF, Stmt distStmt) {
                Phi[] targetF = (Phi[])distStmt._ls_forward_frame;
                int dist_froms_size = distStmt._cfg_froms.size();
                if (targetF != null) {
                    for (int i = 0; i < targetF.length; ++i) {
                        Phi source = sourceF[i];
                        Phi target = targetF[i];
                        if (target.parent == null) {
                            target.parent = new ArrayList<Phi>(dist_froms_size);
                        }
                        target.parent.add(source);
                        if (target.value == null) continue;
                        source.setLocal(LocalSplit.trim(((Local)target.value)._ls_vb));
                    }
                } else {
                    targetF = new Phi[orgLocalSize];
                    distStmt._ls_forward_frame = targetF;
                    if (distStmt._cfg_froms.size() > 1) {
                        for (int i = 0; i < targetF.length; ++i) {
                            Phi target = new Phi();
                            target.parent = new ArrayList<Phi>(dist_froms_size);
                            target.parent.add(sourceF[i]);
                            targetF[i] = target;
                        }
                    } else {
                        System.arraycopy(sourceF, 0, targetF, 0, sourceF.length);
                    }
                }
            }
        });
        for (LocalVar var : jm.vars) {
            Stmt stmt = var.start.getNext();
            int index = ((Local)var.reg.value)._ls_index;
            while (stmt.st == Stmt.ST.LABEL) {
                stmt = stmt.getNext();
            }
            Phi[] targetF = (Phi[])stmt._ls_forward_frame;
            Phi p = targetF[index];
            if (p.value == null) {
                ValueBox nvb;
                int n = localId[0];
                localId[0] = n + 1;
                Local local = new Local("a" + n);
                local._ls_vb = nvb = new ValueBox(local);
                p.setLocal(local);
            }
            Local local2 = LocalSplit.trim(p);
            var.reg = local2._ls_vb;
            local2._ls_write_count += 2;
        }
        int unRef = 0;
        HashSet<Local> locals = new HashSet<Local>();
        Iterator<Stmt> it = list.iterator();
        while (it.hasNext()) {
            Stmt st = it.next();
            if (st._ls_forward_frame == null && st.st != Stmt.ST.LABEL) {
                it.remove();
                continue;
            }
            Phi[] currentFrame = (Phi[])st._ls_forward_frame;
            switch (st.et) {
                case E0: {
                    break;
                }
                case E1: {
                    Stmt.E1Stmt e1 = (Stmt.E1Stmt)st;
                    e1.op = LocalSplit.exec(e1.op, currentFrame);
                    break;
                }
                case E2: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    switch (e2.st) {
                        case ASSIGN: 
                        case IDENTITY: {
                            if (e2.op1 instanceof Phi) {
                                Local local = LocalSplit.trim(e2.op1);
                                if (local == null) {
                                    local = new Local("unRef" + unRef++);
                                    local._ls_vb = new ValueBox(local);
                                }
                                locals.add(local);
                                e2.op1 = local._ls_vb;
                                ++local._ls_write_count;
                                if (e2.op2.value.vt != Value.VT.INVOKE_SPECIAL) break;
                                InvokeExpr ie = (InvokeExpr)e2.op2.value;
                                if (!ie.methodName.equals("<init>")) break;
                                list._ls_inits.add((AssignStmt)e2);
                                break;
                            }
                            e2.op1 = LocalSplit.exec(e2.op1, currentFrame);
                            break;
                        }
                        default: {
                            e2.op1 = LocalSplit.exec(e2.op1, currentFrame);
                        }
                    }
                    e2.op2 = LocalSplit.exec(e2.op2, currentFrame);
                    break;
                }
                case En: {
                    Stmt.EnStmt en = (Stmt.EnStmt)st;
                    for (int i2 = 0; i2 < en.ops.length; ++i2) {
                        en.ops[i2] = LocalSplit.exec(en.ops[i2], currentFrame);
                    }
                    break;
                }
            }
            st._ls_forward_frame = null;
        }
        jm.locals.addAll(locals);
        jm.stmts._ls_visit_order = _ls_visit_order;
    }

    private static class Phi
    extends ValueBox {
        public List<Phi> parent;

        public Phi() {
            super(null);
        }

        public void setLocal(Local local) {
            if (this.value != null) {
                Local local2 = LocalSplit.trim(this);
                if (local2 != local) {
                    local2._ls_vb = local._ls_vb;
                }
                this.value = local;
            } else {
                this.value = local;
            }
            if (this.parent != null) {
                for (Phi p : this.parent) {
                    if (p != null && p.value == local) continue;
                    p.setLocal(local);
                }
            }
        }
    }
}

