/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class BarChart
extends XYChart {
    private static final int SHAPE_WIDTH = 12;
    public static final String TYPE = "Bar";
    protected Type mType;

    BarChart() {
        Type type;
        this.mType = type = Type.DEFAULT;
    }

    public BarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Type type2;
        this.mType = type2 = Type.DEFAULT;
        this.mType = type;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawBar(Canvas canvas, float f, float f2, float f3, float f4, int n, int n2, Paint paint) {
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer = this.mRenderer;
        int n3 = n2;
        SimpleSeriesRenderer simpleSeriesRenderer = xYMultipleSeriesRenderer.getSeriesRendererAt(n3);
        if (simpleSeriesRenderer.isGradientEnabled()) {
            int n4;
            double d = simpleSeriesRenderer.getGradientStopValue();
            double[] dArray = new double[]{0L, d};
            BarChart barChart = this;
            int n5 = n;
            float f5 = (float)barChart.toScreenPoint(dArray, n5)[1];
            double d2 = simpleSeriesRenderer.getGradientStartValue();
            double[] dArray2 = new double[]{0L, d2};
            BarChart barChart2 = this;
            int n6 = n;
            float f6 = (float)barChart2.toScreenPoint(dArray2, n6)[1];
            float f7 = f5;
            float f8 = f2;
            float f9 = Math.max(f7, f8);
            float f10 = f4;
            float f11 = Math.min(f6, f10);
            int n7 = simpleSeriesRenderer.getGradientStopColor();
            int n8 = n4 = simpleSeriesRenderer.getGradientStartColor();
            int n9 = n7;
            if (f2 < f5) {
                paint.setColor(n7);
                float f12 = Math.round(f);
                float f13 = Math.round(f2);
                float f14 = Math.round(f3);
                float f15 = Math.round(f9);
                Canvas canvas2 = canvas;
                Paint paint2 = paint;
                canvas2.drawRect(f12, f13, f14, f15, paint2);
            } else {
                float f16 = f6 - f9;
                float f17 = f6 - f5;
                float f18 = f16 / f17;
                n9 = this.getGradientPartialColor(n7, n4, f18);
            }
            if (f4 > f6) {
                paint.setColor(n4);
                float f19 = Math.round(f);
                float f20 = Math.round(f11);
                float f21 = Math.round(f3);
                float f22 = Math.round(f4);
                Canvas canvas3 = canvas;
                Paint paint3 = paint;
                canvas3.drawRect(f19, f20, f21, f22, paint3);
            } else {
                float f23 = f11 - f5;
                float f24 = f6 - f5;
                float f25 = f23 / f24;
                n8 = this.getGradientPartialColor(n4, n7, f25);
            }
            GradientDrawable.Orientation orientation = GradientDrawable.Orientation.BOTTOM_TOP;
            int[] nArray = new int[]{n8, n9};
            GradientDrawable gradientDrawable = new GradientDrawable(orientation, nArray);
            int n10 = Math.round(f);
            int n11 = Math.round(f9);
            int n12 = Math.round(f3);
            int n13 = Math.round(f11);
            gradientDrawable.setBounds(n10, n11, n12, n13);
            Canvas canvas4 = canvas;
            gradientDrawable.draw(canvas4);
            return;
        }
        if (Math.abs(f2 - f4) < 1.0f) {
            f4 = f2 < f4 ? f2 + 1.0f : f2 - 1.0f;
        }
        float f26 = Math.round(f);
        float f27 = Math.round(f2);
        float f28 = Math.round(f3);
        float f29 = Math.round(f4);
        Canvas canvas5 = canvas;
        Paint paint4 = paint;
        canvas5.drawRect(f26, f27, f28, f29, paint4);
    }

    private int getGradientPartialColor(int n, int n2, float f) {
        float f2 = (float)Color.alpha((int)n) * f;
        float f3 = 1.0f - f;
        float f4 = Color.alpha((int)n2);
        float f5 = f3 * f4;
        int n3 = Math.round(f2 + f5);
        float f6 = (float)Color.red((int)n) * f;
        float f7 = 1.0f - f;
        float f8 = Color.red((int)n2);
        float f9 = f7 * f8;
        int n4 = Math.round(f6 + f9);
        float f10 = (float)Color.green((int)n) * f;
        float f11 = 1.0f - f;
        float f12 = Color.green((int)n2);
        float f13 = f11 * f12;
        int n5 = Math.round(f10 + f13);
        float f14 = (float)Color.blue((int)n) * f;
        float f15 = 1.0f - f;
        float f16 = Color.blue((int)n2);
        float f17 = f15 * f16;
        int n6 = Math.round(f14 + f17);
        return Color.argb((int)n3, (int)n4, (int)n5, (int)n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] fArray, double[] dArray, float f, int n, int n2) {
        int n3 = this.mDataset.getSeriesCount();
        int n4 = fArray.length;
        ClickableArea[] clickableAreaArray = new ClickableArea[n4 / 2];
        BarChart barChart = this;
        float[] fArray2 = fArray;
        float f2 = barChart.getHalfDiffX(fArray2, n4, n3);
        int n5 = 0;
        while (n5 < n4) {
            float f3 = fArray[n5];
            int n6 = n5 + 1;
            float f4 = fArray[n6];
            Type type = this.mType;
            Type type2 = Type.STACKED;
            if (type == type2) {
                ClickableArea clickableArea;
                int n7 = n5 / 2;
                float f5 = f3 - f2;
                float f6 = f3 + f2;
                float f7 = f;
                RectF rectF = new RectF(f5, f4, f6, f7);
                double d = dArray[n5];
                int n8 = n5 + 1;
                double d2 = dArray[n8];
                clickableAreaArray[n7] = clickableArea = new ClickableArea(rectF, d, d2);
            } else {
                ClickableArea clickableArea;
                float f8 = (float)n3 * f2;
                float f9 = f3 - f8;
                float f10 = (float)(n * 2) * f2;
                float f11 = f9 + f10;
                int n9 = n5 / 2;
                float f12 = 2.0f * f2 + f11;
                float f13 = f;
                RectF rectF = new RectF(f11, f4, f12, f13);
                double d = dArray[n5];
                int n10 = n5 + 1;
                double d3 = dArray[n10];
                clickableAreaArray[n9] = clickableArea = new ClickableArea(rectF, d, d3);
            }
            n5 += 2;
        }
        return clickableAreaArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawBar(Canvas canvas, float f, float f2, float f3, float f4, float f5, int n, int n2, Paint paint) {
        XYMultipleSeriesDataset xYMultipleSeriesDataset = this.mDataset;
        int n3 = n2;
        int n4 = xYMultipleSeriesDataset.getSeriesAt(n3).getScaleNumber();
        Type type = this.mType;
        Type type2 = Type.STACKED;
        if (type == type2) {
            float f6 = f - f5;
            float f7 = f3 + f5;
            BarChart barChart = this;
            Canvas canvas2 = canvas;
            float f8 = f4;
            float f9 = f2;
            int n5 = n2;
            Paint paint2 = paint;
            barChart.drawBar(canvas2, f6, f8, f7, f9, n4, n5, paint2);
            return;
        }
        float f10 = (float)n * f5;
        float f11 = f - f10;
        float f12 = (float)(n2 * 2) * f5;
        float f13 = f11 + f12;
        float f14 = 2.0f * f5;
        float f15 = f13 + f14;
        BarChart barChart = this;
        Canvas canvas3 = canvas;
        float f16 = f4;
        float f17 = f2;
        int n6 = n2;
        Paint paint3 = paint;
        barChart.drawBar(canvas3, f13, f16, f15, f17, n4, n6, paint3);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, float[] fArray, int n, int n2) {
        int n3 = this.mDataset.getSeriesCount();
        int n4 = fArray.length;
        float[] fArray2 = fArray;
        float f = this.getHalfDiffX(fArray2, n4, n3);
        int n5 = 0;
        int n6;
        while (n5 < (n6 = fArray.length)) {
            int n7 = n5 / 2;
            int n8 = n2 + n7;
            double d = xYSeries.getY(n8);
            if (!this.isNullValue(d)) {
                float f2 = fArray[n5];
                Type type = this.mType;
                Type type2 = Type.DEFAULT;
                if (type == type2) {
                    float f3 = (float)(n * 2) * f;
                    float f4 = ((float)n3 - 1.5f) * f;
                    float f5 = f3 - f4;
                    float f6 = f2 + f5;
                }
                double d2 = xYSeries.getY(n8);
                String string2 = this.getLabel(d2);
                int n9 = n5 + 1;
                float f7 = fArray[n9];
                float f8 = simpleSeriesRenderer.getChartValuesSpacing();
                float f9 = f7 - f8;
                BarChart barChart = this;
                Canvas canvas2 = canvas;
                Paint paint2 = paint;
                barChart.drawText(canvas2, string2, f2, f9, paint2, 0.0f);
            }
            n5 += 2;
        }
        return;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        float f3 = f2 - 6.0f;
        float f4 = f + 12.0f;
        float f5 = f2 + 6.0f;
        Canvas canvas2 = canvas;
        float f6 = f;
        Paint paint2 = paint;
        canvas2.drawRect(f6, f3, f4, f5, paint2);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        int n3 = this.mDataset.getSeriesCount();
        int n4 = fArray.length;
        int n5 = simpleSeriesRenderer.getColor();
        paint.setColor(n5);
        Paint.Style style = Paint.Style.FILL;
        paint.setStyle(style);
        float f2 = this.getHalfDiffX(fArray, n4, n3);
        int n6 = 0;
        while (true) {
            if (n6 >= n4) {
                int n7 = simpleSeriesRenderer.getColor();
                paint.setColor(n7);
                return;
            }
            float f3 = fArray[n6];
            int n8 = n6 + 1;
            float f4 = fArray[n8];
            BarChart barChart = this;
            Canvas canvas2 = canvas;
            float f5 = f;
            float f6 = f3;
            int n9 = n;
            Paint paint2 = paint;
            barChart.drawBar(canvas2, f3, f5, f6, f4, f2, n3, n9, paint2);
            n6 += 2;
        }
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    protected float getCoeficient() {
        return 1065353216;
    }

    @Override
    public double getDefaultMinimum() {
        return 0L;
    }

    protected float getHalfDiffX(float[] fArray, int n, int n2) {
        Type type;
        Type type2;
        float f;
        float f2;
        int n3;
        float f3;
        float f4;
        float f5;
        int n4 = n;
        if (n > 2) {
            n4 = n + -2;
        }
        if ((f5 = (f4 = (f3 = fArray[n3 = n + -2]) - (f2 = fArray[0])) / (f = (float)n4)) == 0.0f) {
            f5 = 10.0f;
        }
        if ((type2 = this.mType) != (type = Type.STACKED)) {
            float f6 = n2;
            f5 /= f6;
        }
        double d = f5;
        double d2 = this.getCoeficient();
        double d3 = this.mRenderer.getBarSpacing();
        double d4 = 1.0 + d3;
        double d5 = d2 * d4;
        return (float)(d / d5);
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 12;
    }

    @Override
    protected boolean isRenderNullValues() {
        return true;
    }

    public final class Type
    extends Enum<Type> {
        public static final /* enum */ Type DEFAULT = new Type();
        private static final /* synthetic */ Type[] ENUM$VALUES;
        public static final /* enum */ Type STACKED = new Type();

        static {
            Type type = DEFAULT;
            Type type2 = STACKED;
            Type[] typeArray = new Type[]{type, type2};
            ENUM$VALUES = typeArray;
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(typeArray, 0, typeArray2, 0, n);
            return typeArray2;
        }
    }
}

