/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYValueSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class BubbleChart
extends XYChart {
    private static final int MAX_BUBBLE_SIZE = 20;
    private static final int MIN_BUBBLE_SIZE = 2;
    private static final int SHAPE_WIDTH = 10;
    public static final String TYPE = "Bubble";

    BubbleChart() {
    }

    public BubbleChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    private void drawCircle(Canvas canvas, Paint paint, float f, float f2, float f3) {
        canvas.drawCircle(f, f2, f3, paint);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] fArray, double[] dArray, float f, int n, int n2) {
        int n3 = fArray.length;
        XYMultipleSeriesDataset xYMultipleSeriesDataset = this.mDataset;
        int n4 = n;
        XYValueSeries xYValueSeries = (XYValueSeries)xYMultipleSeriesDataset.getSeriesAt(n4);
        double d = xYValueSeries.getMaxValue();
        double d2 = 20.0 / d;
        ClickableArea[] clickableAreaArray = new ClickableArea[n3 / 2];
        int n5 = 0;
        while (n5 < n3) {
            ClickableArea clickableArea;
            int n6 = n5 / 2 + n2;
            double d3 = xYValueSeries.getValue(n6) * d2 + 2.0;
            int n7 = n5 / 2;
            float f2 = fArray[n5];
            float f3 = (float)d3;
            float f4 = f2 - f3;
            int n8 = n5 + 1;
            float f5 = fArray[n8];
            float f6 = (float)d3;
            float f7 = f5 - f6;
            float f8 = fArray[n5];
            float f9 = (float)d3;
            float f10 = f8 + f9;
            int n9 = n5 + 1;
            float f11 = fArray[n9];
            float f12 = (float)d3;
            float f13 = f11 + f12;
            RectF rectF = new RectF(f4, f7, f10, f13);
            double d4 = dArray[n5];
            int n10 = n5 + 1;
            double d5 = dArray[n10];
            clickableAreaArray[n7] = clickableArea = new ClickableArea(rectF, d4, d5);
            n5 += 2;
        }
        return clickableAreaArray;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        Paint.Style style = Paint.Style.FILL;
        paint.setStyle(style);
        float f3 = f + 10.0f;
        BubbleChart bubbleChart = this;
        Canvas canvas2 = canvas;
        Paint paint2 = paint;
        float f4 = f2;
        bubbleChart.drawCircle(canvas2, paint2, f3, f4, 3.0f);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        int n3 = ((XYSeriesRenderer)simpleSeriesRenderer).getColor();
        paint.setColor(n3);
        Paint.Style style = Paint.Style.FILL;
        paint.setStyle(style);
        int n4 = fArray.length;
        XYMultipleSeriesDataset xYMultipleSeriesDataset = this.mDataset;
        int n5 = n;
        XYValueSeries xYValueSeries = (XYValueSeries)xYMultipleSeriesDataset.getSeriesAt(n5);
        double d = xYValueSeries.getMaxValue();
        double d2 = 20.0 / d;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n6 / 2 + n2;
            double d3 = xYValueSeries.getValue(n7) * d2 + 2.0;
            float f2 = fArray[n6];
            int n8 = n6 + 1;
            float f3 = fArray[n8];
            float f4 = (float)d3;
            BubbleChart bubbleChart = this;
            Canvas canvas2 = canvas;
            Paint paint2 = paint;
            bubbleChart.drawCircle(canvas2, paint2, f2, f3, f4);
            n6 += 2;
        }
        return;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 10;
    }
}

